/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.runtime.statement;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptStatement;
import org.eclipse.mofscript.runtime.ExecutionEnvironment;
import org.eclipse.mofscript.runtime.ExecutionManager;
import org.eclipse.mofscript.runtime.MofScriptExecutionException;
import org.eclipse.mofscript.runtime.RuleExecutor;
import org.eclipse.mofscript.runtime.Variable;
import org.eclipse.mofscript.runtime.statement.DebugListener;
import org.eclipse.mofscript.runtime.statement.StatementExecutor;

public class DebugStatementExecutor
extends StatementExecutor
implements Runnable {
    private volatile boolean _continueDebug = false;
    private volatile boolean _stopDebug = false;

    public DebugStatementExecutor(MOFScriptStatement statement, ExecutionEnvironment env, RuleExecutor ownerRule) {
        super(statement, env, ownerRule);
    }

    @Override
    public Object executeStatement(Object rule_create) throws MofScriptExecutionException {
        if (ExecutionEnvironment.getDebug()) {
            ArrayList<Variable> allVars = new ArrayList<Variable>();
            allVars.addAll(this._env.getVariables());
            ExecutionEnvironment parent = this._env.getParentEnvironment();
            while (parent != null) {
                allVars.addAll(parent.getVariables());
                parent = parent.getParentEnvironment();
            }
            List<DebugListener> dls = ExecutionManager.getDebugListeners();
            Iterator<DebugListener> dit = dls.iterator();
            while (dit.hasNext()) {
                dit.next().debugEntered(allVars, this._statement.getLine());
            }
            while (!this._continueDebug && !this._stopDebug) {
                try {
                    Thread.sleep(1000L);
                    this._continueDebug = ExecutionEnvironment.getContDebug();
                    this._stopDebug = ExecutionEnvironment.getStopDebug();
                }
                catch (InterruptedException interruptedException) {}
            }
            ExecutionEnvironment.resetDebug();
        }
        return null;
    }

    @Override
    public void run() {
    }
}

