/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.runtime.statement;

import org.eclipse.mofscript.MOFScriptModel.Expression;
import org.eclipse.mofscript.MOFScriptModel.FileStatement;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptStatement;
import org.eclipse.mofscript.MOFScriptModel.ValueExpression;
import org.eclipse.mofscript.runtime.ExecutionEnvironment;
import org.eclipse.mofscript.runtime.MofScriptExecuterFactory;
import org.eclipse.mofscript.runtime.MofScriptExecutionException;
import org.eclipse.mofscript.runtime.RuleExecutor;
import org.eclipse.mofscript.runtime.expression.ExpressionEvaluator;
import org.eclipse.mofscript.runtime.statement.StatementExecutor;

public class FileStatementExecutor
extends StatementExecutor {
    public FileStatementExecutor(MOFScriptStatement statement, ExecutionEnvironment env, RuleExecutor ownerRule) {
        super(statement, env, ownerRule);
    }

    @Override
    public Object executeStatement(Object rule_create) throws MofScriptExecutionException {
        FileStatement fstatement = (FileStatement)this._statement;
        String freference = fstatement.getFileReference();
        ValueExpression fexp = fstatement.getFileURI();
        if (fexp == null) {
            this._env.setCurrentStream(freference);
        } else {
            ExpressionEvaluator expExec = MofScriptExecuterFactory.createExpressionExecutor((Expression)fexp, this._env, this._ownerRule);
            Object expression_object = expExec.evaluateExpression(null);
            try {
                if (expression_object != null) {
                    String filename = expression_object.toString();
                    this._env.setCurrentStream(filename, fstatement.getFileReference());
                }
            }
            catch (Exception ex) {
                this._env.notifyError("#Runtime Error# File statement::" + ex.getClass().getName() + " - " + ex.getMessage() + " (line: " + fstatement.getLine() + ")", expExec);
            }
        }
        return null;
    }
}

