/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.runtime.statement;

import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.mofscript.MOFScriptModel.AssignmentOperator;
import org.eclipse.mofscript.MOFScriptModel.GeneralAssignment;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptStatement;
import org.eclipse.mofscript.runtime.ExecutionEnvironment;
import org.eclipse.mofscript.runtime.MofScriptExecuterFactory;
import org.eclipse.mofscript.runtime.MofScriptExecutionException;
import org.eclipse.mofscript.runtime.RuleExecutor;
import org.eclipse.mofscript.runtime.Variable;
import org.eclipse.mofscript.runtime.expression.ExpressionEvaluator;
import org.eclipse.mofscript.runtime.statement.StatementExecutor;

public class GeneralAssignmentExecutor
extends StatementExecutor {
    public GeneralAssignmentExecutor(MOFScriptStatement statement, ExecutionEnvironment env, RuleExecutor ownerRule) {
        super(statement, env, ownerRule);
    }

    @Override
    public Object executeStatement(Object rule_create) throws MofScriptExecutionException {
        block12: {
            GeneralAssignment assignment = (GeneralAssignment)this._statement;
            try {
                String assignmentName = assignment.getName();
                String[] split = assignmentName.split("\\.");
                Variable var = this._env.findVariable(split[0]);
                ExpressionEvaluator expExec = null;
                if (var != null && split.length > 1) {
                    Object value = var.getValue();
                    if (value == null || !(value instanceof EObject)) break block12;
                    EObject eobj = (EObject)value;
                    EClass eclass = eobj.eClass();
                    String feature = split[1];
                    EStructuralFeature sFeature = eclass.getEStructuralFeature(feature);
                    Object newValue = null;
                    expExec = MofScriptExecuterFactory.createExpressionExecutor(assignment.getExpression(), this._env, this._ownerRule);
                    newValue = expExec.evaluateExpression(null);
                    try {
                        if (newValue == null) break block12;
                        if (newValue instanceof StringBuffer) {
                            newValue = newValue.toString();
                        }
                        if (assignment.getOperator() == AssignmentOperator.EQ_LITERAL) {
                            this.setFeatureValue(eobj, sFeature, newValue, expExec);
                            break block12;
                        }
                        if (assignment.getOperator() != AssignmentOperator.PLUS_EQ_LITERAL) break block12;
                        Object oldValue = eobj.eGet(sFeature);
                        if (oldValue instanceof String || oldValue instanceof StringBuffer) {
                            this.setFeatureValue(eobj, sFeature, String.valueOf(oldValue.toString()) + newValue, expExec);
                            break block12;
                        }
                        if (oldValue instanceof Integer && newValue instanceof Integer) {
                            this.setFeatureValue(eobj, sFeature, new Integer((Integer)oldValue + (Integer)newValue), expExec);
                            break block12;
                        }
                        this.setFeatureValue(eobj, sFeature, newValue, expExec);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    break block12;
                }
                if (var != null) {
                    Object assignedValue = null;
                    expExec = MofScriptExecuterFactory.createExpressionExecutor(assignment.getExpression(), this._env, this._ownerRule);
                    Object expression = expExec.evaluateExpression(null);
                    if (var.isConstant()) {
                        throw new MofScriptExecutionException("Cannot assign value to constant " + var.getName(), this._ownerRule.getRule().getName(), this._statement.getLine(), expExec);
                    }
                    assignedValue = this._env.assignVariableValue(var.getName(), expression, assignment.getOperator(), assignment.getExpression());
                    this.addToEnv(assignedValue, assignmentName);
                } else {
                    this._env.notifyError("#Runtime Error# Variable " + assignment.getName() + " is not defined (line: " + assignment.getLine() + ")", expExec);
                }
            }
            catch (Exception ex) {
                this._env.notifyMessage("#Runtime Error# In assignment: " + assignment.getName() + " " + ex.getMessage() + "(line: " + assignment.getLine() + ")");
            }
        }
        return null;
    }

    protected void setFeatureValue(EObject eobj, EStructuralFeature feature, Object value, ExpressionEvaluator expExec) {
        try {
            if (feature instanceof EAttribute) {
                EClassifier type = ((EAttribute)feature).getEType();
                if (type instanceof EEnum) {
                    EEnum leEnum = (EEnum)type;
                    EEnumLiteral litval = leEnum.getEEnumLiteral((String)value);
                    if (litval != null) {
                        Enumerator enuminstance = litval.getInstance();
                        if (litval != null) {
                            eobj.eSet(feature, (Object)enuminstance);
                        }
                    }
                } else if (type instanceof EDataType) {
                    EDataType dt = (EDataType)type;
                    String cn = dt.getInstanceClassName();
                    if (cn.equals("int")) {
                        if (value instanceof String) {
                            eobj.eSet(feature, (Object)Integer.parseInt((String)value));
                        } else {
                            eobj.eSet(feature, value);
                        }
                    } else if (cn.equals("double")) {
                        if (value instanceof String) {
                            eobj.eSet(feature, (Object)Double.valueOf((String)value));
                        } else {
                            eobj.eSet(feature, value);
                        }
                    } else if (cn.equals("boolean")) {
                        if (value instanceof String) {
                            eobj.eSet(feature, (Object)Boolean.valueOf((String)value));
                        } else {
                            eobj.eSet(feature, value);
                        }
                    } else {
                        eobj.eSet(feature, value);
                    }
                } else {
                    eobj.eSet(feature, value);
                }
            } else if (feature instanceof EReference) {
                EReference cfr_ignored_0 = (EReference)feature;
                eobj.eSet(feature, value);
            }
        }
        catch (Exception ex) {
            this._env.notifyError("#Runtime error in assignment: " + ex.getMessage(), expExec);
        }
    }

    public void addToEnv(Object assignedValue, String assignmentName) {
    }
}

