/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.runtime.statement;

import org.eclipse.emf.common.util.EList;
import org.eclipse.mofscript.MOFScriptModel.Expression;
import org.eclipse.mofscript.MOFScriptModel.IfStatement;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptStatement;
import org.eclipse.mofscript.runtime.ExecutionEnvironment;
import org.eclipse.mofscript.runtime.MofScriptExecuterFactory;
import org.eclipse.mofscript.runtime.MofScriptExecutionException;
import org.eclipse.mofscript.runtime.RuleExecutor;
import org.eclipse.mofscript.runtime.expression.ExpressionEvaluator;
import org.eclipse.mofscript.runtime.statement.StatementExecutor;

public class IfStatementExecutor
extends StatementExecutor {
    public IfStatementExecutor(MOFScriptStatement statement, ExecutionEnvironment env, RuleExecutor ownerRule) {
        super(statement, env, ownerRule);
    }

    @Override
    public Object executeStatement(Object rule_create) throws MofScriptExecutionException {
        IfStatement ifstatement = (IfStatement)this._statement;
        Expression logExp = ifstatement.getIfExpression();
        Object logicalExpressionValue = null;
        StatementExecutor stExec = null;
        Object resultValue = null;
        ExpressionEvaluator expExec = null;
        boolean matches_filter = true;
        if (logExp != null) {
            expExec = MofScriptExecuterFactory.createExpressionExecutor(logExp, this._env, this._ownerRule);
            logicalExpressionValue = expExec.evaluateExpression(null);
            if (logicalExpressionValue instanceof Boolean) {
                matches_filter = (Boolean)logicalExpressionValue;
            } else if (logicalExpressionValue instanceof String) {
                matches_filter = false;
                this._env.notifyError("#Runtime Error# Return value String from logical expression: " + logicalExpressionValue + " (line" + ifstatement.getLine() + ")", expExec);
            } else {
                matches_filter = false;
                this._env.notifyError("#Runtime Error# Return value Object from logical expression: " + logicalExpressionValue + " (line" + ifstatement.getLine() + ")", expExec);
            }
        }
        if (matches_filter) {
            ExecutionEnvironment ifEnv = MofScriptExecuterFactory.createExecutionEnvironment();
            RuleExecutor.getExecutionManager().getExecutionStack().pushEnvironment(ifEnv);
            EList statements = ifstatement.getStatements();
            for (MOFScriptStatement qvtstatement : statements) {
                stExec = MofScriptExecuterFactory.createStatementExecutor(qvtstatement, ifEnv, this._ownerRule);
                resultValue = stExec.executeStatement(rule_create);
                if (!this._ownerRule.isReturning()) continue;
                RuleExecutor.getExecutionManager().getExecutionStack().popEnvironment();
                return resultValue;
            }
            RuleExecutor.getExecutionManager().getExecutionStack().popEnvironment();
            ifEnv = null;
        } else {
            EList elseBranches = ifstatement.getElseBranch();
            IfStatement elseBranch2 = null;
            for (IfStatement elseBranch2 : elseBranches) {
                matches_filter = true;
                logExp = elseBranch2.getIfExpression();
                if (logExp != null && (logicalExpressionValue = (expExec = MofScriptExecuterFactory.createExpressionExecutor(logExp, this._env, this._ownerRule)).evaluateExpression(null)) instanceof Boolean) {
                    matches_filter = (Boolean)logicalExpressionValue;
                }
                if (matches_filter || logExp == null) break;
            }
            if (elseBranch2 != null && matches_filter) {
                ExecutionEnvironment elseEnv = MofScriptExecuterFactory.createExecutionEnvironment();
                RuleExecutor.getExecutionManager().getExecutionStack().pushEnvironment(elseEnv);
                EList statements = elseBranch2.getStatements();
                for (MOFScriptStatement qvtstatement : statements) {
                    stExec = MofScriptExecuterFactory.createStatementExecutor(qvtstatement, elseEnv, this._ownerRule);
                    resultValue = stExec.executeStatement(rule_create);
                    if (!this._ownerRule.isReturning()) continue;
                    RuleExecutor.getExecutionManager().getExecutionStack().popEnvironment();
                    return resultValue;
                }
                RuleExecutor.getExecutionManager().getExecutionStack().popEnvironment();
            }
        }
        return null;
    }
}

