/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.runtime.statement;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.mofscript.MOFScriptModel.Expression;
import org.eclipse.mofscript.MOFScriptModel.IteratorStatement;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptStatement;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptStatementOwner;
import org.eclipse.mofscript.MOFScriptModel.Reference;
import org.eclipse.mofscript.MOFScriptModel.SimpleExpression;
import org.eclipse.mofscript.MOFScriptModel.StatementBlock;
import org.eclipse.mofscript.runtime.ExecutionEnvironment;
import org.eclipse.mofscript.runtime.ExecutionManager;
import org.eclipse.mofscript.runtime.MofScriptExecuterFactory;
import org.eclipse.mofscript.runtime.MofScriptExecutionException;
import org.eclipse.mofscript.runtime.RuleExecutor;
import org.eclipse.mofscript.runtime.Variable;
import org.eclipse.mofscript.runtime.expression.ExpressionEvaluator;
import org.eclipse.mofscript.runtime.expression.FunctionCallEvaluator;
import org.eclipse.mofscript.runtime.statement.BreakStatementListener;
import org.eclipse.mofscript.runtime.statement.StatementExecutor;

public class IteratorStatementExecutor
extends StatementExecutor
implements BreakStatementListener {
    private boolean _breakLoop = false;
    private Object _betweenValue = this.getBetweenValue((IteratorStatement)this._statement, this._env);

    public IteratorStatementExecutor(MOFScriptStatement statement, ExecutionEnvironment env, RuleExecutor ownerRule) {
        super(statement, env, ownerRule);
    }

    @Override
    public Object executeStatement(Object rule_create) throws MofScriptExecutionException {
        SimpleExpression itSource = null;
        ExpressionEvaluator evaluator = null;
        Object reference = null;
        _breakContext = this;
        IteratorStatement itstatement = (IteratorStatement)this._statement;
        try {
            itSource = itstatement.getSource();
            String forname = itstatement.getVariable();
            String type = itstatement.getType();
            if (type == null) {
                type = "Object";
            }
            String[] fortypesplit = type.split("\\.");
            String fortype = fortypesplit[fortypesplit.length - 1];
            String metaModelRef = "";
            if (fortypesplit.length > 1) {
                metaModelRef = fortypesplit[0];
            }
            EClassifier forclazz = null;
            EClassifier ecoreClazz = null;
            try {
                if (fortype.equalsIgnoreCase("Object") || fortype.equalsIgnoreCase("Any")) {
                    forclazz = ExecutionManager.getExecutionManager().getEcoreMetaModel().getEClassifier("EObject");
                } else {
                    ecoreClazz = ExecutionManager.getExecutionManager().getEcoreMetaModel().getEClassifier(fortype);
                    EPackage pkg = RuleExecutor.getExecutionManager().getMetaModel(metaModelRef);
                    if (pkg != null) {
                        forclazz = RuleExecutor.getExecutionManager().getClassifierForPackage(pkg, fortype);
                    }
                    if (forclazz == null && ecoreClazz != null) {
                        forclazz = ecoreClazz;
                    }
                }
            }
            catch (Exception exception) {}
            evaluator = MofScriptExecuterFactory.createExpressionExecutor((Expression)itSource, this._env, this._ownerRule);
            reference = evaluator.evaluateExpression(null);
            Object variableImpl = null;
            if (itSource instanceof Reference && (variableImpl = this._env.getVariableImplementation(((Reference)itSource).getName())) != null) {
                this.handleVariableIterator(variableImpl, itstatement, metaModelRef, fortype, forclazz, forname, rule_create);
                return rule_create;
            }
            if (reference != null) {
                if (reference instanceof List) {
                    this.handleVariableIterator(reference, itstatement, metaModelRef, fortype, forclazz, forname, rule_create);
                } else {
                    this.handleAttributeIterator(itstatement, reference, forname, rule_create);
                }
            }
        }
        catch (Exception ex) {
            this._env.notifyError("#Runtime Error# In Iterator statement (Rule: " + this._ownerRule.getRule().getName() + ") ::" + ex.getClass().getName() + " - " + ex.getMessage() + " (line: " + itstatement.getLine() + ")", evaluator);
        }
        _breakContext = null;
        return null;
    }

    protected void handleAttributeIterator(IteratorStatement itstatement, Object referenceValue, String forname, Object rule_create) {
        Variable itVar = null;
        ExecutionEnvironment itEnv = null;
        try {
            try {
                itEnv = MofScriptExecuterFactory.createExecutionEnvironment();
                RuleExecutor.getExecutionManager().getExecutionStack().pushEnvironment(itEnv);
                itEnv.initIteratorCounters();
                if (referenceValue instanceof String || referenceValue instanceof StringBuffer) {
                    itVar = new Variable();
                    itVar.setType("String");
                    itVar.setName(forname);
                    this.handleStringIterator(itstatement, referenceValue.toString(), forname, itVar, itEnv, rule_create);
                } else if (referenceValue instanceof Integer) {
                    itVar = new Variable();
                    itVar.setType("Integer");
                    itVar.setName(forname);
                    this.handleIntegerIterator(itstatement, (Integer)referenceValue, forname, itVar, itEnv, rule_create);
                }
            }
            catch (Exception mttex) {
                this._env.notifyMessage("#Runtime error# Iterator statement: " + mttex.getMessage() + " (line: " + itstatement.getLine() + ")");
                RuleExecutor.getExecutionManager().getExecutionStack().popEnvironment();
            }
        }
        finally {
            RuleExecutor.getExecutionManager().getExecutionStack().popEnvironment();
        }
    }

    protected void handleVariableIterator(Object variable, IteratorStatement itstatement, String metaModelRef, String fortype, EClassifier forclazz, String forname, Object rule_create) throws MofScriptExecutionException {
        block22: {
            Object filterExpVal = null;
            itstatement.getStatements();
            boolean matches_filter = true;
            Variable itVar = new Variable();
            itVar.type = fortype;
            itVar.name = forname;
            Expression filter = itstatement.getFilterExpression();
            ExecutionEnvironment itEnv = MofScriptExecuterFactory.createExecutionEnvironment();
            itEnv.initIteratorCounters();
            RuleExecutor.getExecutionManager().getExecutionStack().pushEnvironment(itEnv);
            try {
                try {
                    if (variable instanceof Hashtable || variable instanceof List) {
                        Collection<Object> values = null;
                        values = variable instanceof Hashtable ? ((Hashtable)variable).values() : (List)variable;
                        Iterator<Object> it = values.iterator();
                        while (it.hasNext()) {
                            itEnv.clearReferenceCache();
                            Object val = it.next();
                            itEnv.addInputObject(forname, val);
                            itVar.value = val;
                            itEnv.setVariable(forname, itVar);
                            if (filter != null) {
                                ExpressionEvaluator expExec = MofScriptExecuterFactory.createExpressionExecutor(filter, itEnv, this._ownerRule);
                                filterExpVal = expExec.evaluateExpression(null);
                                if (filterExpVal instanceof Boolean) {
                                    matches_filter = (Boolean)filterExpVal;
                                } else if (filterExpVal instanceof String) {
                                    matches_filter = false;
                                    this._env.notifyError("#Runtime Error#: Return value String from logical expression: " + filterExpVal + " (line " + itstatement.getLine() + ")", expExec);
                                } else {
                                    matches_filter = false;
                                    this._env.notifyError("#Runtime Error#: Return value Object from logical expression: " + filterExpVal + " (line " + itstatement.getLine() + ")", expExec);
                                }
                            }
                            boolean matches_type = false;
                            if (forclazz == null || !(forclazz instanceof EClass) || forclazz instanceof EDataType) {
                                matches_type = fortype.equalsIgnoreCase("Integer") ? val instanceof Integer : (fortype.equalsIgnoreCase("String") ? val instanceof String : (fortype.equalsIgnoreCase("Real") ? val instanceof Double || val instanceof Float : (fortype.equalsIgnoreCase("Boolean") ? val instanceof Boolean : fortype.equals("") || fortype.equalsIgnoreCase("OclAny") || fortype.equalsIgnoreCase("Any") || fortype.equalsIgnoreCase("Object"))));
                            } else if (forclazz instanceof EClass && val instanceof EObject) {
                                this.getEClassForEObject(metaModelRef, (EObject)val);
                                Boolean isSuperClass = new Boolean(FunctionCallEvaluator.isKindOf((EObject)val, forclazz) != false || forclazz.getName().equals("EObject"));
                                matches_type = isSuperClass;
                            } else if (fortype != null && fortype.equals("Object")) {
                                matches_type = true;
                            }
                            if (matches_filter && matches_type) {
                                this.executeContainedStatements(itstatement, itEnv, rule_create);
                            }
                            itEnv.increaseIteratorPosition();
                            if (!this._breakLoop) {
                                if (!this._ownerRule.isReturning()) continue;
                            }
                            break block22;
                        }
                        break block22;
                    }
                    if (variable instanceof StringBuffer || variable instanceof String) {
                        this.handleStringIterator(itstatement, variable.toString(), forname, itVar, itEnv, rule_create);
                    } else if (variable instanceof Integer) {
                        this.handleIntegerIterator(itstatement, (Integer)variable, forname, itVar, itEnv, rule_create);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    RuleExecutor.getExecutionManager().getExecutionStack().popEnvironment();
                }
            }
            finally {
                RuleExecutor.getExecutionManager().getExecutionStack().popEnvironment();
            }
        }
    }

    protected void handleStringIterator(IteratorStatement itstatement, String strBuf, String forname, Variable iteratorVariable, ExecutionEnvironment itEnv, Object rule_create) {
        boolean matches_filter = true;
        Expression filter = null;
        Object filterExpVal = null;
        filter = itstatement.getFilterExpression();
        String val = "";
        int charPlace = 0;
        while (charPlace < strBuf.length()) {
            itEnv.clearReferenceCache();
            char theChar = strBuf.charAt(charPlace);
            val = String.valueOf(theChar);
            itEnv.addInputObject(forname, val);
            iteratorVariable.setValue(val);
            itEnv.setVariable(forname, iteratorVariable);
            if (filter != null) {
                try {
                    ExpressionEvaluator expExec = MofScriptExecuterFactory.createExpressionExecutor(filter, itEnv, this._ownerRule);
                    filterExpVal = expExec.evaluateExpression(null);
                    if (filterExpVal instanceof Boolean) {
                        matches_filter = (Boolean)filterExpVal;
                    } else if (filterExpVal instanceof String) {
                        matches_filter = false;
                        this._env.notifyError("#Runtime Error#: Return value String from logical expression: " + filterExpVal + " (line " + itstatement.getLine() + ")", expExec);
                    } else {
                        matches_filter = false;
                        this._env.notifyError("#Runtime Error#: Return value Object from logical expression: " + filterExpVal + " (line " + itstatement.getLine() + ")", expExec);
                    }
                }
                catch (MofScriptExecutionException mttex) {
                    this._env.notifyError("#Runtime Error# Statement in iterator filter" + mttex.getMessage() + " (line: " + itstatement.getLine() + ")", mttex.getExpression());
                }
            }
            if (matches_filter) {
                this.executeContainedStatements(itstatement, itEnv, rule_create);
            }
            itEnv.increaseIteratorPosition();
            if (this._breakLoop) break;
            ++charPlace;
        }
    }

    protected void handleIntegerIterator(IteratorStatement itstatement, int intValue, String forname, Variable iteratorVariable, ExecutionEnvironment itEnv, Object rule_create) {
        boolean matches_filter = true;
        Expression filter = null;
        Object filterExpVal = null;
        filter = itstatement.getFilterExpression();
        String val = "";
        int intCounter = 1;
        while (intCounter <= intValue) {
            itEnv.clearReferenceCache();
            val = String.valueOf(intCounter);
            itEnv.addInputObject(forname, val);
            iteratorVariable.setValue(val);
            itEnv.setVariable(forname, iteratorVariable);
            if (filter != null) {
                try {
                    ExpressionEvaluator expExec = MofScriptExecuterFactory.createExpressionExecutor(filter, itEnv, this._ownerRule);
                    filterExpVal = expExec.evaluateExpression(null);
                    matches_filter = filterExpVal instanceof Boolean ? (Boolean)filterExpVal : false;
                }
                catch (MofScriptExecutionException mttex) {
                    this._env.notifyMessage("#Runtime Error# Statement in iterator filter" + mttex.getMessage() + " (line: " + itstatement.getLine() + ")");
                }
            }
            if (matches_filter) {
                this.executeContainedStatements(itstatement, itEnv, rule_create);
            }
            itEnv.increaseIteratorPosition();
            if (this._breakLoop) break;
            ++intCounter;
        }
    }

    protected void executeContainedStatements(IteratorStatement itstatement, ExecutionEnvironment itEnv, Object rule_create) {
        block12: {
            EList blocks = itstatement.getBlocks();
            EList statements = itstatement.getStatements();
            MOFScriptStatement statement = null;
            StatementExecutor stExec = null;
            String objectUri = "";
            try {
                if (this._betweenValue != null && itEnv.getIteratorCount() > 0) {
                    itEnv.print(this._betweenValue.toString(), false);
                }
                if (blocks != null) {
                    Object inputObj = itEnv.getInputObject(itstatement.getVariable());
                    if (inputObj != null && inputObj instanceof EObject) {
                        objectUri = RuleExecutor.getObjectId((EObject)inputObj);
                    }
                    StatementBlock block2 = null;
                    for (StatementBlock block2 : blocks) {
                        if (!block2.isProtected()) {
                            itEnv.startUnprotectedBlock(objectUri);
                        }
                        statements = block2.getStatements();
                        Iterator stIt = statements.iterator();
                        while (stIt.hasNext()) {
                            _breakContext = this;
                            statement = (MOFScriptStatement)stIt.next();
                            stExec = MofScriptExecuterFactory.createStatementExecutor(statement, itEnv, this._ownerRule);
                            stExec.executeStatement(rule_create);
                            if (this._breakLoop) break;
                        }
                        if (!block2.isProtected()) {
                            itEnv.endUnprotectedBlock();
                        }
                        if (!this._breakLoop) {
                            continue;
                        }
                        break block12;
                    }
                    break block12;
                }
                Iterator stIt = statements.iterator();
                while (stIt.hasNext()) {
                    _breakContext = this;
                    statement = (MOFScriptStatement)stIt.next();
                    stExec = MofScriptExecuterFactory.createStatementExecutor(statement, itEnv, this._ownerRule);
                    stExec.executeStatement(rule_create);
                    if (!this._breakLoop) {
                        if (!this._ownerRule.isReturning()) continue;
                        this.handleReturn();
                        return;
                    }
                    break;
                }
            }
            catch (MofScriptExecutionException mttex) {
                this._env.notifyMessage("#Runtime Error# Statement within iterator " + mttex.getMessage() + " (line: " + statement.getLine() + ")");
            }
        }
        itEnv.increaseIteratorCount();
    }

    private void handleReturn() {
    }

    protected EClass getEClassForEObject(String metaModelRef, EObject eobj) {
        if (eobj != null) {
            EPackage mm = RuleExecutor.getExecutionManager().getMetaModel(metaModelRef);
            EClass oclazz = null;
            if (mm != null) {
                oclazz = (EClass)mm.getEClassifier(eobj.eClass().getName());
            }
            EClass oclazz2 = eobj.eClass();
            if (oclazz == null && oclazz2 != null) {
                oclazz = oclazz2;
            }
            return oclazz;
        }
        return null;
    }

    protected Object getBetweenValue(IteratorStatement itstatement, ExecutionEnvironment itEnv) {
        Object bVal = null;
        if (itstatement.getBetween() != null) {
            ExpressionEvaluator expEval = MofScriptExecuterFactory.createExpressionExecutor((Expression)itstatement.getBetween(), itEnv, this._ownerRule);
            try {
                bVal = expEval.evaluateExpression(null);
            }
            catch (MofScriptExecutionException mofScriptExecutionException) {}
        }
        return bVal;
    }

    @Override
    public void breakExecuted(MOFScriptStatementOwner ownedContext) {
        this._breakLoop = true;
    }
}

