/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.runtime.statement;

import org.eclipse.mofscript.MOFScriptModel.Expression;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptStatement;
import org.eclipse.mofscript.MOFScriptModel.PrintStatement;
import org.eclipse.mofscript.MOFScriptModel.ValueExpression;
import org.eclipse.mofscript.runtime.ExecutionEnvironment;
import org.eclipse.mofscript.runtime.MofScriptExecuterFactory;
import org.eclipse.mofscript.runtime.MofScriptExecutionException;
import org.eclipse.mofscript.runtime.RuleExecutor;
import org.eclipse.mofscript.runtime.expression.ExpressionEvaluator;
import org.eclipse.mofscript.runtime.statement.StatementExecutor;

public class PrintStatementExecutor
extends StatementExecutor {
    protected static volatile boolean _previousWasPrintLn = false;

    public PrintStatementExecutor(MOFScriptStatement statement, ExecutionEnvironment env, RuleExecutor ownerRule) {
        super(statement, env, ownerRule);
    }

    @Override
    public Object executeStatement(Object rule_create) throws MofScriptExecutionException {
        PrintStatement pstatement = (PrintStatement)this._statement;
        this._env.setInPrintAction(true);
        String printCommand = pstatement.getPrintCommand();
        if (printCommand.equalsIgnoreCase("indent")) {
            ExecutionEnvironment.indent();
        } else if (printCommand.equalsIgnoreCase("undent")) {
            ExecutionEnvironment.undent();
        } else if (printCommand.equalsIgnoreCase("log")) {
            this.handleLog(pstatement);
        } else {
            if (!pstatement.getContext().equalsIgnoreCase("stdout") || pstatement.getContext().equalsIgnoreCase("println")) {
                this._env.setTrace(true);
            }
            String pcontext = pstatement.getContext();
            ValueExpression pbody = pstatement.getPrintBody();
            ExpressionEvaluator.resetPosisionCounter();
            ExpressionEvaluator expExec = MofScriptExecuterFactory.createExpressionExecutor((Expression)pbody, this._env, this._ownerRule);
            ExpressionEvaluator.resetPosisionCounter();
            Object expression_value = expExec.evaluateExpression(null);
            String toPrint = "";
            if (expression_value != null) {
                toPrint = expression_value.toString();
            } else if (expression_value == null) {
                toPrint = "";
            }
            if (pcontext != null) {
                ExecutionEnvironment.setPrintContext(pcontext);
            }
            if (ExecutionEnvironment.useIndent()) {
                String indent = ExecutionEnvironment.getIndent();
                indent.length();
            }
            if (printCommand != null && printCommand.equalsIgnoreCase("println")) {
                this._env.println(toPrint);
                _previousWasPrintLn = true;
            } else {
                this._env.print(toPrint, false);
                _previousWasPrintLn = false;
            }
            ExecutionEnvironment.setPrintContext(null);
            this._env.setTrace(false);
        }
        this._env.setInPrintAction(false);
        return null;
    }

    protected void handleLog(PrintStatement pstatement) {
        boolean useLog = false;
        if (this._env.getUseLog()) {
            try {
                pstatement.getContext();
                ValueExpression pbody = pstatement.getPrintBody();
                ExpressionEvaluator expExec = MofScriptExecuterFactory.createExpressionExecutor((Expression)pbody, this._env, this._ownerRule);
                Object expression_value = expExec.evaluateExpression(null);
                this._env.log(expression_value.toString());
            }
            catch (MofScriptExecutionException mex) {
                this._env.notifyError("#Runtime Error# In log statement: " + mex + " (line" + pstatement.getLine() + ")", mex.getExpression());
            }
        }
        useLog = this._env.getUseLog();
    }
}

