/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.runtime.statement;

import java.util.Hashtable;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.mofscript.MOFScriptModel.AssignmentOperator;
import org.eclipse.mofscript.MOFScriptModel.Expression;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptStatement;
import org.eclipse.mofscript.MOFScriptModel.ResultAssignment;
import org.eclipse.mofscript.runtime.ExecutionEnvironment;
import org.eclipse.mofscript.runtime.MofScriptExecuterFactory;
import org.eclipse.mofscript.runtime.MofScriptExecutionException;
import org.eclipse.mofscript.runtime.RuleExecutor;
import org.eclipse.mofscript.runtime.expression.ExpressionEvaluator;
import org.eclipse.mofscript.runtime.statement.StatementExecutor;

public class ResultAssignmentExecutor
extends StatementExecutor {
    public ResultAssignmentExecutor(MOFScriptStatement statement, ExecutionEnvironment env, RuleExecutor ownerRule) {
        super(statement, env, ownerRule);
    }

    @Override
    public Object executeStatement(Object rule_create) throws MofScriptExecutionException {
        ResultAssignment assignment = (ResultAssignment)this._statement;
        String assignmentname = assignment.getResultPart();
        AssignmentOperator operator = assignment.getOperator();
        Expression expression = assignment.getExpression();
        new Integer(1);
        Object exp_result = null;
        ExpressionEvaluator expExecuter = null;
        try {
            expExecuter = MofScriptExecuterFactory.createExpressionExecutor(expression, this._env, this._ownerRule);
            exp_result = expExecuter.evaluateExpression(null);
        }
        catch (MofScriptExecutionException qex) {
            this._env.notifyError("#Runtime Error# in result assignment." + qex.getMessage() + " (line:" + assignment.getLine() + ")", expExecuter);
            return null;
        }
        Object value = null;
        String returnType = "";
        boolean isBaseType = true;
        if (rule_create instanceof StringBuffer || rule_create instanceof String) {
            returnType = "String";
        } else if (rule_create instanceof Integer) {
            returnType = "Integer";
        } else if (rule_create instanceof Double) {
            returnType = "Double";
        } else if (rule_create instanceof Boolean) {
            returnType = "Boolean";
        } else if (rule_create instanceof List) {
            returnType = "List";
        } else if (rule_create instanceof Hashtable) {
            returnType = "Hashtable";
        } else if (!(rule_create instanceof EObject)) {
            returnType = "Object";
        } else {
            isBaseType = false;
        }
        if (isBaseType) {
            value = ExecutionEnvironment.getAssignValue(returnType, this._ownerRule.getRuleReturnValue(), exp_result, operator);
            this._ownerRule.setRuleReturnValue(value);
        } else if (rule_create instanceof EObject) {
            if (assignmentname != null) {
                EStructuralFeature sfeature = ((EObject)rule_create).eClass().getEStructuralFeature(assignmentname);
                if (sfeature instanceof EAttribute) {
                    EAttribute cfr_ignored_0 = (EAttribute)sfeature;
                    ((EObject)rule_create).eGet(sfeature);
                    Object new_value = exp_result;
                    ((EObject)rule_create).eSet(sfeature, new_value);
                } else if (sfeature instanceof EReference) {
                    EReference ref = (EReference)sfeature;
                    EClass etype = (EClass)ref.getEType();
                    if (exp_result != null && exp_result instanceof EObject) {
                        ((EObject)exp_result).eClass();
                        if (etype.isInstance(exp_result)) {
                            ((List)((EObject)rule_create).eGet((EStructuralFeature)ref)).add(exp_result);
                        }
                    }
                }
            }
            this._ownerRule.setRuleReturnValue(exp_result);
        } else {
            throw new MofScriptExecutionException("Illegal type for rule creation", this._ownerRule.getRule().getName(), this._statement.getLine(), expExecuter);
        }
        return rule_create;
    }
}

