/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.runtime.statement;

import org.eclipse.emf.common.util.EList;
import org.eclipse.mofscript.MOFScriptModel.Expression;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptStatement;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptStatementOwner;
import org.eclipse.mofscript.MOFScriptModel.WhileStatement;
import org.eclipse.mofscript.runtime.ExecutionEnvironment;
import org.eclipse.mofscript.runtime.MofScriptExecuterFactory;
import org.eclipse.mofscript.runtime.MofScriptExecutionException;
import org.eclipse.mofscript.runtime.RuleExecutor;
import org.eclipse.mofscript.runtime.expression.ExpressionEvaluator;
import org.eclipse.mofscript.runtime.statement.BreakStatementListener;
import org.eclipse.mofscript.runtime.statement.StatementExecutor;

public class WhileStatementExecutor
extends StatementExecutor
implements BreakStatementListener {
    private boolean _breakLoop = false;

    public WhileStatementExecutor(MOFScriptStatement statement, ExecutionEnvironment env, RuleExecutor ownerRule) {
        super(statement, env, ownerRule);
    }

    @Override
    public Object executeStatement(Object rule_create) throws MofScriptExecutionException {
        WhileStatement whilestatement = (WhileStatement)this._statement;
        Expression logExp = whilestatement.getCondition();
        Object logicalExpressionValue = null;
        StatementExecutor stExec = null;
        Object resultValue = null;
        ExpressionEvaluator expExec = null;
        boolean matches_filter = true;
        if (logExp != null) {
            expExec = MofScriptExecuterFactory.createExpressionExecutor(logExp, this._env, this._ownerRule);
            logicalExpressionValue = expExec.evaluateExpression(null);
            if (logicalExpressionValue instanceof Boolean) {
                matches_filter = (Boolean)logicalExpressionValue;
            } else if (logicalExpressionValue instanceof String) {
                matches_filter = false;
                this._env.notifyError("#Runtime Error# Return value String from logical expression: " + logicalExpressionValue + " (line" + whilestatement.getLine() + ")", expExec);
            } else {
                matches_filter = false;
                this._env.notifyError("#Runtime Error# Return value Object from logical expression: " + logicalExpressionValue + " (line" + whilestatement.getLine() + ")", expExec);
            }
        }
        while (matches_filter) {
            ExecutionEnvironment whileEnv = MofScriptExecuterFactory.createExecutionEnvironment();
            RuleExecutor.getExecutionManager().getExecutionStack().pushEnvironment(whileEnv);
            EList statements = whilestatement.getStatements();
            for (MOFScriptStatement qvtstatement : statements) {
                stExec = MofScriptExecuterFactory.createStatementExecutor(qvtstatement, whileEnv, this._ownerRule);
                resultValue = stExec.executeStatement(rule_create);
                if (!this._ownerRule.isReturning()) continue;
                RuleExecutor.getExecutionManager().getExecutionStack().popEnvironment();
                return resultValue;
            }
            RuleExecutor.getExecutionManager().getExecutionStack().popEnvironment();
            whileEnv = null;
            logicalExpressionValue = expExec.evaluateExpression(null);
            matches_filter = (Boolean)logicalExpressionValue;
        }
        return null;
    }

    @Override
    public void breakExecuted(MOFScriptStatementOwner ownedContext) {
        this._breakLoop = true;
    }
}

