/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.runtime.traceability;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.mofscript.MOFScriptModel.TransformationRule;
import org.eclipse.mofscript.runtime.BlockOutputStream;
import org.eclipse.mofscript.runtime.ExecutionEnvironment;
import org.eclipse.mofscript.runtime.ExecutionManager;
import org.eclipse.mofscript.runtime.RuleExecutor;
import org.eclipse.mofscript.traceabilitymodel.Block;
import org.eclipse.mofscript.traceabilitymodel.File;
import org.eclipse.mofscript.traceabilitymodel.MetaModel;
import org.eclipse.mofscript.traceabilitymodel.ModelElementRef;
import org.eclipse.mofscript.traceabilitymodel.Trace;
import org.eclipse.mofscript.traceabilitymodel.TraceModel;
import org.eclipse.mofscript.traceabilitymodel.TraceabilitymodelFactory;
import org.eclipse.mofscript.traceabilitymodel.TraceabilitymodelPackage;
import org.eclipse.mofscript.traceabilitymodel.TraceableSegment;

public class TraceabilityEnvironment
extends ExecutionEnvironment {
    protected static TraceabilitymodelPackage _tracePackage = null;
    protected static TraceabilitymodelFactory _traceFactory = null;
    protected static TraceModel _traceModel = null;
    protected static int _traceCount = 0;
    private long oldPos = -1L;
    private long newPos = -1L;
    private static int _blockCounter = 0;
    private static boolean _lastWasUnprotected = false;
    private static final String _blockText = "Block id: ";
    private static boolean _blockStream = false;
    protected static final String tramdeEstablisherClass = "org.sintef.tramde.adapter.mofscript.MOFScriptTramdeEstablisher";
    public Object _tempObject;
    public String _tempRef;
    public Hashtable _variablesRefValues = null;
    private static Object tte = null;
    public static boolean useTramde = false;
    public static boolean coarseTramde = false;
    public static Method createTramdeTrace = null;
    public static Method createCoarseTramdeTrace = null;

    public TraceabilityEnvironment() {
        if (this._variablesRefValues == null) {
            this._variablesRefValues = new Hashtable();
        }
        if (_tracePackage == null) {
            _tracePackage = TraceabilitymodelPackage.eINSTANCE;
        }
        if (_traceFactory == null) {
            _traceFactory = TraceabilitymodelFactory.eINSTANCE;
        }
        if (_traceModel == null) {
            this.loadTraceabilityModel();
        }
        useTramde = ExecutionManager.getExecutionManager().getUseTramde();
        coarseTramde = ExecutionManager.getExecutionManager().getUseCoarseTramde();
    }

    @Override
    public void print(String s, boolean println) {
        OutputStream str = this.getCurrentStream();
        super.print(s, println);
        OffsetCounter counter = null;
        if (str != null) {
            if (_offsets.containsKey(str)) {
                counter = (OffsetCounter)_offsets.get(str);
            } else {
                counter = new OffsetCounter();
                _offsets.put(str, counter);
            }
            counter.updateCounter(s, true);
            if (println) {
                counter.increaseLineNumber();
            }
        }
    }

    public Trace createTrace(String refValue, int offset, int refLength, EObject object, String feature, RuleExecutor rExec, String fullRefName) {
        OutputStream str = null;
        Trace trace = null;
        long pos = 0L;
        long startLine = 1L;
        long startColumn = 1L;
        long endLine = 1L;
        long endColumn = 1L;
        EClass e = object.eClass();
        e.getName();
        str = this.getCurrentStream();
        OffsetCounter c = (OffsetCounter)_offsets.get(str);
        if (str != null && _traceValue) {
            if (str instanceof BlockOutputStream) {
                _blockStream = true;
                BlockOutputStream b = (BlockOutputStream)str;
                pos = b.position();
            }
            if (c != null) {
                c.updateCounter(refValue, false);
                startLine = c.get_lineNumber();
                startColumn = c.get_columnNumber() + offset;
                endLine = c.getTemplineNumber();
                endColumn = c.getTempColumnNumber() + offset;
            }
            ++_traceCount;
            int startPos = (int)pos + offset;
            int endPos = startPos + refLength;
            _streams.keys();
            ExecutionManager em = ExecutionManager.getExecutionManager();
            String traceFileUri = _openFileUri;
            String tName = em.getTransformationProxy().getName();
            TransformationRule r = rExec.getRule();
            if (useTramde) {
                Object[] args;
                if (tte == null) {
                    try {
                        Class<?> tramdeClass = Class.forName(tramdeEstablisherClass);
                        tte = tramdeClass.newInstance();
                        Class[] paramTypes = new Class[]{Integer.class, String.class, String.class, Long.class, Long.class, Long.class, Long.class, String.class, Integer.class, Integer.class, EObject.class, String.class, TransformationRule.class, String.class, String.class};
                        if (coarseTramde) {
                            createCoarseTramdeTrace = tramdeClass.getMethod("createCoarseGrainedTramdeTrace", paramTypes);
                        } else {
                            createTramdeTrace = tramdeClass.getMethod("createTramdeTrace", paramTypes);
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        this.log("Tramde active, but TramdeClass not found: org.sintef.tramde.adapter.mofscript.MOFScriptTramdeEstablisher");
                    }
                    catch (IllegalAccessException illacx) {
                        System.out.println(illacx.getMessage());
                    }
                    catch (InstantiationException instex) {
                        System.out.println("TraceabilityEnvironement - could not instantiate TramdeEstablisherClass:" + instex.getMessage());
                    }
                    catch (NoSuchMethodException nosuch) {
                        System.out.println("TraceabilityEnvironement - trying to invoke createTramdeTrace:" + nosuch.getMessage());
                    }
                }
                int bc = _blockCounter;
                if (createTramdeTrace != null) {
                    args = new Object[]{new Integer(bc), _blockText, traceFileUri, new Long(startColumn), new Long(endColumn), new Long(startLine), new Long(endLine), refValue, new Integer(offset), new Integer(refLength), object, feature, r, fullRefName, tName};
                    try {
                        createTramdeTrace.invoke(tte, args);
                    }
                    catch (InvocationTargetException invex) {
                        System.out.println("TraceabilityEnvironement - trying to invoke createTramdeTrace:" + invex.getMessage());
                    }
                    catch (IllegalAccessException illac) {
                        System.out.println("TraceabilityEnvironement - trying to invoke createTramdeTrace:" + illac.getMessage());
                    }
                }
                if (createCoarseTramdeTrace != null) {
                    args = new Object[]{new Integer(bc), _blockText, traceFileUri, new Long(startColumn), new Long(endColumn), new Long(startLine), new Long(endLine), refValue, new Integer(offset), new Integer(refLength), object, feature, r, fullRefName, tName};
                    try {
                        createCoarseTramdeTrace.invoke(tte, args);
                    }
                    catch (InvocationTargetException invex) {
                        System.out.println("TraceabilityEnvironement - trying to invoke createCoarseTramdeTrace:" + invex.getMessage());
                    }
                    catch (IllegalAccessException illac) {
                        System.out.println("TraceabilityEnvironement - trying to invoke createCoarseTramdeTrace:" + illac.getMessage());
                    }
                }
            }
            trace = _traceFactory.createTrace();
            trace.setSourceOperationID(rExec.getRule().getContext().getType());
            trace.setSourceOperationName(rExec.getRule().getName());
            trace.setSpecificationName(em.getTransformationProxy().getName());
            TraceableSegment tSegment = _traceFactory.createTraceableSegment();
            tSegment.setStartPos((long)startPos);
            tSegment.setEndPos((long)endPos);
            tSegment.setStartLine(startLine);
            tSegment.setStartColumn(startColumn);
            tSegment.setEndLine(endLine);
            tSegment.setEndColumn(endColumn);
            trace.setSegment(tSegment);
            EList mElemRefList = _traceModel.getModelElementRefs();
            ModelElementRef meRef = null;
            boolean match = false;
            if (mElemRefList != null && !mElemRefList.isEmpty()) {
                Iterator itr = mElemRefList.iterator();
                while (itr.hasNext() && !match) {
                    meRef = (ModelElementRef)itr.next();
                    if (!meRef.getID().equalsIgnoreCase(TraceabilityEnvironment.getObjectId(object)) || !meRef.getFeatureRef().equalsIgnoreCase(feature)) continue;
                    trace.setOriginatinElement(meRef);
                    match = true;
                    break;
                }
            }
            if (!match) {
                meRef = _traceFactory.createModelElementRef();
                EClass eclass = object.eClass();
                EStructuralFeature fName = eclass.getEStructuralFeature("name");
                String oName = eclass.getName();
                if (fName != null) {
                    Object theName = object.eGet(fName);
                    oName = String.valueOf(oName) + ":" + theName.toString();
                }
                meRef.setID(TraceabilityEnvironment.getObjectId(object));
                meRef.setName(String.valueOf(oName) + ":->" + feature);
                meRef.setFeatureRef(feature);
                object.toString().split("file:/");
                URI u = EcoreUtil.getURI((EObject)object);
                meRef.setUri(u.toString());
                EObject eObj = e.eContainer();
                EPackage p = (EPackage)eObj;
                String mmNsURI = p.getNsURI();
                EList mmList = _traceModel.getMetaModels();
                boolean exist = false;
                int i = 0;
                while (i < mmList.size()) {
                    MetaModel tempMM = (MetaModel)mmList.get(i);
                    if (tempMM.getNsUri().equalsIgnoreCase(mmNsURI)) {
                        exist = true;
                        meRef.setMetaModel(tempMM);
                        break;
                    }
                    ++i;
                }
                if (!exist) {
                    MetaModel mm = _traceFactory.createMetaModel();
                    mm.setName(p.getName());
                    mm.setNsUri(mmNsURI);
                    _traceModel.getMetaModels().add((Object)mm);
                    meRef.setMetaModel(mm);
                }
                trace.setOriginatinElement(meRef);
                _traceModel.getModelElementRefs().add((Object)meRef);
            }
            File traceFile = null;
            EList fileList = _traceModel.getFiles();
            boolean fileMatch = false;
            boolean blockMatch = false;
            Block block = null;
            EList blockList = null;
            if (fileList != null && !fileList.isEmpty()) {
                Iterator itr = fileList.iterator();
                while (itr.hasNext() && !fileMatch) {
                    traceFile = (File)itr.next();
                    if (!traceFile.getURI().equalsIgnoreCase(traceFileUri)) continue;
                    fileMatch = true;
                    blockList = traceFile.getBlocks();
                    if (blockList == null || blockList.isEmpty()) continue;
                    Iterator bItr = blockList.iterator();
                    while (bItr.hasNext() && !blockMatch) {
                        block = (Block)bItr.next();
                        int tempCount = _blockCounter - 1;
                        String tempId = _blockText + tempCount;
                        if (!block.getID().equalsIgnoreCase(this._objectId) && (!this._objectId.equalsIgnoreCase("") || _lastWasUnprotected || !block.getID().equalsIgnoreCase(tempId))) continue;
                        block.getTraceablesegment().add((Object)tSegment);
                        block.setEndPos(tSegment.getEndPos());
                        block.setEndLine(tSegment.getEndLine());
                        block.setEndColumn(tSegment.getEndColumn());
                        blockMatch = true;
                    }
                }
            }
            if (!fileMatch) {
                traceFile = _traceFactory.createFile();
                if (traceFileUri != null) {
                    traceFile.setURI(traceFileUri);
                    int tFNameIndex = traceFileUri.lastIndexOf("\\");
                    String traceFileName = traceFileUri.substring(tFNameIndex + 1);
                    traceFile.setName(traceFileName);
                    traceFile.setID(traceFileUri);
                    _traceModel.getFiles().add((Object)traceFile);
                }
            }
            if (!blockMatch) {
                block = _traceFactory.createBlock();
                if (!this.isUnprotectedBlock()) {
                    block.setID(_blockText + _blockCounter);
                    ++_blockCounter;
                    _lastWasUnprotected = false;
                }
                if (this.isUnprotectedBlock()) {
                    block.setID(this._objectId);
                    _lastWasUnprotected = true;
                }
                block.setStartPos((long)startPos);
                block.setEndPos((long)endPos);
                block.setStartLine(startLine);
                block.setStartColumn(startColumn);
                block.setEndLine(endLine);
                block.setEndColumn(endColumn);
                block.setProtectedBlock(!this.isUnprotectedBlock());
                block.getTraceablesegment().add((Object)tSegment);
                traceFile.getBlocks().add((Object)block);
            }
            _traceModel.getTrace().add((Object)trace);
        }
        return trace;
    }

    public static String getObjectId(EObject obj) {
        String id = EcoreUtil.getIdentification((EObject)obj);
        int index = id.indexOf(35);
        if (index > -1) {
            id = id.substring(index + 1, id.length() - 1);
        }
        return id;
    }

    protected void loadTraceabilityModel() {
        _traceModel = _traceFactory.createTraceModel();
    }

    public void storeTraceablityModel(String traceGenDir) {
        String transformationName;
        this.notifyMessage("## " + _traceCount + " Traces generated");
        String traceModelName = transformationName = ExecutionManager.getExecutionManager().getTransformationProxy().getName();
        URI fileURI = URI.createFileURI((String)(String.valueOf(traceGenDir) + "/" + traceModelName + ".traceabilitymodel"));
        Resource resource = new XMIResourceFactoryImpl().createResource(fileURI);
        resource.getContents().add((Object)_traceModel);
        try {
            resource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void resetTraceCounter() {
        _traceCount = 0;
        _blockCounter = 0;
    }

    public static void cleanTraceEnv() {
        _traceModel = null;
        _tracePackage = null;
        _traceFactory = null;
        _lastWasUnprotected = false;
    }

    @Override
    public void startUnprotectedBlock(String objectUri) {
        EList files = _traceModel.getFiles();
        EList blocks = null;
        Block ub = null;
        File file = null;
        this._objectId = objectUri;
        boolean match = false;
        OutputStream os = this.getCurrentStream();
        Block unprotectedBlock = null;
        BlockOutputStream bos = null;
        if (os instanceof BlockOutputStream) {
            bos = (BlockOutputStream)os;
            int counter = ((BlockOutputStream)os).getIdBlockCounter(this._objectId);
            this._objectId = String.valueOf(objectUri) + "_#_" + counter;
            while (!match) {
                int i = 0;
                while (i < files.size()) {
                    file = (File)files.get(i);
                    if (file.getURI() == bos.get_fileUri()) {
                        OffsetCounter c = (OffsetCounter)_offsets.get(os);
                        int line = c.get_lineNumber() + 1;
                        blocks = file.getBlocks();
                        int b = 0;
                        while (b < blocks.size()) {
                            ub = (Block)blocks.get(b);
                            if (ub.getID().equalsIgnoreCase(this._objectId)) {
                                unprotectedBlock = ub;
                                break;
                            }
                            ++b;
                        }
                        if (unprotectedBlock == null) {
                            unprotectedBlock = _traceFactory.createBlock();
                        }
                        unprotectedBlock.setID(this._objectId);
                        unprotectedBlock.setProtectedBlock(false);
                        unprotectedBlock.setStartColumn(0L);
                        unprotectedBlock.setStartLine((long)line);
                        unprotectedBlock.setStartPos((long)bos.position());
                        file.getBlocks().add((Object)unprotectedBlock);
                        match = true;
                    }
                    ++i;
                }
            }
        }
        super.startUnprotectedBlock(objectUri);
    }

    @Override
    public void endUnprotectedBlock() {
        EList files = _traceModel.getFiles();
        File file = null;
        EList blocks = null;
        Block unprotectedBlock = null;
        boolean match = false;
        OutputStream os = this.getCurrentStream();
        BlockOutputStream bos = null;
        if (os instanceof BlockOutputStream) {
            bos = (BlockOutputStream)os;
            while (!match) {
                int i = 0;
                while (i < files.size()) {
                    file = (File)files.get(i);
                    if (file.getURI() == bos.get_fileUri()) {
                        blocks = file.getBlocks();
                        int j = 0;
                        while (j < blocks.size()) {
                            unprotectedBlock = (Block)blocks.get(j);
                            if (unprotectedBlock.getID().equalsIgnoreCase(this._objectId)) {
                                OffsetCounter c = (OffsetCounter)_offsets.get(os);
                                int line = c.get_lineNumber();
                                unprotectedBlock.setEndLine((long)(line + 1));
                                unprotectedBlock.setEndColumn(0L);
                                unprotectedBlock.setEndPos((long)bos.position());
                                match = true;
                                _lastWasUnprotected = true;
                                break;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        super.endUnprotectedBlock();
    }

    @Override
    public void storeInputObject(Object ret) {
        this._tempObject = ret;
    }

    public boolean setVariableInfo(String refName, String varName, Object modelElement, String value) {
        boolean ok = false;
        if (this._variablesRefValues.get(varName) != null) {
            TraceVariableInfo tvi = new TraceVariableInfo(refName, modelElement, value);
            this._variablesRefValues.put(varName, tvi);
            ok = true;
        } else if (this._parentEnv != null) {
            ((TraceabilityEnvironment)this._parentEnv).setVariableInfo(refName, varName, modelElement, value);
        }
        return ok;
    }

    public void addVariableInfo(String refName, String varName, Object modelElement, String value) {
        TraceVariableInfo tvi = new TraceVariableInfo(refName, modelElement, value);
        this._variablesRefValues.put(varName, tvi);
    }

    public void removeVariableInfo(String varName) {
        if (varName != null && this._variablesRefValues.contains(varName)) {
            this._variablesRefValues.remove(varName);
        }
    }

    public Object getVariableInfo(String key) {
        Object object = null;
        if (this._variablesRefValues.get(key) != null) {
            object = this._variablesRefValues.get(key);
        } else if (this._parentEnv != null && object == null) {
            object = ((TraceabilityEnvironment)this._parentEnv).getVariableInfo(key);
        }
        return object;
    }

    public EObject getVariableEObject(String key) {
        TraceVariableInfo t = null;
        EObject object = null;
        if (this._variablesRefValues.get(key) != null) {
            t = (TraceVariableInfo)this._variablesRefValues.get(key);
            object = (EObject)t.getModelElement();
        } else if (this._parentEnv != null && object == null) {
            object = ((TraceabilityEnvironment)this._parentEnv).getVariableEObject(key);
        }
        return object;
    }

    public String getVariableRefName(String key) {
        TraceVariableInfo t = null;
        String refName = null;
        if (this._variablesRefValues.get(key) != null) {
            t = (TraceVariableInfo)this._variablesRefValues.get(key);
            refName = t.getRefName();
        } else if (this._parentEnv != null && refName == null) {
            refName = ((TraceabilityEnvironment)this._parentEnv).getVariableRefName(key);
        }
        return refName;
    }

    @Override
    public String getVariableValue(String key) {
        TraceVariableInfo t = null;
        String value = null;
        if (this._variablesRefValues.get(key) != null) {
            t = (TraceVariableInfo)this._variablesRefValues.get(key);
            value = t.getValue();
        } else if (this._parentEnv != null && value == null) {
            value = ((TraceabilityEnvironment)this._parentEnv).getVariableValue(key);
        }
        return value;
    }

    public class OffsetCounter {
        private int _lineNumber = 1;
        private int _columnNumber = 1;
        private int tempLineNumber = 1;
        private int tempColumnNumber = 1;

        public void updateCounter(String printString, boolean store) {
            this.tempLineNumber = this._lineNumber;
            this.tempColumnNumber = this._columnNumber;
            int lineHelper = 0;
            int newLineCount = 0;
            if (printString == null || printString.length() == 0) {
                return;
            }
            String[] sSplit = printString.split("\\n");
            newLineCount = this.checkNewLines(printString);
            if (sSplit.length > 1) {
                int i = sSplit.length;
                this.tempLineNumber += i - 1;
                lineHelper += i - 1;
                this.tempColumnNumber = 1;
                if (printString.lastIndexOf(10) == printString.length() - 1) {
                    ++this.tempLineNumber;
                    this.tempColumnNumber = 1;
                    if (++lineHelper != newLineCount) {
                        int dif = newLineCount - lineHelper;
                        this.tempLineNumber += dif;
                    }
                } else {
                    this.tempColumnNumber += this.updateColumn(sSplit[sSplit.length - 1]);
                }
            } else if (printString.lastIndexOf(10) == printString.length() - 1) {
                this.tempLineNumber = newLineCount > 1 ? (this.tempLineNumber += newLineCount) : ++this.tempLineNumber;
                this.tempColumnNumber = 1;
            } else {
                this.tempColumnNumber += this.updateColumn(sSplit[sSplit.length - 1]);
            }
            if (store) {
                this._lineNumber = this.tempLineNumber;
                this._columnNumber = this.tempColumnNumber;
            }
        }

        public int checkNewLines(String printString) {
            int nlCount = 0;
            char[] lineArray = printString.toCharArray();
            int i = 0;
            while (i < lineArray.length) {
                if (lineArray[i] == '\n') {
                    ++nlCount;
                }
                ++i;
            }
            return nlCount;
        }

        public int get_columnNumber() {
            return this._columnNumber;
        }

        public int get_lineNumber() {
            return this._lineNumber;
        }

        public void set_lineNumber(int n) {
            this._lineNumber = n;
        }

        public int getTempColumnNumber() {
            return this.tempColumnNumber;
        }

        public int getTemplineNumber() {
            return this.tempLineNumber;
        }

        public String tempToString() {
            return String.valueOf(this.tempLineNumber) + ":" + this.tempColumnNumber;
        }

        public String toString() {
            return String.valueOf(this._lineNumber) + ":" + this._columnNumber;
        }

        public void increaseLineNumber() {
            ++this._lineNumber;
            this._columnNumber = 1;
        }

        public void increaseLineNumber(int count) {
            this._lineNumber += count;
            this._columnNumber = 1;
        }

        public int updateColumn(String s) {
            int tabSize;
            int number = 0;
            String[] sSplit = s.split("\\t");
            int cfr_ignored_0 = sSplit.length;
            char[] a = s.toCharArray();
            int tabCount = 0;
            int i = 0;
            while (i < a.length) {
                if (a[i] == '\t') {
                    ++tabCount;
                }
                ++i;
            }
            if (tabCount == 0) {
                number = s.length();
            } else if (s.startsWith("\t") && tabCount == 1) {
                tabSize = 4;
                number = s.length() + tabSize - 1;
            } else if (s.startsWith("\t") && tabCount == 2) {
                tabSize = 4;
                number = s.length() + tabSize * 2 - tabCount * 1;
            } else if (s.startsWith("\t") && tabCount == 3) {
                tabSize = 4;
                number = s.length() + tabSize * 3 - tabCount * 1;
            } else {
                tabSize = 4;
                int sumTabSize = tabCount * tabSize;
                number = s.length() + sumTabSize - tabCount;
            }
            return number;
        }
    }

    private class TraceVariableInfo {
        private String refName;
        private Object modelElement;
        private String value;

        public TraceVariableInfo(String refName, Object modelElement, String value) {
            this.refName = refName;
            this.modelElement = modelElement;
            this.value = value;
        }

        public Object getModelElement() {
            return this.modelElement;
        }

        public String getRefName() {
            return this.refName;
        }

        public String getValue() {
            return this.value;
        }
    }
}

