/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.runtime.traceability;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.mofscript.MOFScriptModel.Expression;
import org.eclipse.mofscript.MOFScriptModel.Reference;
import org.eclipse.mofscript.runtime.ExecutionEnvironment;
import org.eclipse.mofscript.runtime.RuleExecutor;
import org.eclipse.mofscript.runtime.Variable;
import org.eclipse.mofscript.runtime.expression.ReferenceEvaluator;
import org.eclipse.mofscript.runtime.traceability.TraceabilityEnvironment;
import org.eclipse.mofscript.traceabilitymodel.Trace;

public class TraceabilityReferenceEvaluator
extends ReferenceEvaluator {
    private Trace _cachedTrace = null;

    public TraceabilityReferenceEvaluator(Expression expression, ExecutionEnvironment env, RuleExecutor ownerRuleExecutor) {
        super(expression, env, ownerRuleExecutor);
    }

    @Override
    protected void handleObjectReference(EObject eobj, String refname, Object refValue) {
        if (refname == null) {
            return;
        }
        int index = refname.indexOf(46);
        if (index == -1) {
            return;
        }
        String realRefName = refname.substring(index + 1, refname.length());
        Reference cfr_ignored_0 = (Reference)this._expression;
        RuleExecutor rExec = this._ownerRuleExecutor;
        if (refValue != null) {
            _referenceStringLength = refValue.toString().length();
        }
        if (eobj != null) {
            boolean _tmp_ref = refname.startsWith("_tmp_ref.");
            if (refname != null && !_tmp_ref) {
                boolean createTrace = this._env.getTrace();
                System.out.println("Trace ? " + createTrace + "   " + refname);
                this._cachedTrace = ((TraceabilityEnvironment)this._env).createTrace(refValue.toString(), _positionCounter, _referenceStringLength, eobj, realRefName, rExec, refname);
            }
        }
    }

    @Override
    public void finalizeReferenceProcessing(String referenceValue) {
        if (this._cachedTrace != null) {
            this._cachedTrace.getSegment().setEndColumn(this._cachedTrace.getSegment().getStartColumn() + (long)referenceValue.length());
        }
    }

    protected void one() {
    }

    @Override
    public void storeTempValues(Object input, String refname) {
        if (input != null) {
            ((TraceabilityEnvironment)this._env)._tempObject = input;
            ((TraceabilityEnvironment)this._env)._tempRef = refname;
        }
    }

    @Override
    public void variableModelRef(Variable var, String refname) {
        Object varInfo;
        if (this._env.isInPrintAction() && (varInfo = ((TraceabilityEnvironment)this._env).getVariableInfo(var.getName())) != null) {
            TraceabilityEnvironment tEnv = (TraceabilityEnvironment)this._env;
            this.handleObjectReference(tEnv.getVariableEObject(refname), tEnv.getVariableRefName(refname), tEnv.getVariableValue(refname));
        }
    }
}

