/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.runtime.uml2Extensions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mofscript.runtime.MofScriptExecutionException;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;

public class UML2_MOFScriptUtil {
    public static final String[] umlOperations = new String[]{"getAppliedStereotypes", "getAppliedStereotype", "hasStereotype", "getValue", "hasValue", "getAssociations", "applyStereotype", "setValue", "applyProfile", "getAppliedProfiles", "getAppliedProfile"};
    public static final int[] umlOperationParameters;
    public static final String[] umlProposals;
    public static final String[] umlModelProposals;

    static {
        int[] nArray = new int[11];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 2;
        nArray[6] = 1;
        nArray[7] = 3;
        nArray[8] = 1;
        nArray[10] = 1;
        umlOperationParameters = nArray;
        umlProposals = new String[]{"getAppliedStereotypes()", "getAppliedStereotype(\"\")", "hasStereotype(\"\")", "getValue(stereotype, \"attrName\")", "hasValue (stereotype, \"attrName\")", "getAssociations()", "applyStereotype(st)", "setValue(stereotype, \"property\", \"val\")"};
        umlModelProposals = new String[]{"getAppliedProfiles()", "getAppliedProfile(\"p\")", "applyProfile(p)"};
    }

    public static void applyProfile(Object umlmdl, Object profile) {
        if (umlmdl instanceof Model && profile instanceof Profile) {
            Model mdl = (Model)umlmdl;
            mdl.applyProfile((Profile)profile);
            mdl.eResource();
        } else {
            System.out.println("UML_MOFScriptUtil::applyProfile(..) - Wrong types of input objects. Expected UML Model and Profile.");
        }
    }

    public static List<Profile> getAppliedProfiles(Object umlmdl) {
        if (umlmdl instanceof Model) {
            Model mdl = (Model)umlmdl;
            EList profiles = mdl.getAllAppliedProfiles();
            return profiles;
        }
        return new ArrayList<Profile>();
    }

    public static Profile getAppliedProfile(Object umlmdl, String pName) {
        Profile p = null;
        if (umlmdl instanceof Model) {
            p = ((Model)umlmdl).getAppliedProfile(pName);
        }
        return p;
    }

    public static void applyStereotype(EObject forObject, EObject stereotype) {
        Element umlElement = null;
        try {
            if (forObject instanceof Element && stereotype instanceof Stereotype) {
                umlElement = (Element)forObject;
                umlElement.applyStereotype((Stereotype)stereotype);
            } else {
                System.out.println("UML_MOFScriptUtil::addStereotype(..) - wrong types of input objects");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setValue(EObject forObject, EObject stereotype, String property, String value) {
        if (forObject instanceof Element && stereotype instanceof Stereotype) {
            Element el = (Element)forObject;
            Stereotype st = (Stereotype)stereotype;
            try {
                el.setValue(st, property, (Object)value);
            }
            catch (Exception exception) {
                System.out.println("UML_MOFScriptUtil::setValue(..) - failed setting value: " + value + " for property " + property);
            }
        } else {
            System.out.println("UML_MOFScriptUtil::setValue(..) - wrong types of input objects");
        }
    }

    public static List getStereoTypes(EObject forObject) {
        Element umlElement = null;
        EList appliedStereotypes = null;
        if (forObject instanceof Element) {
            umlElement = (Element)forObject;
            appliedStereotypes = umlElement.getAppliedStereotypes();
        }
        return appliedStereotypes;
    }

    public static EObject getStereoType(EObject forObject, String name) {
        List appliedStereotypes = UML2_MOFScriptUtil.getStereoTypes(forObject);
        Stereotype stType2 = null;
        for (Stereotype stType2 : appliedStereotypes) {
            if (!stType2.getName().equals(name)) continue;
            return stType2;
        }
        return null;
    }

    public static Object getValue(EObject forObject, Object stereotype, String name) throws MofScriptExecutionException {
        if (forObject instanceof Element && (stereotype instanceof String || stereotype instanceof StringBuffer)) {
            Stereotype st = (Stereotype)UML2_MOFScriptUtil.getStereoType(forObject, stereotype.toString());
            if (st == null) {
                throw new MofScriptExecutionException("Stereotype::getValue -  Stereotype " + stereotype + " does not exist", "", 0);
            }
            try {
                return ((Element)forObject).getValue(st, name);
            }
            catch (Exception exception) {
                throw new MofScriptExecutionException("Stereotype::getValue - " + name + " is not a property for stereotype " + stereotype, "", 0);
            }
        }
        if (forObject instanceof Element && stereotype instanceof Stereotype) {
            try {
                return ((Element)forObject).getValue((Stereotype)stereotype, name);
            }
            catch (Exception ex) {
                throw new MofScriptExecutionException("Stereotype::getValue: " + ex.getMessage(), "", 0);
            }
        }
        return "";
    }

    public static Boolean hasValue(EObject forObject, Object stereotype, String name) throws MofScriptExecutionException {
        if (forObject instanceof Element && (stereotype instanceof String || stereotype instanceof StringBuffer)) {
            try {
                Object val = UML2_MOFScriptUtil.getValue(forObject, stereotype, name);
                return val == null ? Boolean.FALSE : Boolean.TRUE;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return Boolean.FALSE;
            }
            catch (Exception ex) {
                throw new MofScriptExecutionException("# Exception in hasValue (): " + ex.toString(), "", 0);
            }
        }
        if (forObject instanceof Element && stereotype instanceof Stereotype) {
            try {
                Object val = UML2_MOFScriptUtil.getValue(forObject, stereotype, name);
                return val == null ? Boolean.FALSE : Boolean.TRUE;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return Boolean.FALSE;
            }
            catch (Exception ex) {
                throw new MofScriptExecutionException("# Exception in hasValue (): " + ex.toString(), "", 0);
            }
        }
        throw new MofScriptExecutionException("Wrong type passed to operation hasValue: Should be Stereotype. Is" + stereotype.getClass().getName(), "", 0);
    }

    public static List getKeywords(EObject forObject) {
        if (forObject instanceof Element) {
            return ((Element)forObject).getKeywords();
        }
        return new ArrayList();
    }

    public static boolean hasKeyword(EObject forObject, String name) {
        if (forObject instanceof Element) {
            return ((Element)forObject).hasKeyword(name);
        }
        return false;
    }
}

