/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.usage.analytics;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class EclipseUserAgent {
    public static final char BROWSER_LOCALE_DELIMITER = '-';
    public static final char JAVA_LOCALE_DELIMITER = '_';
    private static final String ECLIPSE_RUNTIME_BULDEID = "org.eclipse.core.runtime";
    private static final String USERAGENT_WIN = "{0}/{1} (Windows; U; Windows NT {2}; {3})";
    private static final String USERAGENT_MAC = "{0}/{1} (Macintosh; U; Intel Mac OS X {2}; {3})";
    private static final String USERAGENT_LINUX = "{0}/{1} (X11; U; Linux i686; {3})";
    public static final char VERSION_DELIMITER = '.';
    private static final String PROP_OS_VERSION = "os.version";
    private String browserLanguage;

    private String createBrowserLanguage() {
        String nl = this.getNL();
        if (nl == null) {
            return "";
        }
        int indexOf = nl.indexOf(95);
        if (indexOf <= 0) {
            return nl;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(nl.substring(0, indexOf));
        builder.append('-');
        builder.append(nl.substring(indexOf + 1));
        return builder.toString();
    }

    protected String getNL() {
        return Platform.getNL();
    }

    public String getBrowserLanguage() {
        if (this.browserLanguage == null) {
            this.browserLanguage = this.createBrowserLanguage();
        }
        return this.browserLanguage;
    }

    public String toString() {
        String productId = this.getApplicationName();
        String productVersion = this.getApplicationVersion();
        return MessageFormat.format(this.getUserAgentPattern(this.getOS()), productId, productVersion, this.getOSVersion(), this.getBrowserLanguage());
    }

    public String getOS() {
        return Platform.getOS();
    }

    public String getOSVersion() {
        return System.getProperty(PROP_OS_VERSION);
    }

    private String getUserAgentPattern(String os) {
        String userAgentPattern = "";
        if ("linux".equals(os)) {
            return USERAGENT_LINUX;
        }
        if ("macosx".equals(os)) {
            return USERAGENT_MAC;
        }
        if ("win32".equals(os)) {
            return USERAGENT_WIN;
        }
        return userAgentPattern;
    }

    public String getApplicationName() {
        return this.getApplicationBundle().getSymbolicName();
    }

    public String getApplicationVersion() {
        String fullVersion = this.getApplicationBundle().getVersion().toString();
        int productVersionStart = fullVersion.lastIndexOf(46);
        if (productVersionStart > 0) {
            return fullVersion.substring(0, productVersionStart);
        }
        return fullVersion;
    }

    private Bundle getApplicationBundle() {
        IProduct product = Platform.getProduct();
        if (product != null) {
            return product.getDefiningBundle();
        }
        return Platform.getBundle((String)ECLIPSE_RUNTIME_BULDEID);
    }
}

