/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.usage.analytics;

import com.dmurph.tracking.AnalyticsConfigData;
import com.dmurph.tracking.JGoogleAnalyticsTracker;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.UUID;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.obeonetwork.dsl.uml2.design.UMLDesignerPlugin;
import org.obeonetwork.dsl.uml2.usage.UsageActivator;
import org.obeonetwork.dsl.uml2.usage.analytics.EclipseUserAgent;
import org.obeonetwork.dsl.uml2.usage.analytics.UsageMessages;
import org.obeonetwork.dsl.uml2.usage.dialog.UsageDialog;
import org.obeonetwork.dsl.uml2.usage.preferences.UsagePreferences;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class SiriusEditorsListener
extends SessionManagerListener.Stub
implements IPartListener2 {
    private static final String ANALYTICS_ID = UsageMessages.Usage_GoogleAnalytics;
    private JGoogleAnalyticsTracker tracker;
    private EclipseUserAgent eclipseUserAgent;
    private String hostname;
    private UsagePreferences preferences = new UsagePreferences();
    private String bundleVersion = "";

    public SiriusEditorsListener() {
        AnalyticsConfigData config = new AnalyticsConfigData(ANALYTICS_ID);
        this.eclipseUserAgent = new EclipseUserAgent();
        config.setUserAgent(this.eclipseUserAgent.toString());
        this.tracker = new JGoogleAnalyticsTracker(config, JGoogleAnalyticsTracker.GoogleAnalyticsVersion.V_4_7_2);
        this.hostname = this.getOrCreateHostname();
        this.bundleVersion = this.readableVersion();
    }

    private String readableVersion() {
        Version v = UMLDesignerPlugin.getDefault().getBundle().getVersion();
        StringBuffer result = new StringBuffer(10);
        result.append(v.getMajor());
        result.append('.');
        result.append(v.getMinor());
        result.append('.');
        result.append(v.getMicro());
        return result.toString();
    }

    private String getOrCreateHostname() {
        UUID idOne = UUID.randomUUID();
        String found = idOne.toString();
        try {
            found = this.retrieveMarker(found);
        }
        catch (IOException e) {
            UsageActivator.log(4, UsageMessages.Error_CreatingGoogleAnalyticsConfig, e);
        }
        return found;
    }

    private String retrieveMarker(String found) throws IOException {
        IPath path = Platform.getStateLocation((Bundle)UsageActivator.getDefault().getBundle());
        if (path != null) {
            if (!(path = path.append("hostname")).toFile().exists()) {
                Files.write((CharSequence)found, (File)path.toFile(), (Charset)Charset.forName("UTF-8"));
            } else if (path.toFile().canRead()) {
                return Files.readFirstLine((File)path.toFile(), (Charset)Charset.forName("UTF-8"));
            }
        }
        return found;
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (part instanceof DialectEditor) {
            RepresentationDescription description;
            this.askUser();
            if (!this.preferences.isEnabled()) {
                return;
            }
            DialectEditor dEditor = (DialectEditor)part;
            DRepresentation rep = dEditor.getRepresentation();
            if (rep != null && DialectManager.INSTANCE.getDescription(rep) != null && (description = DialectManager.INSTANCE.getDescription(rep)) != null) {
                String diagURI = EcoreUtil.getURI((EObject)description).toString();
                String diagTypeName = description.getName();
                String viewpointName = ((Viewpoint)description.eContainer()).getName();
                this.preferences.storeDiagramsUsage(diagTypeName);
                this.tracker.trackPageViewFromReferrer(String.valueOf(viewpointName) + "/" + diagTypeName, diagURI.toString(), this.hostname, String.valueOf(this.eclipseUserAgent.getApplicationName()) + ":" + this.eclipseUserAgent.getApplicationVersion(), "");
            }
        }
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    private void askUser() {
        if (this.preferences.hasAnswered()) {
            return;
        }
        Shell shell = PlatformUI.getWorkbench().getModalDialogShellProvider().getShell();
        UsageDialog dialog = new UsageDialog(shell);
        int answer = dialog.open();
        this.preferences.storeUserAnswer(answer);
        if (this.preferences.isEnabled()) {
            this.tracker.trackPageViewFromReferrer(String.valueOf(UsageMessages.Usage_ActivationPageURL) + "/" + this.bundleVersion, UsageMessages.Usage_ActivationPageTitle, this.hostname, String.valueOf(this.eclipseUserAgent.getApplicationName()) + ":" + this.eclipseUserAgent.getApplicationVersion(), "");
        }
    }

    public void notify(Session updated, int notification) {
        if (notification == 7 && this.preferences.isEnabled()) {
            this.tracker.trackPageViewFromReferrer(String.valueOf(UsageMessages.Usage_OpenPageURL) + "/" + this.bundleVersion, UsageMessages.Usage_OpenPageTitle, this.hostname, String.valueOf(this.eclipseUserAgent.getApplicationName()) + ":" + this.eclipseUserAgent.getApplicationVersion(), "");
        }
    }
}

