/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.usage.preferences;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.obeonetwork.dsl.uml2.design.UMLDesignerPlugin;

public class UsagePreferences {
    public static final String USAGE_USER_ANSWER_ID = "usage_user_answer_preference";
    public static final String USAGE_ENABLED_ID = "usage_enabled_preference";
    public static final String USAGE_DIAGRAMS_ID = "usage_diagrams_preference";
    private IPreferenceStore preferenceStore = UMLDesignerPlugin.getDefault().getPreferenceStore();

    public boolean hasAnswered() {
        return this.preferenceStore.getInt(USAGE_USER_ANSWER_ID) == 2 || this.preferenceStore.getInt(USAGE_USER_ANSWER_ID) == 3;
    }

    public boolean isEnabled() {
        return this.preferenceStore.getBoolean(USAGE_ENABLED_ID);
    }

    public void storeUserAnswer(int answerId) {
        this.preferenceStore.setValue(USAGE_USER_ANSWER_ID, answerId);
        if (answerId == 2) {
            this.preferenceStore.setValue(USAGE_ENABLED_ID, true);
        }
        if (answerId == 3) {
            this.preferenceStore.setValue(USAGE_ENABLED_ID, false);
        }
    }

    public void storeDiagramsUsage(String diagramName) {
        String storedDiagrams = this.preferenceStore.getString(USAGE_DIAGRAMS_ID);
        HashMap<String, String> map = new HashMap<String, String>();
        char keySeparator = ';';
        String valueSeparator = "=";
        if (storedDiagrams.length() > 0) {
            Map unmodifiableMap = Splitter.on((char)keySeparator).trimResults().withKeyValueSeparator(valueSeparator).split((CharSequence)storedDiagrams);
            map.putAll(unmodifiableMap);
        }
        int value = 0;
        if (map.containsKey(diagramName)) {
            String storedValue = (String)map.get(diagramName);
            value = Integer.parseInt(storedValue);
        }
        map.put(diagramName, String.valueOf(++value));
        storedDiagrams = Joiner.on((char)keySeparator).withKeyValueSeparator(valueSeparator).join(map);
        this.preferenceStore.setValue(USAGE_DIAGRAMS_ID, storedDiagrams);
    }

    public String getDiagramsUsage() {
        return this.preferenceStore.getString(USAGE_DIAGRAMS_ID);
    }
}

