/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.usage.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.obeonetwork.dsl.uml2.design.UMLDesignerPlugin;
import org.obeonetwork.dsl.uml2.usage.analytics.EclipseUserAgent;
import org.obeonetwork.dsl.uml2.usage.preferences.PreferencesMessages;
import org.obeonetwork.dsl.uml2.usage.preferences.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsagePreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public UsagePreferencesPage() {
        super(1);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.createReportingData((Composite)control);
        return control;
    }

    private void createReportingData(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(PreferencesMessages.Usage_PreferencePage_ReportedValues);
        GridDataFactory.fillDefaults().grab(true, true).hint(4, 4).applyTo((Control)group);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginHeight = 4;
        fillLayout.marginWidth = 8;
        group.setLayout((Layout)fillLayout);
        StyledText text = new StyledText((Composite)group, 2560);
        text.setEditable(false);
        this.createText(text);
    }

    private void createText(StyledText text) {
        ArrayList<StyleRange> styles = new ArrayList<StyleRange>();
        StringBuilder builder = new StringBuilder();
        EclipseUserAgent eclipseUserAgent = new EclipseUserAgent();
        this.appendLabeledValue(PreferencesMessages.Usage_PreferencePage_ProductId, eclipseUserAgent.getApplicationName(), builder, styles);
        this.appendLabeledValue(PreferencesMessages.Usage_PreferencePage_ProductVersion, eclipseUserAgent.getApplicationVersion(), builder, styles);
        builder.append(StringUtils.getLineSeparator());
        this.appendLabeledValue(PreferencesMessages.Usage_PreferencePage_OperatingSystem, eclipseUserAgent.getOS(), builder, styles);
        this.appendLabeledValue(PreferencesMessages.Usage_PreferencePage_OperatingSystemVersion, eclipseUserAgent.getOSVersion(), builder, styles);
        builder.append(StringUtils.getLineSeparator());
        this.appendLabeledValue(PreferencesMessages.Usage_PreferencePage_Locale, eclipseUserAgent.getBrowserLanguage(), builder, styles);
        builder.append(StringUtils.getLineSeparator());
        this.appendLabeledValue(PreferencesMessages.Usage_PreferencePage_Diagrams, UMLDesignerPlugin.getDefault().getPreferenceStore().getString("usage_diagrams_preference"), builder, styles);
        builder.append(StringUtils.getLineSeparator());
        text.setText(builder.toString());
        for (StyleRange style : styles) {
            text.setStyleRange(style);
        }
    }

    private void appendLabeledValue(String label, String value, StringBuilder builder, List<StyleRange> styles) {
        StyleRange styleRange = this.startLabelStyleRange(builder);
        builder.append(label);
        this.finishLabelStyleRange(builder, styleRange);
        builder.append(value).append(StringUtils.getLineSeparator());
        styles.add(styleRange);
    }

    private StyleRange startLabelStyleRange(StringBuilder builder) {
        StyleRange styleRange = new StyleRange();
        styleRange.start = builder.length();
        styleRange.fontStyle = 1;
        return styleRange;
    }

    private StyleRange finishLabelStyleRange(StringBuilder builder, StyleRange styleRange) {
        styleRange.length = builder.length() - styleRange.start;
        return styleRange;
    }

    public void createFieldEditors() {
        this.addField((FieldEditor)new BooleanFieldEditor("usage_enabled_preference", PreferencesMessages.Usage_PreferencePage_AllowReporting, this.getFieldEditorParent()));
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(UMLDesignerPlugin.getDefault().getPreferenceStore());
        this.setDescription(PreferencesMessages.Usage_PreferencePage_Description);
    }
}

