/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.cheatsheets.handlers;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.rmf.cheatsheets.CheatSheetsPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractOpenWizardHandler
extends Action {
    private IStructuredSelection getSelection() {
        ISelection selection;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (selection = window.getSelectionService().getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    public void run() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        try {
            INewWizard wizard = this.createWizard();
            wizard.init(PlatformUI.getWorkbench(), this.getSelection());
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            dialog.create();
            dialog.open();
        }
        catch (CoreException e) {
            CheatSheetsPlugin.INSTANCE.log((Object)e);
        }
    }

    protected abstract INewWizard createWizard() throws CoreException;
}

