/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.sysml.design;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLPackage;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.obeonetwork.dsl.sysml.design";
    public static final String SYSML_PROFILES_PATHMAP = "pathmap://SysML_PROFILES/";
    public static final String STANDARD_PROFILES_PATHMAP = "pathmap://UML_PROFILES/";
    protected static final String SYSML_PROFILE_PATH = "SysML.profile.uml";
    protected static final String STANDARD_PROFILE_PATH = "Standard.profile.uml";
    private static Activator plugin;
    private static Set<Viewpoint> viewpoints;
    private static URI sysMLProfileURI;
    private static URI standardProfileURI;
    private static Profile sysMLProfile;
    private static Profile standardProfile;

    public Activator() {
        URI sysMLProfilesURI = URI.createURI((String)SYSML_PROFILES_PATHMAP);
        sysMLProfileURI = sysMLProfilesURI.appendSegment(SYSML_PROFILE_PATH);
        Activator.loadSysMLProfile();
        URI standardProfilesURI = URI.createURI((String)STANDARD_PROFILES_PATHMAP);
        standardProfileURI = standardProfilesURI.appendSegment(STANDARD_PROFILE_PATH);
        Activator.loadStandardProfile();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        viewpoints = new HashSet<Viewpoint>();
        viewpoints.addAll(ViewpointRegistry.getInstance().registerFromPlugin("org.obeonetwork.dsl.sysml.design/description/sysml.odesign"));
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        if (viewpoints != null) {
            for (Viewpoint viewpoint : viewpoints) {
                ViewpointRegistry.getInstance().disposeFromPlugin(viewpoint);
            }
            viewpoints.clear();
            viewpoints = null;
        }
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static URI getSysMLProfileURI() {
        return sysMLProfileURI;
    }

    public static URI getStandardProfileURI() {
        return standardProfileURI;
    }

    public static Profile getSysMLProfile() {
        return sysMLProfile;
    }

    public static Profile getStandardProfile() {
        return standardProfile;
    }

    public static void log(int severity, String message, Throwable exception) {
        Activator.getDefault().getLog().log((IStatus)new Status(severity, PLUGIN_ID, message, exception));
    }

    protected static void loadSysMLProfile() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        try {
            Resource resource = resourceSet.getResource(sysMLProfileURI, true);
            sysMLProfile = (Profile)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)UMLPackage.Literals.PACKAGE);
        }
        catch (WrappedException we) {
            Activator.log(4, "Can't get the SysML profile !", we);
        }
    }

    protected static void loadStandardProfile() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        try {
            Resource resource = resourceSet.getResource(standardProfileURI, true);
            standardProfile = (Profile)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)UMLPackage.Literals.PACKAGE);
        }
        catch (WrappedException we) {
            Activator.log(4, "Can't get the Standard profile !", we);
        }
    }
}

