/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.sysml.design.api.services;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.sysml.blocks.Block;
import org.eclipse.papyrus.sysml.blocks.Dimension;
import org.eclipse.papyrus.sysml.blocks.Unit;
import org.eclipse.papyrus.sysml.blocks.ValueType;
import org.eclipse.papyrus.sysml.constraints.ConstraintBlock;
import org.eclipse.papyrus.sysml.constraints.ConstraintProperty;
import org.eclipse.papyrus.sysml.requirements.Requirement;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.uml2.uml.Abstraction;
import org.eclipse.uml2.uml.Actor;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.obeonetwork.dsl.sysml.design.api.services.SysmlAbstractDiagramServices;
import org.obeonetwork.dsl.sysml.design.internal.services.SysmlElementServices;
import org.obeonetwork.dsl.uml2.design.api.utils.UmlUtils;
import org.obeonetwork.dsl.uml2.design.internal.services.LabelServices;
import org.obeonetwork.dsl.uml2.design.internal.services.NodeInverseRefsServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockDefinitionDiagramServices
extends SysmlAbstractDiagramServices {
    public String computeAssociationBeginLabel(Association association) {
        return LabelServices.INSTANCE.computeAssociationBeginLabel(association);
    }

    public String computeAssociationEndLabel(Association association) {
        return LabelServices.INSTANCE.computeAssociationEndLabel(association);
    }

    public void deleteAssociatedStereotype(Element e, String steQualified) {
        SysmlElementServices.INSTANCE.deleteAssociatedStereotype(e, steQualified);
    }

    public List<Element> getAllActorsAndContainers(Element element) {
        ArrayList results = Lists.newArrayList();
        List models = this.getAllAvailableRootPackages(element);
        results.addAll(models);
        for (Package pkg : models) {
            TreeIterator iterator = pkg.eAllContents();
            while (iterator.hasNext()) {
                EObject iter = (EObject)iterator.next();
                if (!(iter instanceof Actor) && !(iter instanceof Package)) continue;
                results.add((Element)iter);
            }
        }
        return results;
    }

    public List<InstanceSpecification> getAllDimensions(Element valueType) {
        ArrayList results = Lists.newArrayList();
        TreeIterator iterator = valueType.getModel().eAllContents();
        while (iterator.hasNext()) {
            EObject element = (EObject)iterator.next();
            if (!(element instanceof InstanceSpecification) || !SysmlElementServices.INSTANCE.isDimension((InstanceSpecification)element)) continue;
            results.add((InstanceSpecification)element);
        }
        return results;
    }

    public List<InstanceSpecification> getAllUnits(Element valueType) {
        ArrayList results = Lists.newArrayList();
        TreeIterator iterator = valueType.getModel().eAllContents();
        while (iterator.hasNext()) {
            EObject element = (EObject)iterator.next();
            if (!(element instanceof InstanceSpecification) || !this.isUnit((InstanceSpecification)element)) continue;
            results.add((InstanceSpecification)element);
        }
        return results;
    }

    public Collection<EObject> getAssociationInverseRefs(DDiagram diagram) {
        return NodeInverseRefsServices.INSTANCE.getAssociationInverseRefs(diagram);
    }

    public Collection<EObject> getDependencyInverseRefs(DDiagram diagram) {
        return NodeInverseRefsServices.INSTANCE.getDependencyInverseRefs(diagram);
    }

    public Dimension getDimension(Element valueType) {
        for (EObject stereotype : valueType.getStereotypeApplications()) {
            if (!(stereotype instanceof ValueType)) continue;
            return ((ValueType)stereotype).getDimension();
        }
        return null;
    }

    public Collection<EObject> getGeneralizationInverseRefs(DDiagram diagram) {
        return NodeInverseRefsServices.INSTANCE.getGeneralizationInverseRefs(diagram);
    }

    public Collection<EObject> getInterfaceRealizationInverseRefs(DDiagram diagram) {
        return NodeInverseRefsServices.INSTANCE.getInterfaceRealizationInverseRefs(diagram);
    }

    public List<Class> getSatisfiedRequirements(Class element) {
        ArrayList results = Lists.newArrayList();
        Collection xRefs = SessionManager.INSTANCE.getSession((EObject)element).getSemanticCrossReferencer().getInverseReferences((EObject)element);
        for (EStructuralFeature.Setting xRef : xRefs) {
            EObject eObject = xRef.getEObject();
            if (!(eObject instanceof Abstraction)) continue;
            for (Element supplier : ((Abstraction)eObject).getSuppliers()) {
                if (!(supplier instanceof Class)) continue;
                for (EObject stereotype : supplier.getStereotypeApplications()) {
                    if (!(stereotype instanceof Requirement)) continue;
                    results.add((Class)supplier);
                }
            }
        }
        return results;
    }

    public Type getUmlStringType(EObject object) {
        return UmlUtils.INSTANCE.findTypeByName(object, "String");
    }

    public Unit getUnit(Element valueType) {
        for (EObject stereotype : valueType.getStereotypeApplications()) {
            if (!(stereotype instanceof ValueType)) continue;
            return ((ValueType)stereotype).getUnit();
        }
        return null;
    }

    public boolean isBlock(Element element) {
        return SysmlElementServices.INSTANCE.isBlock(element);
    }

    public boolean isConstraintBlock(Classifier element) {
        return SysmlElementServices.INSTANCE.isConstraintBlock(element);
    }

    public boolean isDimension(InstanceSpecification element) {
        return SysmlElementServices.INSTANCE.isDimension(element);
    }

    public boolean isRequirement(Element element) {
        return SysmlElementServices.INSTANCE.isRequirement(element);
    }

    public boolean isUnit(InstanceSpecification element) {
        for (EObject stereotype : element.getStereotypeApplications()) {
            if (!(stereotype instanceof Unit)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidBlockDefinitionDiagramRoot(NamedElement element) {
        if (element instanceof Package) {
            return true;
        }
        if (element instanceof Class) {
            return SysmlElementServices.INSTANCE.isBlock((Element)element);
        }
        return false;
    }

    public boolean isValueType(NamedElement element) {
        for (EObject stereotype : element.getStereotypeApplications()) {
            if (!(stereotype instanceof ValueType)) continue;
            return true;
        }
        return false;
    }

    public void setDimension(Element dataType, InstanceSpecification instanceSpecification) {
        EObject stereotype;
        if (dataType.getStereotypeApplications() != null && (stereotype = (EObject)dataType.getStereotypeApplications().get(0)) instanceof ValueType) {
            ValueType valueType = (ValueType)stereotype;
            if (instanceSpecification.getStereotypeApplications() != null && (stereotype = (EObject)instanceSpecification.getStereotypeApplications().get(0)) instanceof Dimension) {
                Dimension dimension = (Dimension)stereotype;
                valueType.setDimension(dimension);
            }
        }
    }

    public void setUnit(Element dataType, InstanceSpecification instanceSpecification) {
        EObject stereotype;
        if (dataType.getStereotypeApplications() != null && (stereotype = (EObject)dataType.getStereotypeApplications().get(0)) instanceof ValueType) {
            ValueType valueType = (ValueType)stereotype;
            if (instanceSpecification.getStereotypeApplications() != null && (stereotype = (EObject)instanceSpecification.getStereotypeApplications().get(0)) instanceof Unit) {
                Unit unit = (Unit)stereotype;
                valueType.setUnit(unit);
            }
        }
    }

    public void unsetDimension(EObject valueType) {
        ((ValueType)((Element)valueType).getStereotypeApplications()).setDimension(null);
    }

    public Element updateStereotype(Element element) {
        Type type;
        if (element instanceof Property && (type = ((Property)element).getType()) != null) {
            EList elementStereotypes = element.getStereotypeApplications();
            EList typeStereotypes = type.getStereotypeApplications();
            block0: for (EObject typeStereotype : typeStereotypes) {
                if (typeStereotype instanceof ConstraintBlock) {
                    if (elementStereotypes == null || elementStereotypes.isEmpty()) {
                        SysmlElementServices.INSTANCE.createAssociatedStereotype(element, "SysML::Constraints", "ConstraintProperty");
                        break;
                    }
                    for (EObject elementStereotype : elementStereotypes) {
                        if (elementStereotype instanceof ConstraintProperty) continue;
                        SysmlElementServices.INSTANCE.createAssociatedStereotype(element, "SysML::Constraints", "ConstraintProperty");
                        continue block0;
                    }
                    continue;
                }
                if (!(typeStereotype instanceof Block)) continue;
                for (EObject elementStereotype : elementStereotypes) {
                    if (!(elementStereotype instanceof ConstraintProperty)) continue;
                    this.deleteAssociatedStereotype(element, "SysML::Constraints::ConstraintProperty");
                    continue block0;
                }
            }
        }
        return element;
    }
}

