/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.sysml.design.api.services;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.sysml.portandflows.FlowDirection;
import org.eclipse.papyrus.sysml.portandflows.FlowPort;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.PrimitiveType;
import org.obeonetwork.dsl.sysml.design.api.services.SysmlAbstractDiagramServices;
import org.obeonetwork.dsl.sysml.design.internal.services.PortServices;
import org.obeonetwork.dsl.sysml.design.internal.services.SysmlElementServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalBlockDiagramServices
extends SysmlAbstractDiagramServices {
    public List<Class> getAllNonConstraintBlocks(EObject container) {
        ArrayList blocks = Lists.newArrayList();
        TreeIterator iterator = SysmlElementServices.INSTANCE.getRootContainer(container).eAllContents();
        while (iterator.hasNext()) {
            EObject element = (EObject)iterator.next();
            if (!(element instanceof Class) || !SysmlElementServices.INSTANCE.isBlock((Element)((Class)element)) || SysmlElementServices.INSTANCE.isConstraintBlock((Classifier)((Class)element))) continue;
            blocks.add((Class)element);
        }
        return blocks;
    }

    private FlowPort getFlowPort(NamedElement element) {
        for (EObject stereotype : element.getStereotypeApplications()) {
            if (!(stereotype instanceof FlowPort)) continue;
            return (FlowPort)stereotype;
        }
        return null;
    }

    public DNodeContainer getParentView(Element element) {
        Session session = SessionManager.INSTANCE.getSession((EObject)element);
        Collection refs = session.getSemanticCrossReferencer().getInverseReferences(element.eContainer());
        for (EStructuralFeature.Setting setting : refs) {
            if (!(setting.getEObject() instanceof DNodeContainer)) continue;
            return (DNodeContainer)setting.getEObject();
        }
        return null;
    }

    public List<Classifier> getPortTypes(EObject container) {
        ArrayList results = Lists.newArrayList();
        TreeIterator iterator = SysmlElementServices.INSTANCE.getRootContainer(container).eAllContents();
        while (iterator.hasNext()) {
            EObject element = (EObject)iterator.next();
            if (!(element instanceof Classifier) || SysmlElementServices.INSTANCE.isConstraintBlock((Classifier)element) || !SysmlElementServices.INSTANCE.isBlock((Element)((Classifier)element)) && !(element instanceof PrimitiveType) && !(element instanceof DataType) && !(element instanceof Interface)) continue;
            results.add((Classifier)element);
        }
        return results;
    }

    public boolean isFlowPort(Element element) {
        return SysmlElementServices.INSTANCE.isFlowPort(element);
    }

    public boolean isInFlowPort(NamedElement element) {
        FlowPort port = this.getFlowPort(element);
        return port.getDirection().equals((Object)FlowDirection.IN);
    }

    public boolean isInPort(NamedElement element) {
        return this.isPort(element) && ((Port)element).getRequireds().size() > 0;
    }

    public boolean isNotDelegationOf(Port source, Port target) {
        return PortServices.INSTANCE.isNotDelegationOf(source, target);
    }

    public boolean isOutFlowPort(NamedElement element) {
        FlowPort port = this.getFlowPort(element);
        return port.getDirection().equals((Object)FlowDirection.OUT);
    }

    public boolean isOutPort(NamedElement element) {
        return this.isPort(element) && ((Port)element).getProvideds().size() > 0;
    }

    public boolean isPort(NamedElement element) {
        return element instanceof Port && !SysmlElementServices.INSTANCE.isFlowPort((Element)element);
    }

    public boolean isValidInternalBlockDiagramRoot(Class element) {
        return SysmlElementServices.INSTANCE.isBlock((Element)element);
    }
}

