/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.sysml.design.api.services;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.internal.metamodel.spec.DSemanticDiagramSpec;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Actor;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.obeonetwork.dsl.sysml.design.internal.services.SysmlElementServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReusedDescriptionServices
extends org.obeonetwork.dsl.uml2.design.api.services.ReusedDescriptionServices {
    private List<EObject> allValidAttributes(Class cur, Predicate<EObject> validForDiagram) {
        ArrayList result = Lists.newArrayList();
        Iterators.addAll((Collection)result, (Iterator)Iterators.filter((Iterator)cur.getAttributes().iterator(), validForDiagram));
        return result;
    }

    private List<EObject> allValidSessionElements(EObject cur, Predicate<EObject> validForDiagram) {
        Session found = SessionManager.INSTANCE.getSession(cur);
        ArrayList result = Lists.newArrayList();
        if (found != null) {
            for (Resource res : found.getSemanticResources()) {
                Iterators.addAll((Collection)result, (Iterator)Iterators.filter((Iterator)res.getAllContents(), validForDiagram));
            }
        }
        return result;
    }

    public void createAssociatedStereotype(Element e, String profileQualifiedName, String stereotypeName) {
        SysmlElementServices.INSTANCE.createAssociatedStereotype(e, profileQualifiedName, stereotypeName);
    }

    public boolean existValidElementsForContainerView(EObject container, EObject containerView) {
        if (container instanceof Element && containerView instanceof DSemanticDecorator) {
            Session session = SessionManager.INSTANCE.getSession(container);
            List semanticElementMappings = this.getMappings((DSemanticDecorator)containerView, session);
            return semanticElementMappings.size() > 0;
        }
        return false;
    }

    private List<EObject> getValidsForBlockDefinitionDiagram(EObject cur) {
        Predicate<EObject> validForDiagram = new Predicate<EObject>(){

            public boolean apply(EObject input) {
                return "Model".equals(input.eClass().getName()) || "Package".equals(input.eClass().getName()) || input instanceof Interface || input instanceof InstanceSpecification && ReusedDescriptionServices.this.hasStereotype((Element)((InstanceSpecification)input), "Unit") || input instanceof InstanceSpecification && ReusedDescriptionServices.this.hasStereotype((Element)((InstanceSpecification)input), "Dimension") || input instanceof DataType || input instanceof Actor || input instanceof Class && ReusedDescriptionServices.this.hasStereotype((Element)((Class)input), "Block") || input instanceof Class && ReusedDescriptionServices.this.hasStereotype((Element)((Class)input), "ConstraintBlock");
            }
        };
        return this.allValidSessionElements(cur, validForDiagram);
    }

    private List<EObject> getValidsForInternalBlockDiagram(Class cur) {
        Predicate<EObject> validForDiagram = new Predicate<EObject>(){

            public boolean apply(EObject input) {
                return !(input instanceof Port) && input instanceof Property;
            }
        };
        return this.allValidAttributes(cur, validForDiagram);
    }

    private List<EObject> getValidsForParametricBlockDiagram(Class cur) {
        final boolean isValueBindingLayerActive = this.isValueBindingLayerActive((EObject)cur);
        Predicate<EObject> validForDiagram = new Predicate<EObject>(){

            public boolean apply(EObject input) {
                if (!isValueBindingLayerActive) {
                    return !(input instanceof Port) && input instanceof Property && ReusedDescriptionServices.this.hasStereotype((Element)input, "ConstraintProperty");
                }
                return !(input instanceof Port) && input instanceof Property;
            }
        };
        return this.allValidAttributes(cur, validForDiagram);
    }

    private List<EObject> getValidsForRequirementDiagram(Element cur, final DDiagram diagram) {
        this.isVerifyLayerActive(diagram);
        this.isSatisfyLayerActive(diagram);
        this.isRefineLayerActive(diagram);
        Predicate<EObject> validForClassDiagram = new Predicate<EObject>(){

            public boolean apply(EObject input) {
                return input instanceof Package || "Class".equals(input.eClass().getName()) && ((Class)input).getAppliedStereotype("SysML::Requirements::Requirement") != null || ReusedDescriptionServices.this.isVerifyLayerActive(diagram) && (input instanceof Class && this.isTestClass((Class)input) || input instanceof Operation && ((Operation)input).getAppliedStereotype("SysML::Requirements::TestCase") != null) || ReusedDescriptionServices.this.isSatisfyLayerActive(diagram) && input instanceof Class && ((Class)input).getAppliedStereotype("SysML::Blocks::Block") != null || ReusedDescriptionServices.this.isRefineLayerActive(diagram) && (input instanceof Behavior || input instanceof BehavioredClassifier);
            }

            private boolean isTestClass(Class input) {
                for (Operation operation : input.getAllOperations()) {
                    if (operation.getAppliedStereotype("SysML::Requirements::TestCase") == null) continue;
                    return true;
                }
                return false;
            }
        };
        return this.allValidSessionElements((EObject)cur, validForClassDiagram);
    }

    public List<EObject> getValidsForSysmlDiagram(Element element, DSemanticDecorator containerView) {
        DRepresentation representation = null;
        if (containerView instanceof DRepresentation) {
            representation = (DRepresentation)containerView;
        } else if (containerView instanceof DDiagramElement) {
            representation = ((DDiagramElement)containerView).getParentDiagram();
        }
        List<EObject> results = null;
        if (representation instanceof DSemanticDiagramSpec) {
            DiagramDescription description = ((DSemanticDiagramSpec)representation).getDescription();
            if ("Block Definition Diagram".equals(description.getName())) {
                results = this.getValidsForBlockDefinitionDiagram((EObject)element);
            } else if ("Internal Block Diagram".equals(description.getName())) {
                results = this.getValidsForInternalBlockDiagram((Class)element);
            } else if ("Parametric Diagram".equals(description.getName())) {
                results = this.getValidsForParametricBlockDiagram((Class)element);
            } else if ("Requirement Diagram".equals(description.getName())) {
                results = this.getValidsForRequirementDiagram(element, (DDiagram)representation);
            }
        }
        return results;
    }

    protected boolean hasStereotype(Element element, String stereotypeName) {
        for (EObject stereotype : element.getStereotypeApplications()) {
            if (!stereotypeName.equals(stereotype.eClass().getName())) continue;
            return true;
        }
        return false;
    }

    private boolean isLayerActive(DDiagram diagram, String layerName) {
        for (Layer layer : diagram.getActivatedLayers()) {
            if (!layerName.equals(layer.getName())) continue;
            return true;
        }
        return false;
    }

    protected boolean isRefineLayerActive(DDiagram diagram) {
        return this.isLayerActive(diagram, "Refine");
    }

    protected boolean isSatisfyLayerActive(DDiagram diagram) {
        return this.isLayerActive(diagram, "Satisfy");
    }

    public boolean isValidAttributesContainer(EObject container, EObject containerView) {
        return this.existValidElementsForContainerView(container, containerView) && !(containerView instanceof DDiagram);
    }

    private boolean isValueBindingLayerActive(EObject cur) {
        DialectEditor dialectEditor;
        DRepresentation representation;
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor instanceof DialectEditor && (representation = (dialectEditor = (DialectEditor)editor).getRepresentation()) instanceof DDiagram) {
            DDiagram diagram = (DDiagram)representation;
            EList layers = diagram.getActivatedLayers();
            for (Layer layer : layers) {
                if (!"PAR ValueBinding Layer".equals(layer.getName())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isVerifyLayerActive(DDiagram diagram) {
        return this.isLayerActive(diagram, "Verify");
    }
}

