/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.sysml.design.internal.services;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.util.UMLSwitch;
import org.obeonetwork.dsl.sysml.design.internal.services.SysmlElementServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComputeLabelSwitch
extends UMLSwitch<String> {
    public String caseActivity(Activity element) {
        Predicate<EObject> predicate = new Predicate<EObject>(){

            public boolean apply(EObject input) {
                return input instanceof Activity;
            }
        };
        return this.computeLabel((EObject)element, "function", (Predicate)predicate);
    }

    public String caseClass(Class element) {
        Object predicate = null;
        if (SysmlElementServices.INSTANCE.isConstraintBlock((Classifier)element)) {
            predicate = new Predicate<EObject>(){

                public boolean apply(EObject input) {
                    return input instanceof Class && SysmlElementServices.INSTANCE.isConstraintBlock((Classifier)input);
                }
            };
            return this.computeLabel((EObject)element, this.getSysmlTypeName((NamedElement)element), (Predicate)predicate);
        }
        if (SysmlElementServices.INSTANCE.isBlock((Element)element)) {
            predicate = new Predicate<EObject>(){

                public boolean apply(EObject input) {
                    return input instanceof Class && SysmlElementServices.INSTANCE.isBlock((Element)((Classifier)input));
                }
            };
            return this.computeLabel((EObject)element, this.getSysmlTypeName((NamedElement)element), (Predicate)predicate);
        }
        if (SysmlElementServices.INSTANCE.isRequirement((Element)element)) {
            predicate = new Predicate<EObject>(){

                public boolean apply(EObject input) {
                    return input instanceof Class && SysmlElementServices.INSTANCE.isRequirement((Element)((Class)input));
                }
            };
            return this.computeLabel((EObject)element, this.getSysmlTypeName((NamedElement)element), (Predicate)predicate);
        }
        predicate = new Predicate<EObject>(){

            public boolean apply(EObject input) {
                return input instanceof Class;
            }
        };
        return this.computeLabel((EObject)element, this.getUmlTypeName((NamedElement)element), (Predicate)predicate);
    }

    public String caseInterface(Interface element) {
        Predicate<EObject> predicate = new Predicate<EObject>(){

            public boolean apply(EObject input) {
                return input instanceof Interface;
            }
        };
        return this.computeLabel((EObject)element, this.getUmlTypeName((NamedElement)element), (Predicate)predicate);
    }

    public String caseOperation(Operation element) {
        Object predicate = null;
        if (SysmlElementServices.INSTANCE.isTestCase((NamedElement)element)) {
            predicate = new Predicate<EObject>(){

                public boolean apply(EObject input) {
                    return input instanceof Operation && SysmlElementServices.INSTANCE.isTestCase((NamedElement)input);
                }
            };
            return this.computeLabel((EObject)element, this.getSysmlTypeName((NamedElement)element), (Predicate)predicate);
        }
        predicate = new Predicate<EObject>(){

            public boolean apply(EObject input) {
                return input instanceof Operation;
            }
        };
        return this.computeLabel((EObject)element, "function", (Predicate)predicate);
    }

    public String casePackage(Package element) {
        Predicate<EObject> predicate = new Predicate<EObject>(){

            public boolean apply(EObject input) {
                return input instanceof Package;
            }
        };
        return this.computeLabel((EObject)element, this.getUmlTypeName((NamedElement)element), (Predicate)predicate);
    }

    public String casePort(Port element) {
        Object predicate = null;
        if (SysmlElementServices.INSTANCE.isFlowPort((Element)element)) {
            predicate = new Predicate<EObject>(){

                public boolean apply(EObject input) {
                    return input instanceof Port && SysmlElementServices.INSTANCE.isFlowPort((Element)((NamedElement)input));
                }
            };
            return this.computeLabel((EObject)element, this.getSysmlTypeName((NamedElement)element), (Predicate)predicate);
        }
        predicate = new Predicate<EObject>(){

            public boolean apply(EObject input) {
                return input instanceof Port;
            }
        };
        return this.computeLabel((EObject)element, this.getUmlTypeName((NamedElement)element), (Predicate)predicate);
    }

    public String caseProperty(Property element) {
        Object predicate = null;
        if (SysmlElementServices.INSTANCE.isConstraintProperty((NamedElement)element)) {
            predicate = new Predicate<EObject>(){

                public boolean apply(EObject input) {
                    return input instanceof Property && SysmlElementServices.INSTANCE.isConstraintProperty((NamedElement)input);
                }
            };
            return this.computeLabel((EObject)element, this.getSysmlTypeName((NamedElement)element), (Predicate)predicate);
        }
        predicate = new Predicate<EObject>(){

            public boolean apply(EObject input) {
                return input instanceof Property;
            }
        };
        return this.computeLabel((EObject)element, this.getUmlTypeName((NamedElement)element), (Predicate)predicate);
    }

    private String computeLabel(EObject element, String name, Predicate predicate) {
        ArrayList existingElements = Lists.newArrayList((Iterable)Iterables.filter((Iterable)element.eContainer().eContents(), (Predicate)predicate));
        return String.valueOf(name) + existingElements.size();
    }

    private String getSysmlTypeName(NamedElement element) {
        if (element != null && element.getStereotypeApplications().size() > 0) {
            return this.getTypeName(element.getStereotypeApplications().get(0));
        }
        return "";
    }

    private String getTypeName(Object element) {
        if (element != null) {
            String name = element.getClass().getSimpleName().toLowerCase();
            return name.substring(0, name.indexOf("impl"));
        }
        return "";
    }

    private String getUmlTypeName(NamedElement element) {
        return this.getTypeName(element);
    }
}

