/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.sysml.design.internal.services;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.sysml.portandflows.FlowDirection;
import org.eclipse.papyrus.sysml.portandflows.FlowPort;
import org.eclipse.uml2.uml.Port;

public class PortServices {
    public static final PortServices INSTANCE = new PortServices();

    private PortServices() {
    }

    private FlowPort getFlowPortApplication(Port port) {
        for (EObject application : port.getStereotypeApplications()) {
            if (!(application instanceof FlowPort)) continue;
            return (FlowPort)application;
        }
        return null;
    }

    public boolean isConnectableWith(Port source, Port target, boolean isOppositeDirection) {
        if (source == target) {
            return false;
        }
        boolean result = false;
        result = source.getType() == null && target.getType() == null ? true : EcoreUtil.equals((EObject)source.getType(), (EObject)target.getType());
        if (result) {
            FlowPort sourcePort = this.getFlowPortApplication(source);
            FlowPort targetPort = this.getFlowPortApplication(target);
            if (sourcePort == null && targetPort == null) {
                return true;
            }
            if (sourcePort != null && targetPort != null) {
                if (isOppositeDirection) {
                    return sourcePort.getDirection() != targetPort.getDirection() || sourcePort.getDirection() == targetPort.getDirection() && sourcePort.getDirection() == FlowDirection.INOUT;
                }
                return sourcePort.getDirection() == targetPort.getDirection();
            }
        }
        return false;
    }

    public boolean isDelegationOf(Port source, Port target) {
        return this.isConnectableWith(source, target, false);
    }

    public boolean isDualWith(Port source, Port target) {
        return this.isConnectableWith(source, target, true);
    }

    public boolean isNotDelegationOf(Port source, Port target) {
        return !this.isDelegationOf(source, target);
    }
}

