/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.sysml.design.internal.services;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.sysml.blocks.Block;
import org.eclipse.papyrus.sysml.blocks.Dimension;
import org.eclipse.papyrus.sysml.constraints.ConstraintBlock;
import org.eclipse.papyrus.sysml.constraints.ConstraintProperty;
import org.eclipse.papyrus.sysml.portandflows.FlowPort;
import org.eclipse.papyrus.sysml.requirements.DeriveReqt;
import org.eclipse.papyrus.sysml.requirements.Requirement;
import org.eclipse.papyrus.sysml.requirements.Satisfy;
import org.eclipse.papyrus.sysml.requirements.TestCase;
import org.eclipse.papyrus.sysml.requirements.Verify;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.profile.standard.Refine;
import org.obeonetwork.dsl.sysml.design.Activator;

public class SysmlElementServices {
    public static final SysmlElementServices INSTANCE = new SysmlElementServices();

    private SysmlElementServices() {
    }

    private void applySysMLProfile(Package p, String profileQualifiedName) {
        if (this.isProfileApplied(p, profileQualifiedName)) {
            return;
        }
        Profile parentProfile = null;
        if (profileQualifiedName.startsWith("SysML")) {
            parentProfile = Activator.getSysMLProfile();
        } else if (profileQualifiedName.startsWith("Standard")) {
            parentProfile = Activator.getStandardProfile();
        }
        Profile profilePackage = parentProfile;
        String[] profiles = profileQualifiedName.split(":{2}");
        int index = 1;
        while (index < profiles.length - 1) {
            profilePackage = profilePackage.getNestedPackage(profiles[index]);
            ++index;
        }
        Profile profile = profilePackage;
        if (profileQualifiedName.startsWith("SysML")) {
            profile = (Profile)profilePackage.getNestedPackage(profiles[profiles.length - 1]);
        }
        if (profile == null) {
            String message = "Can't apply the profile " + profileQualifiedName + " on " + p.getQualifiedName();
            Activator.log(2, message, null);
        } else {
            p.applyProfile(profile);
        }
    }

    public void createAssociatedStereotype(Element e, String profileQualifiedName, String stereotypeName) {
        this.applySysMLProfile((Package)e.getModel(), profileQualifiedName);
        Element element = e;
        String stereotypeQualifiedName = String.valueOf(profileQualifiedName) + "::" + stereotypeName;
        Stereotype stereotype = element.getApplicableStereotype(stereotypeQualifiedName);
        EList appliedStereotypes = element.getAppliedStereotypes();
        if (stereotype == null) {
            String message = "Can't apply the setereotype " + stereotypeQualifiedName + " on " + element.toString();
            Activator.log(2, message, null);
        } else if (appliedStereotypes != null && appliedStereotypes.contains((Object)stereotype)) {
            String message = "The stereotype " + stereotype.getQualifiedName() + " is already applied on " + element.toString();
            Activator.log(1, message, null);
        } else {
            element.applyStereotype(stereotype);
        }
    }

    public void deleteAssociatedStereotype(Element e, String steQualified) {
        Element element = e;
        if (element != null && steQualified != null) {
            Stereotype stereotype = element.getAppliedStereotype(steQualified);
            if (stereotype != null) {
                element.unapplyStereotype(stereotype);
            }
        } else {
            Activator.log(1, "Can't delete the stereotype application because the element or the stereotypeName keys are not correct", null);
        }
    }

    public Requirement getRequirement(Class element) {
        for (EObject stereotype : element.getStereotypeApplications()) {
            if (!(stereotype instanceof Requirement)) continue;
            return (Requirement)stereotype;
        }
        return null;
    }

    public EObject getRootContainer(EObject eObject) {
        return EcoreUtil.getRootContainer((EObject)eObject);
    }

    public boolean isBlock(Element element) {
        return this.isStereotype(element, Block.class);
    }

    public boolean isConstraintBlock(Classifier element) {
        return this.isStereotype((Element)element, ConstraintBlock.class);
    }

    public boolean isConstraintProperty(NamedElement element) {
        return this.isStereotype((Element)element, ConstraintProperty.class);
    }

    public boolean isDeriveReqt(NamedElement element) {
        return this.isStereotype((Element)element, DeriveReqt.class);
    }

    public boolean isDimension(InstanceSpecification element) {
        return this.isStereotype((Element)element, Dimension.class);
    }

    public boolean isFlowPort(Element element) {
        return this.isStereotype(element, FlowPort.class);
    }

    private boolean isProfileApplied(Package currentPackage, String profileQualifiedName) {
        EList allProfiles = currentPackage.getAllAppliedProfiles();
        for (Profile cur : allProfiles) {
            if (!profileQualifiedName.equalsIgnoreCase(cur.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    public boolean isRefine(NamedElement element) {
        return this.isStereotype((Element)element, Refine.class);
    }

    public boolean isRequirement(Element element) {
        return this.isStereotype(element, Requirement.class);
    }

    public boolean isSatisfy(NamedElement element) {
        return this.isStereotype((Element)element, Satisfy.class);
    }

    private boolean isStereotype(Element element, java.lang.Class sysmlStereotype) {
        for (EObject stereotype : element.getStereotypeApplications()) {
            if (!sysmlStereotype.isInstance(stereotype)) continue;
            return true;
        }
        return false;
    }

    public boolean isTestCase(NamedElement element) {
        for (EObject stereotype : element.getStereotypeApplications()) {
            if (!(stereotype instanceof TestCase)) continue;
            return true;
        }
        return false;
    }

    public boolean isVerify(NamedElement element) {
        return this.isStereotype((Element)element, Verify.class);
    }
}

