/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.sysml.design.internal.wizards.newmodel;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelectionCallback;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.swt.widgets.Display;
import org.obeonetwork.dsl.sysml.design.api.utils.SysmlViewpoints;
import org.obeonetwork.dsl.sysml.design.internal.wizards.Messages;
import org.obeonetwork.dsl.uml2.design.api.utils.UmlViewpoints;
import org.obeonetwork.dsl.uml2.design.api.wizards.AbstractUmlProjectWizard;

public class SysMLProjectWizard
extends AbstractUmlProjectWizard {
    private final String SYSML_VP = "SysML";

    public void addPages() {
        super.addPages();
        this.getNewProjectPage().setTitle("Create a SysML Modeling project");
        this.getModelPage().setTitle(Messages.SysMLModelWizard_UI_InitModelPageTitle);
    }

    public boolean performFinish() {
        super.performFinish();
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Option created = ModelingProject.asModelingProject((IProject)SysMLProjectWizard.this.getProject());
                if (created.some()) {
                    ModelingProject modelingProject = (ModelingProject)created.get();
                    SysMLProjectWizard.enableSysMLViewpoints(modelingProject.getSession());
                }
            }
        });
        return true;
    }

    public static void enableSysMLViewpoints(final Session session) {
        if (session != null) {
            session.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(session.getTransactionalEditingDomain()){

                protected void doExecute() {
                    ViewpointSelectionCallback selection = new ViewpointSelectionCallback();
                    for (Viewpoint previouslySelected : session.getSelectedViewpoints(false)) {
                        selection.deselectViewpoint(previouslySelected, session, (IProgressMonitor)new NullProgressMonitor());
                    }
                    selection.selectViewpoint(UmlViewpoints.fromViewpointRegistry().dashboard(), session, (IProgressMonitor)new NullProgressMonitor());
                    selection.selectViewpoint(UmlViewpoints.fromViewpointRegistry().capture(), session, (IProgressMonitor)new NullProgressMonitor());
                    selection.selectViewpoint(SysmlViewpoints.fromViewpointRegistry().sysml(), session, (IProgressMonitor)new NullProgressMonitor());
                }
            });
        }
    }
}

