/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.editor;

import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptParameter;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptSpecification;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptTransformation;
import org.eclipse.mofscript.MOFScriptModel.ParameterDirection;
import org.eclipse.mofscript.editor.MofScriptEditorPlugin;
import org.eclipse.mofscript.parser.MofScriptParseError;
import org.eclipse.mofscript.parser.ParserUtil;
import org.eclipse.mofscript.runtime.ExecutionManager;
import org.eclipse.mofscript.runtime.MofScriptExecutionException;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class ExecutionUtility
implements Runnable {
    private MOFScriptSpecification _currentTransformation;
    private Vector _currentInputFiles = new Vector();
    private String _currentInputDir;
    private String _locationString;
    private volatile IFile _transformationFile;
    private static final String[] _fileFilter = new String[]{"*.*", "*.xml;*.xmi*;*.uml2;*.uml;*.emx;*.mofscript;*.ecore"};
    private boolean _compileSilent = false;

    public MOFScriptSpecification getCurrentTransformation() {
        return this._currentTransformation;
    }

    public String getFirstInputFile() {
        if (this._currentInputFiles.size() > 0) {
            return (String)this._currentInputFiles.firstElement();
        }
        return "";
    }

    public String getCurrentInputDir() {
        return this._currentInputDir;
    }

    public synchronized void updateMarkers(IFile fileResource, Iterator errors) {
        IContainer parentContainer = fileResource.getParent();
        Path targetPath = null;
        try {
            String message = null;
            while (errors.hasNext()) {
                MofScriptParseError error = (MofScriptParseError)errors.next();
                String targetResource = error.targetResource;
                if (targetResource != null) {
                    targetPath = new Path(targetResource);
                    parentContainer.getFile((IPath)targetPath);
                }
                message = error.error;
                if (targetResource != null) {
                    message = String.valueOf(message) + " (... in imported resource: " + targetResource + ")";
                }
                HashMap<String, Object> attrs = new HashMap<String, Object>();
                attrs.put("lineNumber", new Integer(error.line));
                attrs.put("message", message);
                if (error.severity == MofScriptParseError.MOFSCRIPT_INFO) {
                    attrs.put("severity", new Integer(0));
                    MarkerUtilities.createMarker((IResource)fileResource, attrs, (String)"org.eclipse.core.resources.problemmarker");
                    continue;
                }
                if (error.severity == MofScriptParseError.MOFSCRIPT_WARNING) {
                    attrs.put("severity", new Integer(1));
                    MarkerUtilities.createMarker((IResource)fileResource, attrs, (String)"org.eclipse.core.resources.problemmarker");
                    MofScriptEditorPlugin.println("Warning: " + error.toString());
                    continue;
                }
                attrs.put("severity", new Integer(2));
                MarkerUtilities.createMarker((IResource)fileResource, attrs, (String)"org.eclipse.core.resources.problemmarker");
                MofScriptEditorPlugin.println("Error: " + error.toString());
            }
        }
        catch (CoreException coreException) {}
    }

    public synchronized void clearMarkers(IFile ifile) {
        try {
            ifile.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 1);
        }
        catch (CoreException cex) {
            cex.printStackTrace();
        }
    }

    public void setRootDirectoryProperty(IFile file) {
        String rootDir = null;
        try {
            rootDir = file.getPersistentProperty(new QualifiedName("", "OUTPUT_DIR"));
            if (rootDir == null && (rootDir = MofScriptEditorPlugin.getDefault().getPreferenceString("root.directory")) != null) {
                file.setPersistentProperty(new QualifiedName("", "OUTPUT_DIR"), rootDir);
            }
        }
        catch (CoreException coreException) {
            rootDir = MofScriptEditorPlugin.getDefault().getPreferenceString("root.directory");
        }
        if (rootDir != null && !rootDir.equals("")) {
            ExecutionManager.getExecutionManager().setRootDirectory(rootDir);
        }
    }

    public MOFScriptSpecification compile(IFile theFile, String contents, boolean silent) {
        this._compileSilent = silent;
        MOFScriptSpecification mfspec = this.compile(theFile, contents);
        this._compileSilent = false;
        return mfspec;
    }

    public MOFScriptSpecification compile(IFile theFile, String contents) {
        MofScriptEditorPlugin.getDefault().getParserUtil();
        ExecutionManager execMgr = ExecutionManager.getExecutionManager();
        execMgr.clearTransformationModel();
        this._transformationFile = theFile;
        this._currentTransformation = null;
        if (theFile != null) {
            int errorCount;
            MOFScriptSpecification spec;
            String includePath = MofScriptEditorPlugin.getDefault().getPreferenceString("import.directory.path");
            String repository = MofScriptEditorPlugin.getDefault().getPreferenceString("repository.metamodels.path");
            if (!this._compileSilent) {
                MofScriptEditorPlugin.println("\n## Compiling '" + theFile.getName() + "' (Using repository path: " + repository + ")");
            }
            IContainer cc = theFile.getParent();
            IPath pp = cc.getLocation();
            this._locationString = String.valueOf(pp.toOSString()) + "/";
            ParserUtil parser = MofScriptEditorPlugin.getDefault().getParserUtil();
            parser.setMetaModelRepositoryURI(repository);
            parser.setInputFileLocation(this._locationString);
            parser.setCompilePath(includePath);
            this._currentTransformation = contents != null ? (spec = parser.parse(contents, true, theFile.getName(), this._compileSilent)) : (spec = parser.parse(new File(theFile.getLocation().toOSString()), true));
            if (!this._compileSilent) {
                MofScriptEditorPlugin.println("## Finished Compiling.");
            }
            if ((errorCount = ParserUtil.getModelChecker().getErrorCount()) == 0 && !this._compileSilent) {
                MofScriptEditorPlugin.println("## No errors");
            } else if (!this._compileSilent) {
                MofScriptEditorPlugin.println("## " + errorCount + " Errors reported");
            }
            this.clearMarkers(theFile);
            this.updateMarkers(theFile, ParserUtil.getModelChecker().getErrors());
        }
        return this._currentTransformation;
    }

    public void execute(IFile file, String type, boolean showOpenDialog) {
        ParserUtil.getModelChecker().getErrorCount();
        Iterator errorIt = ParserUtil.getModelChecker().getErrors();
        String useTraceability = MofScriptEditorPlugin.getDefault().getPreferenceString("use.traceability");
        boolean useTr = new Boolean(useTraceability);
        ExecutionManager.getExecutionManager().setUseTraceability(useTr);
        String traceModelDir = MofScriptEditorPlugin.getDefault().getPreferenceString("root.directory");
        ExecutionManager.getExecutionManager().setTraceabilityGenDir(traceModelDir);
        String blockCommentTag = MofScriptEditorPlugin.getDefault().getPreferenceString("//");
        ExecutionManager.getExecutionManager().setBlockCommentTag(blockCommentTag);
        String useTramde = MofScriptEditorPlugin.getDefault().getPreferenceString("use.tramde");
        boolean useTramdeE = new Boolean(useTramde);
        ExecutionManager.getExecutionManager().setUseTramde(useTramdeE);
        String useCoarseTramde = MofScriptEditorPlugin.getDefault().getPreferenceString("use.tramde");
        boolean useCoarseTramdeE = new Boolean(useCoarseTramde);
        ExecutionManager.getExecutionManager().setUseCoarseTramde(useCoarseTramdeE);
        boolean hasNoErrors = true;
        if (ParserUtil.getModelChecker().getErrorCount() > 0) {
            MofScriptParseError err = null;
            while (errorIt.hasNext()) {
                err = (MofScriptParseError)errorIt.next();
                if (err.severity != MofScriptParseError.MOFSCRIPT_ERROR) continue;
                hasNoErrors = false;
                break;
            }
        }
        if (!hasNoErrors) {
            MessageDialog.openInformation((Shell)MofScriptEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"MOFScript...", (String)"There are still error in the MOFScript Specification. Execution cancelled.");
        } else {
            if (showOpenDialog) {
                boolean fileOpennedOk = false;
                if (type.equalsIgnoreCase("executePrevious") && this._currentInputFiles.size() > 0) {
                    this.setTransformationSources(this._currentInputFiles);
                    fileOpennedOk = true;
                } else {
                    fileOpennedOk = this.openSourceModelFile("Open Source Model", _fileFilter, (List)ExecutionManager.getExecutionManager().getTransformationProxy().getTransformation().getParameters());
                }
                if (!fileOpennedOk) {
                    MofScriptEditorPlugin.println("\t No file given for transformation.");
                    this._currentInputFiles.clear();
                    return;
                }
            }
            this.performExecution(file, type);
        }
    }

    private void performExecution(IFile transformationFile, String type) {
        ExecutionManager.getExecutionManager();
        try {
            String useLog = transformationFile.getPersistentProperty(new QualifiedName("", "LOG"));
            Boolean log = Boolean.FALSE;
            if (useLog != null) {
                log = new Boolean(useLog);
            }
            ExecutionManager.getExecutionManager().setUseLog(log.booleanValue());
        }
        catch (CoreException coreException) {}
        MofScriptEditorPlugin.println("## Executing MOFScript Specification");
        this.setRootDirectoryProperty(transformationFile);
        try {
            this.setExecutionResourceProperties(transformationFile);
            Thread executionThread = new Thread((Runnable)this, "Execute");
            executionThread.start();
        }
        catch (Exception qex) {
            MofScriptEditorPlugin.println("\n\t Execution Error: " + qex);
        }
    }

    private void setTransformationSources(Vector files) {
        File modelfile = null;
        Iterator it = files.iterator();
        while (it.hasNext()) {
            modelfile = new File((String)it.next());
            ExecutionManager execMgr = ExecutionManager.getExecutionManager();
            execMgr.loadSourceModel(modelfile);
        }
    }

    public boolean openSourceModelFile(String title, String[] filter, List parameters) {
        try {
            FileDialog fileDialog = MofScriptEditorPlugin.getDefault().getFileDialog();
            fileDialog.setText(title);
            fileDialog.setFilterExtensions(filter);
            String modelRep = MofScriptEditorPlugin.getDefault().getPreferenceString("repository.models.path");
            if (this._currentInputDir != null) {
                fileDialog.setFilterPath(this._currentInputDir);
            } else {
                fileDialog.setFilterPath(modelRep);
            }
            this._currentInputFiles.clear();
            int fileOpennedCount = 0;
            MOFScriptParameter parameter2 = null;
            int paramNumber = 1;
            for (MOFScriptParameter parameter2 : parameters) {
                if (parameter2.getDirection() != ParameterDirection.IN_LITERAL) continue;
                fileDialog.setText(String.valueOf(title) + " - Model #" + paramNumber++ + ": " + parameter2.getName());
                String name = fileDialog.open();
                MofScriptEditorPlugin.println("## Open File: " + name + " for input model:" + parameter2.getName());
                if (name == null) continue;
                ++fileOpennedCount;
                this._currentInputDir = fileDialog.getFilterPath();
                this._currentInputFiles.add(name);
            }
            this.setTransformationSources(this._currentInputFiles);
            return fileOpennedCount == paramNumber - 1;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    protected void threadExecute() {
        try {
            ExecutionManager execMgr = ExecutionManager.getExecutionManager();
            execMgr.executeTransformation();
            this.handleResources();
        }
        catch (MofScriptExecutionException mttex) {
            MofScriptEditorPlugin.println("\n\t Execution Error: " + (Object)((Object)mttex));
        }
    }

    protected void setExecutionResourceProperties(IFile file) {
        System.out.println("setting execution resource properties" + file.toString());
        try {
            Date d = new Date();
            file.setPersistentProperty(new QualifiedName("", "EXECUTED_DATE"), d.toString());
            if (this._currentInputFiles.size() > 0) {
                String inputFiles = "";
                Iterator it = this._currentInputFiles.iterator();
                while (it.hasNext()) {
                    inputFiles = inputFiles.concat(String.valueOf((String)it.next()) + ";");
                }
                file.setPersistentProperty(new QualifiedName("", "INPUT_SOURCE"), inputFiles);
            }
        }
        catch (CoreException coreException) {}
    }

    private void handleResources() {
        ExecutionManager execMgr = ExecutionManager.getExecutionManager();
        Vector resources = execMgr.getProducedResources();
        new ResourceFactoryImpl();
        new ResourceSetImpl();
        String resourceKey2 = null;
        URI fileUri = null;
        if (resources.size() == 0) {
            return;
        }
        String genProjectPrefix = MofScriptEditorPlugin.getDefault().getPreferenceString("gen.project.prefix");
        boolean genToProject = MofScriptEditorPlugin.getDefault().getPreferenceStore().getBoolean("gen.to.project");
        if (!genToProject) {
            return;
        }
        if (genProjectPrefix == null || genProjectPrefix.equals("")) {
            genProjectPrefix = "mofscript-gen-";
        }
        if (this._transformationFile == null) {
            return;
        }
        IContainer container = this._transformationFile.getParent();
        IPath ipath = container.getFullPath();
        ipath.toString();
        IProject project = this._transformationFile.getProject();
        project.getName();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot wroot = workspace.getRoot();
        IProject genProject = wroot.getProject(String.valueOf(genProjectPrefix) + this._transformationFile.getName());
        if (!genProject.exists()) {
            try {
                genProject.create(null);
            }
            catch (CoreException coreException) {}
        }
        if (!genProject.exists()) {
            genProject = project;
        }
        if (genProject.exists() && !genProject.isOpen()) {
            try {
                genProject.open(null);
            }
            catch (CoreException cex) {
                cex.printStackTrace();
            }
        }
        if (genProject.exists()) {
            MofScriptEditorPlugin.println("## Generating file links in '" + genProject.getName() + "' project.");
        }
        for (String resourceKey2 : resources) {
            fileUri = URI.createFileURI((String)resourceKey2);
            fileUri.fileExtension();
            String fileLastSegment = fileUri.lastSegment();
            fileUri.toFileString();
            if (!genProject.exists()) continue;
            Path filePath = new Path(fileUri.toFileString());
            IFile newFile = genProject.getFile(fileLastSegment);
            try {
                if (newFile.exists()) continue;
                newFile.createLink((IPath)filePath, 1, null);
            }
            catch (CoreException cex) {
                MofScriptEditorPlugin.println(cex.toString());
            }
        }
    }

    public void executeModelDirect(IFile transformationFile) {
        try {
            ResourceSetImpl rSet = new ResourceSetImpl();
            URI fileUri = URI.createFileURI((String)transformationFile.getLocation().toOSString());
            Resource res = rSet.getResource(fileUri, true);
            MOFScriptSpecification trSpec = (MOFScriptSpecification)res.getContents().get(0);
            MOFScriptTransformation transformation = (MOFScriptTransformation)trSpec.getTransformation().get(0);
            ExecutionManager.getExecutionManager().setTransformationModel(transformation);
            this.executeModelDirect(transformation, _fileFilter);
        }
        catch (Exception ex) {
            MofScriptEditorPlugin.println("## Error executing model:" + ex);
        }
    }

    protected void executeModelDirect(MOFScriptTransformation transformation, String[] fileFilter) throws Exception {
        if (transformation != null) {
            this.openSourceModelFile("Open source model", fileFilter, (List)transformation.getParameters());
            Thread executionThread = new Thread((Runnable)this, "Execute");
            executionThread.start();
        }
    }

    public void executeMOFScript2Text(IFile mofscriptModelFile) {
        try {
            ExecutionManager execMgr = ExecutionManager.getExecutionManager();
            MOFScriptTransformation theTransformation = execMgr.getMofScript2TextTransformation();
            String fullPath = null;
            IContainer parent = mofscriptModelFile.getParent();
            IPath parentLoc = parent.getRawLocation();
            parent.getFullPath();
            if (parentLoc != null) {
                fullPath = parentLoc.toOSString();
            } else {
                IPath location = parent.getLocation();
                fullPath = location.toOSString();
            }
            String originalName = mofscriptModelFile.getName();
            System.setProperty("MOFSCRIPT2TEXT_FILE", originalName);
            execMgr.setTransformationModel(theTransformation);
            execMgr.setRootDirectory(fullPath);
            String inputFile = mofscriptModelFile.getRawLocation().toOSString();
            execMgr.loadSourceModel(new File(inputFile));
            Thread executionThread = new Thread((Runnable)this, "Execute");
            executionThread.start();
        }
        catch (Exception ex) {
            MofScriptEditorPlugin.println("## Error executing model: " + ex);
        }
    }

    protected void mofScriptTextToModel(IFile transformationFile, String content, MOFScriptSpecification transformationSpec) {
        MOFScriptTransformation transformation = null;
        if (transformationSpec != null && transformationSpec.getTransformation().size() > 0) {
            transformation = (MOFScriptTransformation)transformationSpec.getTransformation().get(0);
        }
        EList parameters = transformation.getParameters();
        String fileToOpen = null;
        MOFScriptParameter param2 = null;
        for (MOFScriptParameter param2 : parameters) {
            fileToOpen = this.openSimpleFileDialog("Open MOFScript Transformation File => " + param2.getName(), new String[]{"*.m2t; *.mofscript"});
            if (fileToOpen.endsWith(".m2t")) {
                MOFScriptSpecification inputTransformation = null;
                ParserUtil parser = MofScriptEditorPlugin.getDefault().getParserUtil();
                try {
                    inputTransformation = parser.parse(new File(fileToOpen), true);
                    this.compile(transformationFile, content);
                    ExecutionManager execMgr = ExecutionManager.getExecutionManager();
                    execMgr.addSourceModel((EObject)inputTransformation);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                continue;
            }
            File modelfile = new File(fileToOpen);
            ExecutionManager.getExecutionManager().loadSourceModel(modelfile);
        }
        this.execute(transformationFile, "model2text", false);
    }

    protected void aspectTransformation(IFile transformationFile, String content, MOFScriptSpecification transformationSpec) {
        MOFScriptSpecification theAspect = null;
        theAspect = transformationSpec;
        ExecutionManager execMgr = ExecutionManager.getExecutionManager();
        MOFScriptTransformation aspectTransformation = execMgr.getMofScriptAspectTransformation();
        String fileToOpen = this.openSimpleFileDialog("Open MOFScript for applying aspect.", new String[]{"*.m2t; *.mofscript"});
        if (fileToOpen.endsWith(".m2t")) {
            MOFScriptSpecification inputTransformation = null;
            ParserUtil parser = MofScriptEditorPlugin.getDefault().getParserUtil();
            try {
                inputTransformation = parser.parse(new File(fileToOpen), true);
                execMgr.lookupAndAddSourceMetaModelsFromParameterList((List)aspectTransformation.getParameters());
                execMgr.setTransformationModel(aspectTransformation);
                execMgr.addSourceModel((EObject)inputTransformation);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            File modelfile = new File(fileToOpen);
            execMgr.loadSourceModel(modelfile);
        }
        File fileDir = new File(fileToOpen);
        String theDir = fileDir.getParentFile().getAbsolutePath();
        System.setProperty("MOSCRIPTASPECT_DIR", theDir);
        execMgr.addSourceModel((EObject)theAspect);
        Thread executionThread = new Thread((Runnable)this, "Execute");
        executionThread.start();
    }

    public void storeMofScriptModel(MOFScriptSpecification transformation, IFile transformationFile) {
        if (transformationFile != null) {
            IContainer parent = transformationFile.getParent();
            IProject project = transformationFile.getProject();
            project.getName();
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            workspace.getRoot();
            URI fileUri = URI.createFileURI((String)(String.valueOf(parent.getLocation().toOSString()) + "/" + transformationFile.getName() + ".model.mofscript"));
            if (transformation != null) {
                try {
                    ResourceSetImpl rSet = new ResourceSetImpl();
                    rSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
                    XMIResource res = (XMIResource)rSet.createResource(fileUri);
                    res.getContents().add((Object)transformation);
                    res.setEncoding("UTF-8");
                    res.save(Collections.EMPTY_MAP);
                    MofScriptEditorPlugin.println("## Stored model resource: '" + res.getURI().toFileString() + "'");
                    parent.refreshLocal(1, null);
                }
                catch (CoreException coreException) {
                }
                catch (Exception ex) {
                    MofScriptEditorPlugin.println("## Could not store model: " + ex);
                }
            }
        }
    }

    protected String openSimpleFileDialog(String title, String[] filter) {
        try {
            FileDialog fileDialog = MofScriptEditorPlugin.getDefault().getFileDialog();
            fileDialog.setText(title);
            fileDialog.setFilterExtensions(filter);
            String modelRep = MofScriptEditorPlugin.getDefault().getPreferenceString("repository.models.path");
            if (this._currentInputDir != null) {
                fileDialog.setFilterPath(this._currentInputDir);
            } else {
                fileDialog.setFilterPath(modelRep);
            }
            this._currentInputFiles.clear();
            String name = fileDialog.open();
            this._currentInputDir = fileDialog.getFilterPath();
            return name;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void run() {
        Thread t = Thread.currentThread();
        String name = t.getName();
        if (!name.equalsIgnoreCase("Compile") && name.equals("Execute")) {
            this.threadExecute();
        }
    }
}

