/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.editor;

import java.util.Stack;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.mofscript.editor.MofScriptConfiguration;
import org.eclipse.mofscript.editor.MofScriptEditorMessages;

public class MofScriptAutoIndentStrategy
implements IAutoEditStrategy {
    private static int BRACKET_TYPE_CURLY = 1;
    private static int BRACKET_TYPE_NORMAL = 2;
    private MofScriptConfiguration _configuration = null;

    public MofScriptAutoIndentStrategy(MofScriptConfiguration configuration) {
        this._configuration = configuration;
    }

    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        if (c.length == 0 && c.text != null && this.endsWithDelimiter(d, c.text)) {
            this.smartIndentAfterNewLine(d, c);
        } else if ("}".equals(c.text)) {
            this.smartInsertAfterBracket(d, c, BRACKET_TYPE_CURLY);
        } else if (")".equals(c.text)) {
            this.smartInsertAfterBracket(d, c, BRACKET_TYPE_NORMAL);
        } else {
            "*".equals(c.text);
        }
    }

    private boolean endsWithDelimiter(IDocument d, String txt) {
        String[] delimiters = d.getLegalLineDelimiters();
        if (delimiters != null) {
            return TextUtilities.endsWith((String[])delimiters, (String)txt) > -1;
        }
        return false;
    }

    protected int findMatchingOpenBracket(IDocument document, int line, int end, int closingBracketIncrease, int bracketType) throws BadLocationException {
        int start = document.getLineOffset(line);
        int[] brackcountAndLocation = this.getBracketCount(document, start, end, false, bracketType);
        int brackcount = brackcountAndLocation[0] - closingBracketIncrease;
        while (brackcount < 0) {
            if (--line < 0) {
                return -1;
            }
            start = document.getLineOffset(line);
            end = start + document.getLineLength(line) - 1;
            brackcountAndLocation = this.getBracketCount(document, start, end, false, bracketType);
            brackcount += brackcountAndLocation[0];
        }
        return line;
    }

    private int[] getBracketCount(IDocument document, int start, int end, boolean ignoreCloseBrackets, int bracketType) throws BadLocationException {
        int[] bracketCountAndLocation = new int[2];
        Stack<Integer> bracketStack = new Stack<Integer>();
        int begin = start;
        int bracketcount = 0;
        block11: while (begin < end) {
            char curr = document.getChar(begin);
            bracketCountAndLocation[1] = begin++;
            switch (curr) {
                case '/': {
                    if (begin >= end) break;
                    char next = document.getChar(begin);
                    if (next == '*') {
                        begin = this.getCommentEnd(document, begin + 1, end);
                        break;
                    }
                    if (next != '/') break;
                    begin = end;
                    break;
                }
                case '<': {
                    char next;
                    if (begin < end && (next = document.getChar(begin)) == '%') {
                        begin = this.getEscapeEnd(document, begin + 1, end);
                    }
                }
                case '*': {
                    char next;
                    if (begin >= end || (next = document.getChar(begin)) != '/') continue block11;
                    bracketcount = 0;
                    ++begin;
                    break;
                }
                case '%': {
                    char next;
                    if (begin < end && (next = document.getChar(begin)) == '>') {
                        bracketcount = 0;
                        ++begin;
                    }
                }
                case '{': {
                    if (bracketType != BRACKET_TYPE_CURLY) break;
                    ++bracketcount;
                    ignoreCloseBrackets = false;
                    bracketStack.push(new Integer(bracketCountAndLocation[1]));
                    break;
                }
                case '}': {
                    if (bracketType != BRACKET_TYPE_CURLY || ignoreCloseBrackets) continue block11;
                    --bracketcount;
                    if (bracketStack.size() <= 0) break;
                    bracketStack.pop();
                    break;
                }
                case '(': {
                    if (bracketType != BRACKET_TYPE_NORMAL) break;
                    ++bracketcount;
                    ignoreCloseBrackets = false;
                    bracketStack.push(new Integer(bracketCountAndLocation[1]));
                    break;
                }
                case ')': {
                    if (bracketType != BRACKET_TYPE_NORMAL || ignoreCloseBrackets) continue block11;
                    --bracketcount;
                    if (bracketStack.size() <= 0) break;
                    bracketStack.pop();
                    break;
                }
                case '\"': 
                case '\'': {
                    begin = this.getStringEnd(document, begin, end, curr);
                }
            }
        }
        if (bracketStack.size() > 0) {
            Integer location = (Integer)bracketStack.pop();
            bracketCountAndLocation[1] = location;
        }
        bracketCountAndLocation[0] = bracketcount;
        return bracketCountAndLocation;
    }

    private int getCommentEnd(IDocument document, int position, int end) throws BadLocationException {
        int currentPosition = position;
        while (currentPosition < end) {
            char curr = document.getChar(currentPosition);
            if (curr != '*' || ++currentPosition >= end || document.getChar(currentPosition) != '/') continue;
            return currentPosition + 1;
        }
        return end;
    }

    private int getEscapeEnd(IDocument document, int position, int end) throws BadLocationException {
        int currentPosition = position;
        while (currentPosition < end) {
            char curr = document.getChar(currentPosition);
            if (curr != '%' || ++currentPosition >= end || document.getChar(currentPosition) != '>') continue;
            return currentPosition + 1;
        }
        return end;
    }

    protected String getIndentOfLine(IDocument document, int line) throws BadLocationException {
        if (line > -1) {
            int start = document.getLineOffset(line);
            int end = start + document.getLineLength(line) - 1;
            int whiteend = this.findEndOfWhiteSpace(document, start, end);
            return document.get(start, whiteend - start);
        }
        return "";
    }

    private int getStringEnd(IDocument document, int position, int end, char character) throws BadLocationException {
        int currentPosition = position;
        while (currentPosition < end) {
            char currentCharacter = document.getChar(currentPosition);
            ++currentPosition;
            if (currentCharacter == '\\') {
                ++currentPosition;
                continue;
            }
            if (currentCharacter != character) continue;
            return currentPosition;
        }
        return end;
    }

    protected void smartIndentAfterNewLine(IDocument document, DocumentCommand command) {
        int docLength = document.getLength();
        if (command.offset == -1 || docLength == 0) {
            return;
        }
        int prev = 32;
        try {
            prev = document.getChar(command.offset - 1);
            if (prev == 42) {
                this.checkInsertAfterComment(document, command);
                return;
            }
        }
        catch (Exception exception) {}
        try {
            int p = command.offset == docLength ? command.offset - 1 : command.offset;
            int line = document.getLineOfOffset(p);
            StringBuffer buf = new StringBuffer(command.text);
            if (command.offset < docLength && document.getChar(command.offset) == '}') {
                int indLine = this.findMatchingOpenBracket(document, line, command.offset, 0, BRACKET_TYPE_CURLY);
                if (indLine == -1) {
                    indLine = line;
                }
                buf.append(this.getIndentOfLine(document, indLine));
            } else {
                int start = document.getLineOffset(line);
                int whiteend = this.findEndOfWhiteSpace(document, start, command.offset);
                buf.append(document.get(start, whiteend - start));
                int[] brackcountAndLocation = this.getBracketCount(document, start, command.offset, true, BRACKET_TYPE_CURLY);
                if (brackcountAndLocation[0] > 0) {
                    buf.append("  ");
                }
            }
            command.text = buf.toString();
        }
        catch (BadLocationException badLocationException) {
            System.out.println(MofScriptEditorMessages.getString("AutoIndent.error.bad_location_1"));
        }
    }

    protected void smartInsertAfterBracket(IDocument document, DocumentCommand command, int bracketType) {
        if (command.offset == -1 || document.getLength() == 0) {
            return;
        }
        try {
            int p = command.offset == document.getLength() ? command.offset - 1 : command.offset;
            int line = document.getLineOfOffset(p);
            int start = document.getLineOffset(line);
            int whiteend = this.findEndOfWhiteSpace(document, start, command.offset);
            int indLine = this.findMatchingOpenBracket(document, line, command.offset, 1, bracketType);
            if (whiteend == command.offset && indLine != -1 && indLine != line) {
                StringBuffer replaceText = new StringBuffer(this.getIndentOfLine(document, indLine));
                replaceText.append(document.get(whiteend, command.offset - whiteend));
                replaceText.append(command.text);
                command.length = command.offset - start;
                command.offset = start;
                command.text = replaceText.toString();
            }
        }
        catch (BadLocationException badLocationException) {
            System.out.println(MofScriptEditorMessages.getString("AutoIndent.error.bad_location_2"));
        }
    }

    private void checkInsertAfterComment(IDocument document, DocumentCommand command) {
        StringBuffer buf = new StringBuffer();
        String whitespace = "";
        int prev2 = 32;
        int prev3 = 32;
        try {
            prev2 = document.getChar(command.offset - 2);
            prev3 = document.getChar(command.offset - 3);
        }
        catch (Exception exception) {}
        if (prev2 == 42 && prev3 == 47 || prev2 == 47) {
            int whiteLookStart = prev2 == 47 ? command.offset - 3 : command.offset - 4;
            try {
                while (document.getChar(whiteLookStart--) == ' ') {
                    whitespace = String.valueOf(whitespace) + " ";
                }
            }
            catch (Exception exception) {}
            buf.append("\n" + whitespace + " *\n");
            buf.append(String.valueOf(whitespace) + " */");
            command.text = buf.toString();
        }
    }

    protected int findEndOfWhiteSpace(IDocument document, int offset, int end) throws BadLocationException {
        while (offset < end) {
            char c = document.getChar(offset);
            if (c != ' ' && c != '\t') {
                return offset;
            }
            ++offset;
        }
        return end;
    }
}

