/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.editor;

import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.mofscript.editor.ColorManager;
import org.eclipse.mofscript.editor.MofScriptAutoIndentStrategy;
import org.eclipse.mofscript.editor.MofScriptDoubleClickStrategy;
import org.eclipse.mofscript.editor.MofScriptEditorFactory;
import org.eclipse.mofscript.editor.MofScriptEditorPlugin;
import org.eclipse.mofscript.editor.MofScriptScanner;
import org.eclipse.mofscript.editor.MofScriptTextEditor;
import org.eclipse.mofscript.editor.MofScriptTextHover;
import org.eclipse.mofscript.editor.hyperlink.MofScriptLinkDetector;
import org.eclipse.swt.graphics.RGB;

public class MofScriptConfiguration
extends SourceViewerConfiguration {
    private MofScriptDoubleClickStrategy _doubleClickStrategy = null;
    private MofScriptScanner _scanner = null;
    private ColorManager _colorManager = null;
    private MofScriptTextEditor _editor = null;

    public MofScriptConfiguration(ColorManager colorManager, MofScriptTextEditor editor) {
        this._colorManager = colorManager;
        this._editor = editor;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__mofscript_javadoc", "__mofscript__multiline_comment", "__mofscript_comment", "__mofscript__multiline_escape", "__mofscript_literal", "__mofscript_single_literal"};
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"\t", "    "};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this._doubleClickStrategy == null) {
            this._doubleClickStrategy = new MofScriptDoubleClickStrategy();
        }
        return this._doubleClickStrategy;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)MofScriptEditorPlugin.getDefault().getCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)new SingleTokenScanner(new TextAttribute(this._colorManager.getColor(ColorManager.SINGLE_LINE_COMMENT), null, 2)));
        reconciler.setDamager((IPresentationDamager)dr, "__mofscript_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__mofscript_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)new SingleTokenScanner(new TextAttribute(this._colorManager.getColor(ColorManager.MULTI_LINE_COMMENT), null, 2)));
        reconciler.setDamager((IPresentationDamager)dr, "__mofscript_javadoc");
        reconciler.setRepairer((IPresentationRepairer)dr, "__mofscript_javadoc");
        dr = new DefaultDamagerRepairer((ITokenScanner)new SingleTokenScanner(new TextAttribute(this._colorManager.getColor(ColorManager.MULTI_LINE_COMMENT), null, 2)));
        reconciler.setDamager((IPresentationDamager)dr, "__mofscript__multiline_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__mofscript__multiline_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)new SingleTokenScanner(new TextAttribute(this._colorManager.getColor(ColorManager.MULTI_LINE_ESCAPE))));
        reconciler.setDamager((IPresentationDamager)dr, "__mofscript__multiline_escape");
        reconciler.setRepairer((IPresentationRepairer)dr, "__mofscript__multiline_escape");
        dr = new DefaultDamagerRepairer((ITokenScanner)new SingleTokenScanner(new TextAttribute(this._colorManager.getColor(ColorManager.STRING))));
        reconciler.setDamager((IPresentationDamager)dr, "__mofscript_literal");
        reconciler.setRepairer((IPresentationRepairer)dr, "__mofscript_literal");
        dr = new DefaultDamagerRepairer((ITokenScanner)new SingleTokenScanner(new TextAttribute(this._colorManager.getColor(ColorManager.STRING))));
        reconciler.setDamager((IPresentationDamager)dr, "__mofscript_single_literal");
        reconciler.setRepairer((IPresentationRepairer)dr, "__mofscript_single_literal");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        IContentAssistProcessor contentAssist = MofScriptEditorFactory.createContentAssist(this._editor);
        assistant.setContentAssistProcessor(contentAssist, "__dftl_partition_content_type");
        assistant.enablePrefixCompletion(true);
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(200);
        assistant.setProposalPopupOrientation(10);
        assistant.setProposalSelectorBackground(MofScriptEditorPlugin.getDefault().getColorManager().getColor(new RGB(255, 255, 255)));
        assistant.setProposalSelectorForeground(MofScriptEditorPlugin.getDefault().getColorManager().getColor(new RGB(0, 0, 0)));
        assistant.setContextInformationPopupOrientation(20);
        return assistant;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        IAutoEditStrategy[] strategies = new IAutoEditStrategy[]{new MofScriptAutoIndentStrategy(this)};
        return strategies;
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        String width = MofScriptEditorPlugin.getResourceString("editor.tabWidth");
        try {
            return Integer.parseInt(width);
        }
        catch (Exception exception) {
            return 4;
        }
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new MofScriptTextHover();
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        return new IHyperlinkDetector[]{new MofScriptLinkDetector(this._editor)};
    }

    static class SingleTokenScanner
    extends BufferedRuleBasedScanner {
        public SingleTokenScanner(TextAttribute attribute) {
            this.setDefaultReturnToken((IToken)new Token((Object)attribute));
        }
    }
}

