/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.editor;

import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mofscript.editor.MofScriptEditorMessages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class MofScriptContentOutlinePage
extends ContentOutlinePage {
    protected Object fInput;
    protected IDocumentProvider fDocumentProvider;
    protected ITextEditor fTextEditor;
    protected static Image moduleImage = null;
    protected static Image ruleImage = null;
    protected static Image propertyImage = null;
    protected static Image defaultImage = null;
    protected Segment previousSegment = null;

    public MofScriptContentOutlinePage(IDocumentProvider provider, ITextEditor editor) {
        this.fDocumentProvider = provider;
        this.fTextEditor = editor;
        if (moduleImage == null) {
            InputStream stream = null;
            stream = ((Object)((Object)this)).getClass().getResourceAsStream("img/module.gif");
            moduleImage = new Image(null, stream);
            stream = ((Object)((Object)this)).getClass().getResourceAsStream("img/rule.gif");
            ruleImage = new Image(null, stream);
            stream = ((Object)((Object)this)).getClass().getResourceAsStream("img/property.gif");
            propertyImage = new Image(null, stream);
            stream = ((Object)((Object)this)).getClass().getResourceAsStream("img/default.gif");
            defaultImage = new Image(null, stream);
        }
    }

    public void setInput(Object input) {
        this.fInput = input;
        this.update();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new MofScriptContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new MofScriptLabelProvider());
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.fInput != null) {
            viewer.setInput(this.fInput);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        ISelection selection = event.getSelection();
        if (selection.isEmpty()) {
            this.fTextEditor.resetHighlightRange();
        } else {
            Segment segment;
            Object selected = ((IStructuredSelection)selection).getFirstElement();
            if (selected instanceof Segment && (segment = (Segment)((IStructuredSelection)selection).getFirstElement()) != null && segment.position != null) {
                int start = segment.position.getOffset();
                int length = segment.position.getLength();
                try {
                    this.fTextEditor.setHighlightRange(start, length, true);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.fTextEditor.resetHighlightRange();
                }
            }
        }
    }

    public void update() {
        Control control;
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null && (control = viewer.getControl()) != null && !control.isDisposed()) {
            control.setRedraw(false);
            viewer.setInput(this.fInput);
            viewer.expandAll();
            control.setRedraw(true);
        }
    }

    protected static class DeclarationSegment
    extends Segment {
        public List variables = new ArrayList(){

            @Override
            public String toString() {
                return "Properties";
            }

            @Override
            public boolean add(Object property) {
                if (property instanceof PropertySegment) {
                    ((PropertySegment)property).owner = DeclarationSegment.this;
                }
                return super.add(property);
            }
        };

        public DeclarationSegment() {
        }

        public DeclarationSegment(String name, Position position) {
            super(name, position);
        }

        @Override
        public void clear() {
            super.clear();
            this.variables.clear();
        }

        public Object[] getChildren() {
            Object[] children = new Object[]{this.variables};
            return children;
        }

        public boolean hasChildren() {
            return this.variables.size() > 0;
        }
    }

    protected static class ModuleSegment
    extends DeclarationSegment {
        public List imports = new ArrayList(){

            @Override
            public String toString() {
                return "Imports";
            }
        };
        public List rules = new ArrayList(){

            @Override
            public String toString() {
                return "Rules";
            }
        };

        public ModuleSegment() {
            this.name = "No module";
        }

        public ModuleSegment(String name, Position position) {
            super(name, position);
        }

        @Override
        public void clear() {
            super.clear();
            this.imports.clear();
            this.rules.clear();
        }

        public Object[] toArray() {
            Object[] elements = new Object[]{this};
            return elements;
        }

        @Override
        public Object[] getChildren() {
            Object[] children = new Object[]{this.variables, this.imports, this.rules};
            return children;
        }
    }

    protected class MofScriptContentProvider
    implements ITreeContentProvider {
        protected static final String SEGMENTS = "__mofscript_segments";
        protected IPositionUpdater fPositionUpdater = new DefaultPositionUpdater("__mofscript_segments");
        protected ModuleSegment fContent = new ModuleSegment();

        protected MofScriptContentProvider() {
        }

        private Segment getDeclaration(String line, int line_no, Position p) {
            Segment segment;
            block16: {
                segment = null;
                try {
                    boolean matches;
                    int index1 = line.indexOf("textmodule");
                    if (index1 == -1) {
                        index1 = line.indexOf("texttransformation");
                    }
                    int index2 = 0;
                    if (index1 > -1 && this.fContent.name.length() == 0) {
                        index1 = line.indexOf(" ", index1);
                        index2 = line.indexOf("(", index1);
                        try {
                            this.fContent.name = line.substring(index1 + 1, index2);
                        }
                        catch (Exception exception) {
                            this.fContent.name = line;
                        }
                        this.fContent.position = p;
                        break block16;
                    }
                    if (line.toLowerCase().startsWith("property")) {
                        index1 = line.toLowerCase().indexOf("property");
                        index2 = line.toLowerCase().indexOf("=");
                        String propName = "";
                        propName = index1 > -1 && index2 > -1 ? line.substring(index1 + 8, index2).trim() : line;
                        segment = new PropertySegment(MessageFormat.format(MofScriptEditorMessages.getString("OutlinePage.segment.title_pattern"), propName, new Integer(line_no)), p);
                        break block16;
                    }
                    if (line.toLowerCase().startsWith("var")) {
                        String propName = "";
                        try {
                            index2 = line.indexOf(59);
                            propName = index2 > 0 ? line.substring(3, index2) : line;
                        }
                        catch (Exception exception) {
                            propName = line;
                        }
                        segment = new PropertySegment(MessageFormat.format(MofScriptEditorMessages.getString("OutlinePage.segment.title_pattern"), propName, new Integer(line_no)), p);
                        break block16;
                    }
                    String[] split = null;
                    String name = "";
                    String context = "";
                    boolean bl = matches = line.matches("\\w*\\.\\w*::\\w* *\\([^)]*\\).*") || line.matches("module::\\w* *\\([^)]*\\).*");
                    if (matches) {
                        split = line.split("[:\\(\\)\\{ ]");
                        if (split.length == 0) {
                            name = line;
                        } else if (split.length == 1) {
                            name = split[0];
                        } else if (split.length >= 3) {
                            name = split[2];
                            context = split[0];
                        }
                        segment = new RuleSegment(MessageFormat.format(MofScriptEditorMessages.getString("OutlinePage.segment.title_pattern"), name, context, new Integer(line_no)), p);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return segment;
        }

        protected void parse(IDocument document) {
            MofScriptContentOutlinePage.this.previousSegment = null;
            int lines = document.getNumberOfLines();
            Math.max(Math.round(lines / 10), 10);
            new Vector();
            int line_no = 0;
            while (line_no < lines) {
                try {
                    int linelength = document.getLineLength(line_no);
                    int lineoff = document.getLineOffset(line_no);
                    String linetext = document.get(lineoff, linelength);
                    Position p = new Position(lineoff, linelength);
                    Segment decl = this.getDeclaration(linetext.trim(), line_no, p);
                    if (decl != null) {
                        document.addPosition(SEGMENTS, p);
                        if (decl instanceof RuleSegment) {
                            MofScriptContentOutlinePage.this.previousSegment = decl;
                            this.fContent.rules.add(decl);
                        } else if (decl instanceof PropertySegment) {
                            if (MofScriptContentOutlinePage.this.previousSegment != null && MofScriptContentOutlinePage.this.previousSegment instanceof RuleSegment) {
                                ((RuleSegment)MofScriptContentOutlinePage.this.previousSegment).variables.add(decl);
                            } else {
                                this.fContent.variables.add(decl);
                            }
                        }
                    }
                }
                catch (BadLocationException bex) {
                    bex.printStackTrace();
                }
                catch (BadPositionCategoryException bpex) {
                    bpex.printStackTrace();
                }
                ++line_no;
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            IDocument document;
            if (oldInput != null && (document = MofScriptContentOutlinePage.this.fDocumentProvider.getDocument(oldInput)) != null) {
                try {
                    document.removePositionCategory(SEGMENTS);
                }
                catch (BadPositionCategoryException badPositionCategoryException) {}
                document.removePositionUpdater(this.fPositionUpdater);
            }
            this.fContent.clear();
            if (newInput != null && (document = MofScriptContentOutlinePage.this.fDocumentProvider.getDocument(newInput)) != null) {
                document.addPositionCategory(SEGMENTS);
                document.addPositionUpdater(this.fPositionUpdater);
                this.parse(document);
            }
        }

        public void dispose() {
            if (this.fContent != null) {
                this.fContent.clear();
                this.fContent = null;
            }
        }

        public boolean isDeleted(Object element) {
            return false;
        }

        public Object[] getElements(Object element) {
            return this.fContent.toArray();
        }

        public boolean hasChildren(Object element) {
            return element == MofScriptContentOutlinePage.this.fInput || element == this.fContent || element == this.fContent.rules || element == this.fContent.variables || element == this.fContent.imports;
        }

        public Object getParent(Object element) {
            if (element == this.fContent) {
                return MofScriptContentOutlinePage.this.fInput;
            }
            if (element == this.fContent.rules || element == this.fContent.variables || element == this.fContent.imports) {
                return this.fContent;
            }
            if (element instanceof PropertySegment) {
                return ((PropertySegment)element).owner.variables;
            }
            if (element instanceof RuleSegment) {
                return this.fContent.rules;
            }
            if (element instanceof Segment) {
                return this.fContent;
            }
            return null;
        }

        public Object[] getChildren(Object element) {
            if (element == MofScriptContentOutlinePage.this.fInput) {
                return this.fContent.toArray();
            }
            if (element == this.fContent) {
                return this.fContent.getChildren();
            }
            if (element instanceof List) {
                return ((List)element).toArray();
            }
            if (element instanceof RuleSegment && ((RuleSegment)element).hasChildren()) {
                return ((RuleSegment)element).getChildren();
            }
            return new Object[0];
        }
    }

    protected class MofScriptLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            Image theImage = null;
            theImage = element instanceof ModuleSegment ? moduleImage : (element instanceof RuleSegment ? ruleImage : (element instanceof PropertySegment ? propertyImage : defaultImage));
            return theImage;
        }
    }

    protected static class PropertySegment
    extends Segment {
        public DeclarationSegment owner;

        public PropertySegment(String name, Position position) {
            super(name, position);
        }
    }

    protected static class RuleSegment
    extends DeclarationSegment {
        public RuleSegment(String name, Position position) {
            super(name, position);
        }

        @Override
        public Object[] getChildren() {
            return super.getChildren();
        }
    }

    protected static class Segment {
        public String name;
        public Position position;

        public Segment() {
        }

        public Segment(String name, Position position) {
            this.name = name;
            this.position = position;
        }

        public String toString() {
            return this.name;
        }

        public void clear() {
            this.name = "";
        }
    }
}

