/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.editor;

import java.io.InputStream;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mofscript.editor.ColorManager;
import org.eclipse.mofscript.editor.ExecutionUtility;
import org.eclipse.mofscript.editor.MofScriptPreferences;
import org.eclipse.mofscript.editor.MofScriptScanner;
import org.eclipse.mofscript.parser.ParserUtil;
import org.eclipse.mofscript.runtime.ExecutionManager;
import org.eclipse.mofscript.runtime.ExecutionMessageListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class MofScriptEditorPlugin
extends AbstractUIPlugin
implements ExecutionMessageListener {
    private static MofScriptEditorPlugin _plugin;
    private ResourceBundle _resourceBundle;
    private ColorManager _colorProvider;
    private MofScriptScanner _codescanner;
    private ParserUtil _parserutil;
    private static FileDialog _fileDialog;
    private static FileDialog _fileSaveDialog;
    private static MessageConsole _console;
    private static MessageConsoleStream _consoleStream;
    private static IConsoleManager _consoleMgr;
    private static final String MOFSCRIPT_CONSOLE = "MOFScript2 Console";
    private static ExecutionUtility _executionUtil;

    static {
        _fileDialog = null;
        _fileSaveDialog = null;
        _console = null;
        _consoleStream = null;
        _consoleMgr = null;
        _executionUtil = null;
    }

    public MofScriptEditorPlugin() {
        _plugin = this;
        try {
            this._resourceBundle = ResourceBundle.getBundle("MofScriptEditorPlugin");
        }
        catch (MissingResourceException x) {
            System.out.println(x);
            this._resourceBundle = null;
        }
        if (_console == null) {
            this.initConsole();
        }
        MofScriptEditorPlugin.print("MOFScript initiating ");
        this.initRepositoryProject();
        this._parserutil = this.getParserUtil();
        ExecutionManager execMgr = ExecutionManager.getExecutionManager();
        execMgr.getExecutionStack().addOutputMessageListener((ExecutionMessageListener)this);
        _executionUtil = new ExecutionUtility();
        this.checkUMLSupport();
    }

    protected void checkUMLSupport() {
        if (ExecutionManager.getExecutionManager().getUMLIsAvailable()) {
            MofScriptEditorPlugin.println("MOFScript UML extension loaded.");
        } else {
            MofScriptEditorPlugin.println("MOFScript UML extension not loaded.");
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        IWorkbenchPage page = MofScriptEditorPlugin.getActivePage();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public static MofScriptEditorPlugin getDefault() {
        return _plugin;
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = MofScriptEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getActivePage();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = MofScriptEditorPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static ExecutionUtility getExecutionUtility() {
        return _executionUtil;
    }

    public ResourceBundle getResourceBundle() {
        return this._resourceBundle;
    }

    public ColorManager getColorManager() {
        if (this._colorProvider == null) {
            this._colorProvider = new ColorManager();
        }
        return this._colorProvider;
    }

    public MofScriptScanner getCodeScanner() {
        if (this._codescanner == null) {
            this._codescanner = new MofScriptScanner(this.getColorManager());
        }
        return this._codescanner;
    }

    public boolean hasUML2Support() {
        return ExecutionManager.getExecutionManager().getUMLIsAvailable();
    }

    public ParserUtil getParserUtil() {
        if (this._parserutil == null) {
            this._parserutil = new ParserUtil();
        }
        return this._parserutil;
    }

    public FileDialog getFileDialog() {
        if (_fileDialog == null) {
            _fileDialog = new FileDialog(this.getWorkbench().getDisplay().getActiveShell(), 4096);
        }
        return _fileDialog;
    }

    public FileDialog getFileSaveDialog() {
        if (_fileSaveDialog == null) {
            _fileSaveDialog = new FileDialog(this.getWorkbench().getDisplay().getActiveShell(), 8192);
        }
        return _fileSaveDialog;
    }

    public void initializeDefaultPluginPreferences() {
        new MofScriptPreferences();
    }

    public String getPreferenceString(String what) {
        IPreferenceStore store = this.getPreferenceStore();
        String s1 = store.getString(what);
        return s1;
    }

    public static void print(String s) {
        if (_consoleStream != null) {
            _consoleStream.print(s);
            _consoleMgr.warnOfContentChange((IConsole)_console);
        }
    }

    public static void println(String s) {
        if (_consoleStream != null) {
            _consoleStream.println(s);
            _consoleMgr.warnOfContentChange((IConsole)_console);
        }
    }

    public static MessageConsoleStream getStream() {
        return _consoleStream;
    }

    private void initConsole() {
        _console = this.findConsole(MOFSCRIPT_CONSOLE);
        Font f = null;
        try {
            FontData data = new FontData("Arial", 9, 9);
            data.setStyle(2);
            f = new Font(null, data);
            _console.setFont(f);
        }
        catch (Exception exception) {}
        _consoleStream = _console.newMessageStream();
        this.activateConsole();
    }

    private MessageConsole findConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        _consoleMgr = plugin.getConsoleManager();
        IConsole[] existing = _consoleMgr.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        ImageDescriptor fDescr = null;
        try {
            InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream("img/mofscriptConsole.gif");
            new Image(null, stream);
        }
        catch (Exception exception) {}
        MessageConsole myConsole = new MessageConsole(name, fDescr);
        _consoleMgr.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    private void activateConsole() {
        IWorkbenchPage page = MofScriptEditorPlugin.getActivePage();
        String id = "org.eclipse.ui.console.ConsoleView";
        try {
            if (page != null) {
                IConsoleView view = (IConsoleView)page.showView(id);
                view.display((IConsole)_console);
            }
        }
        catch (PartInitException pex) {
            System.out.println("MofScriptEditorPlugin - " + (Object)((Object)pex));
        }
    }

    private void initRepositoryProject() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot wroot = workspace.getRoot();
        Bundle bundle = Platform.getBundle((String)"org.eclipse.mofscript.editor");
        String bundleLoc = bundle != null ? bundle.getLocation() : null;
        String version = (String)bundle.getHeaders().get("Bundle-Version");
        MofScriptEditorPlugin.println(" [v " + version + "]");
        String os = System.getProperty("osgi.os");
        bundleLoc = os.equalsIgnoreCase("win32") ? bundleLoc.replaceFirst("update@/", "") : String.valueOf(System.getProperty("file.separator")) + bundleLoc.replaceFirst("update@", "");
        if (bundleLoc != null) {
            Path path = new Path(String.valueOf(bundleLoc) + System.getProperty("file.separator") + "repository" + System.getProperty("file.separator"));
            IProject repProject = wroot.getProject("mofscriptrepository");
            try {
                ProjectDescription descr = new ProjectDescription();
                descr.setLocation((IPath)path);
                descr.setComment("MOFScript repository location");
                descr.setName("mofscriptrepository");
                if (!repProject.exists()) {
                    repProject.create((IProjectDescription)descr, null);
                }
                if (repProject != null && repProject.exists()) {
                    if (repProject.getDescription() == null) {
                        repProject.setDescription((IProjectDescription)descr, null);
                    }
                    if (!repProject.isOpen()) {
                        repProject.open(null);
                    }
                }
            }
            catch (CoreException coreException) {}
        }
    }

    public void executionMessage(String type, String description) {
        if (type == null || type.equals("") || type.equals("println")) {
            MofScriptEditorPlugin.println(description);
        } else if (type.equalsIgnoreCase("print")) {
            MofScriptEditorPlugin.print(description);
        }
    }
}

