/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.editor;

import java.util.ArrayList;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

public class MofScriptPartitionScanner
extends RuleBasedPartitionScanner {
    public static final String MOFSCRIPT_COMMENT = "__mofscript_comment";
    public static final String MOFSCRIPT_MULTILINE_COMMENT = "__mofscript__multiline_comment";
    public static final String MOFSCRIPT_MULTILINE_ESCAPE = "__mofscript__multiline_escape";
    public static final String MOFSCRIPT_DOC = "__mofscript_javadoc";
    public static final String MOFSCRIPT_LITERAL = "__mofscript_literal";
    public static final String MOFSCRIPT_SINGLE_LITERAL = "__mofscript_single_literal";
    public static final String[] allPartitions = new String[]{"__mofscript_comment", "__mofscript__multiline_comment", "__mofscript__multiline_escape", "__mofscript_javadoc", "__mofscript_literal", "__mofscript_single_literal"};

    public MofScriptPartitionScanner() {
        Token singleComment = new Token((Object)MOFSCRIPT_COMMENT);
        Token javaDoc = new Token((Object)MOFSCRIPT_DOC);
        Token multicomment = new Token((Object)MOFSCRIPT_MULTILINE_COMMENT);
        Token escape = new Token((Object)MOFSCRIPT_MULTILINE_ESCAPE);
        Token literal = new Token((Object)MOFSCRIPT_LITERAL);
        Token single_literal = new Token((Object)MOFSCRIPT_SINGLE_LITERAL);
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new EndOfLineRule("//", (IToken)singleComment));
        rules.add(new MultiLineRule("/**", "*/", (IToken)javaDoc, '\u0000', true));
        rules.add(new MultiLineRule("/*", "*/", (IToken)multicomment, '\u0000', true));
        rules.add(new MultiLineRule("<%", "%>", (IToken)escape, '\u0000', true));
        rules.add(new MultiLineRule("\"", "\"", (IToken)literal, '\\', true));
        rules.add(new MultiLineRule("'", "'", (IToken)single_literal, '\\', true));
        IPredicateRule[] result = new IPredicateRule[rules.size()];
        rules.toArray(result);
        this.setPredicateRules(result);
    }

    static class EmptyCommentDetector
    implements IWordDetector {
        EmptyCommentDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '/';
        }

        public boolean isWordPart(char c) {
            return c == '*' || c == '/';
        }
    }

    static class WordPredicateRule
    extends WordRule
    implements IPredicateRule {
        private IToken fSuccessToken;

        public WordPredicateRule(IToken successToken) {
            super((IWordDetector)new EmptyCommentDetector());
            this.fSuccessToken = successToken;
            this.addWord("/**/", this.fSuccessToken);
        }

        public IToken evaluate(ICharacterScanner scanner, boolean resume) {
            return super.evaluate(scanner);
        }

        public IToken getSuccessToken() {
            return this.fSuccessToken;
        }
    }
}

