/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptAspect;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptModelPackage;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptParameter;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptSpecification;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptTransformation;
import org.eclipse.mofscript.editor.MofScriptEditorPlugin;
import org.eclipse.mofscript.runtime.ExecutionManager;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;

public class MofScriptPopupActionDelegate
implements IEditorActionDelegate {
    private IFile _selectedFile = null;
    private MOFScriptTransformation _currentTransformation = null;

    public void selectionChanged(IAction action, ISelection selection) {
        Object fileobject;
        StructuredSelection _selection = null;
        if (selection != null && selection instanceof StructuredSelection && (fileobject = (_selection = (StructuredSelection)selection).getFirstElement()) instanceof IFile) {
            this._selectedFile = (IFile)fileobject;
        }
    }

    public void setActiveEditor(IAction action, IEditorPart targetEd) {
    }

    public void run(IAction action) {
        String action_id = action.getId();
        action.getActionDefinitionId();
        if (action_id.equalsIgnoreCase("org.eclipse.mofscript.editor.action.popupCompile")) {
            MofScriptEditorPlugin.getExecutionUtility().compile(this._selectedFile, null);
        } else if (action_id.equalsIgnoreCase("org.eclipse.mofscript.editor.action.popupExecute")) {
            MOFScriptSpecification specification = MofScriptEditorPlugin.getExecutionUtility().compile(this._selectedFile, null);
            MOFScriptTransformation transformation = (MOFScriptTransformation)specification.getTransformation().get(0);
            MOFScriptParameter parameter = (MOFScriptParameter)((MOFScriptTransformation)specification.getTransformation().get(0)).getParameters().get(0);
            EPackage sourceMM = ExecutionManager.getExecutionManager().getSourceMetaModel(parameter.getName());
            if (sourceMM != null && sourceMM instanceof MOFScriptModelPackage || transformation instanceof MOFScriptAspect) {
                MofScriptEditorPlugin.getExecutionUtility().mofScriptTextToModel(this._selectedFile, null, specification);
            } else {
                MofScriptEditorPlugin.getExecutionUtility().execute(this._selectedFile, "model2text", true);
            }
        } else if (action_id.equalsIgnoreCase("org.eclipse.mofscript.editor.action.popupStoreModel")) {
            if (this._selectedFile != null) {
                MOFScriptSpecification transformation = MofScriptEditorPlugin.getExecutionUtility().compile(this._selectedFile, null);
                MofScriptEditorPlugin.getExecutionUtility().storeMofScriptModel(transformation, this._selectedFile);
            } else {
                System.out.println("MofScriptPopupActionDelegate::Store Model Aborted - No file selected");
            }
        } else if (action_id.equalsIgnoreCase("org.eclipse.mofscript.editor.action.executeModelDirect")) {
            if (this._selectedFile != null) {
                MofScriptEditorPlugin.getExecutionUtility().executeModelDirect(this._selectedFile);
            }
        } else if (action_id.equalsIgnoreCase("org.eclipse.mofscript.editor.action.mofscriptModel2Text")) {
            if (this._selectedFile != null) {
                MofScriptEditorPlugin.getExecutionUtility().executeMOFScript2Text(this._selectedFile);
            }
        } else {
            System.out.println("MofScriptPopupActionDelegate::Action not handled - " + action_id);
        }
    }

    protected void execute() {
    }

    protected void storeModel() {
    }
}

