/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.editor;

import java.util.Properties;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.mofscript.editor.MofScriptEditorPlugin;
import org.eclipse.mofscript.runtime.ExecutionManager;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.framework.Bundle;

public class MofScriptPreferences
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String P_PATH = "pathPreference";
    public static final String P_BOOLEAN = "booleanPreference";
    public static final String P_CHOICE = "choicePreference";
    public static final String P_STRING = "stringPreference";
    public static final String REPOSITORY_PATH = "repository.path";
    public static final String REPOSITORY_METAMODELS_PATH = "repository.metamodels.path";
    public static final String REPOSITORY_MODELS_PATH = "repository.models.path";
    public static final String REPOSITORY_TRANSFORMATIONS_PATH = "repository.transformations.path";
    public static final String ROOT_DIRECTORY = "root.directory";
    public static final String GEN_TO_PROJECT = "gen.to.project";
    public static final String GEN_PROJECT_PREFIX = "gen.project.prefix";
    public static final String IMPORT_DIRECTORY = "import.directory.path";
    public static final String USE_TRACEABILITY = "use.traceability";
    public static final String TRACE_DIRECTORY = "root.directory";
    public static final String BLOCK_COMMENT_TAG = "//";
    public String TEST_STRING = "test.string";
    public static final String USE_TRAMDE = "use.tramde";
    public static final String COARSE_TRAMDE = "coarse.tramde";
    private DirectoryFieldEditor repMetaModelsField = null;
    private DirectoryFieldEditor repModelField = null;
    private DirectoryFieldEditor repTransField = null;
    private DirectoryFieldEditor rootDirField = null;
    private DirectoryFieldEditor traceDirField = null;
    private StringFieldEditor importDirectoryPath = null;
    private StringFieldEditor genProjectPrefix = null;
    private StringFieldEditor blockCommentTag = null;
    private BooleanFieldEditor useGenProject = null;
    private BooleanFieldEditor useTraceability = null;
    private BooleanFieldEditor useTramde = null;
    private BooleanFieldEditor coarseTramde = null;
    public static final String EDITOR_MATCHING_BRACKETS = "matchingBrackets";
    public static final String EDITOR_MATCHING_BRACKETS_COLOR = "matchingBracketsColor";

    public MofScriptPreferences() {
        super(1);
        this.setPreferenceStore(MofScriptEditorPlugin.getDefault().getPreferenceStore());
        this.setDescription("MOF Script Plugin Preference Page");
        this.initializeDefaults();
    }

    private void initializeDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        Bundle bundle = Platform.getBundle((String)"org.eclipse.mofscript.editor");
        String separator = System.getProperty("file.separator");
        String wsPath = null;
        IPath workspaceRootPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        if (workspaceRootPath != null) {
            wsPath = workspaceRootPath.toOSString();
        }
        String repRelative = MofScriptEditorPlugin.getResourceString(REPOSITORY_PATH);
        String repMetaRelative = MofScriptEditorPlugin.getResourceString(REPOSITORY_METAMODELS_PATH);
        String repModelRelative = MofScriptEditorPlugin.getResourceString(REPOSITORY_MODELS_PATH);
        String repTransRelative = MofScriptEditorPlugin.getResourceString(REPOSITORY_TRANSFORMATIONS_PATH);
        String dirImportPath = MofScriptEditorPlugin.getResourceString(IMPORT_DIRECTORY);
        Properties props = System.getProperties();
        props.elements();
        String os = System.getProperty("osgi.os");
        String repRelLoc = repRelative != null ? String.valueOf(repRelative) + separator : null;
        String orgBundleLoc = bundle != null ? bundle.getLocation() : null;
        String bundleLoc = null;
        bundleLoc = os.equalsIgnoreCase("win32") ? (orgBundleLoc.startsWith("update@/") ? orgBundleLoc.replaceFirst("update@/", "") : orgBundleLoc.replaceFirst("update@", "")) : (orgBundleLoc.startsWith("update@/") ? String.valueOf(separator) + orgBundleLoc.replaceFirst("update@/", "") : String.valueOf(separator) + orgBundleLoc.replaceFirst("update@", ""));
        String location = bundleLoc != null ? String.valueOf(bundleLoc) + repRelLoc : System.getProperty("user.dir");
        Platform.getLocation();
        store.setDefault(REPOSITORY_PATH, location);
        store.setDefault(REPOSITORY_METAMODELS_PATH, String.valueOf(location) + repMetaRelative);
        store.setDefault(REPOSITORY_TRANSFORMATIONS_PATH, String.valueOf(location) + repTransRelative);
        store.setDefault("root.directory", MofScriptEditorPlugin.getResourceString("root.directory"));
        store.setDefault(GEN_PROJECT_PREFIX, "mofscript-gen-");
        store.setDefault(GEN_TO_PROJECT, true);
        store.setDefault(IMPORT_DIRECTORY, dirImportPath);
        store.setDefault(USE_TRACEABILITY, false);
        store.setDefault("root.directory", MofScriptEditorPlugin.getResourceString("root.directory"));
        store.setDefault(USE_TRAMDE, false);
        store.setDefault(COARSE_TRAMDE, false);
        store.setDefault(BLOCK_COMMENT_TAG, MofScriptEditorPlugin.getResourceString(BLOCK_COMMENT_TAG));
        store.setDefault(EDITOR_MATCHING_BRACKETS, true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)EDITOR_MATCHING_BRACKETS_COLOR, (RGB)new RGB(192, 192, 192));
        if (wsPath != null) {
            store.setDefault(REPOSITORY_MODELS_PATH, wsPath);
        } else {
            store.setDefault(REPOSITORY_MODELS_PATH, String.valueOf(location) + repModelRelative);
        }
    }

    public void createFieldEditors() {
        this.repMetaModelsField = new DirectoryFieldEditor(REPOSITORY_METAMODELS_PATH, "&Metamodels path", this.getFieldEditorParent());
        this.addField((FieldEditor)this.repMetaModelsField);
        this.repModelField = new DirectoryFieldEditor(REPOSITORY_MODELS_PATH, "&Model path", this.getFieldEditorParent());
        this.addField((FieldEditor)this.repModelField);
        this.repTransField = new DirectoryFieldEditor(REPOSITORY_TRANSFORMATIONS_PATH, "&Transformation path", this.getFieldEditorParent());
        this.addField((FieldEditor)this.repTransField);
        this.rootDirField = new DirectoryFieldEditor("root.directory", "&Root Generation Dir", this.getFieldEditorParent());
        this.addField((FieldEditor)this.rootDirField);
        this.genProjectPrefix = new StringFieldEditor(GEN_PROJECT_PREFIX, "&Prefix for project generation", this.getFieldEditorParent());
        this.addField((FieldEditor)this.genProjectPrefix);
        this.useGenProject = new BooleanFieldEditor(GEN_TO_PROJECT, "Generate Eclipse Project with links", this.getFieldEditorParent());
        this.addField((FieldEditor)this.useGenProject);
        this.importDirectoryPath = new StringFieldEditor(IMPORT_DIRECTORY, "&Import path for transformations", this.getFieldEditorParent());
        this.addField((FieldEditor)this.importDirectoryPath);
        this.useTraceability = new BooleanFieldEditor(USE_TRACEABILITY, "Traceability active", this.getFieldEditorParent());
        this.addField((FieldEditor)this.useTraceability);
        this.traceDirField = new DirectoryFieldEditor("root.directory", "&Trace model Generation Dir", this.getFieldEditorParent());
        this.addField((FieldEditor)this.traceDirField);
        this.blockCommentTag = new StringFieldEditor(BLOCK_COMMENT_TAG, "&Block comment tag", this.getFieldEditorParent());
        this.addField((FieldEditor)this.blockCommentTag);
        if (!ExecutionManager.getTramdeAvailable()) {
            System.out.println("TRAMDE IS NOT AVAILABLE");
        } else {
            this.useTramde = new BooleanFieldEditor(USE_TRAMDE, "Generate TRAMDE Traces", this.getFieldEditorParent());
            this.addField((FieldEditor)this.useTramde);
            this.coarseTramde = new BooleanFieldEditor(USE_TRAMDE, "Generate Coarse-Grained TRAMDE Traces", this.getFieldEditorParent());
            this.addField((FieldEditor)this.coarseTramde);
        }
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        store.getString(P_PATH);
        store.setValue(REPOSITORY_METAMODELS_PATH, this.repMetaModelsField.getStringValue());
        store.setValue(REPOSITORY_MODELS_PATH, this.repModelField.getStringValue());
        store.setValue(REPOSITORY_TRANSFORMATIONS_PATH, this.repTransField.getStringValue());
        store.setValue("root.directory", this.rootDirField.getStringValue());
        store.setValue(GEN_PROJECT_PREFIX, this.genProjectPrefix.getStringValue());
        store.setValue(GEN_TO_PROJECT, this.useGenProject.getBooleanValue());
        store.setValue(IMPORT_DIRECTORY, this.importDirectoryPath.getStringValue());
        store.setValue(USE_TRACEABILITY, this.useTraceability.getBooleanValue());
        store.setValue("root.directory", this.traceDirField.getStringValue());
        store.setValue(BLOCK_COMMENT_TAG, this.blockCommentTag.getStringValue());
        if (ExecutionManager.getTramdeAvailable()) {
            store.setValue(USE_TRAMDE, this.useTramde.getBooleanValue());
            store.setValue(COARSE_TRAMDE, this.coarseTramde.getBooleanValue());
        } else {
            store.setValue(USE_TRAMDE, false);
        }
        return true;
    }

    public void init(IWorkbench workbench) {
    }
}

