/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.editor;

import java.util.ArrayList;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.NumberRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.mofscript.editor.ColorManager;
import org.eclipse.mofscript.editor.WhitespaceDetector;
import org.eclipse.mofscript.editor.WordDetector;

public class MofScriptScanner
extends RuleBasedScanner {
    private static String[] fgKeywords = new String[]{"textmodule", "texttransformation", "module", "abstract", "main", "extends", "super", "result", "return", "forEach", "select", "new", "in", "out", "guard", "print", "println", "Use", "use", "var", "property", "import", "file", "File", "stdout", "if", "else", "access", "library", "transformation", "and", "&&", "or", "||", "not", "!", "self", "unprotect", "log", "break", "between", "while", "aspect", "mofspect", "pointcut", "textspot", "call", "execute", "targetPointcut", "around", "before", "after"};
    private static String[] fgTypes = new String[]{"void", "Real", "real", "Integer", "integer", "String", "string", "Boolean", "boolean", "Hashtable", "hashtable", "Dictionary", "dictionary", "List", "list", "Object", "object", "Any", "any", "OclAny", "oclany"};
    private static String[] fgConstants = new String[]{"false", "null", "true"};
    private static String[] fgBrackets = new String[]{"{", "}", "[", "]", "(", ")", "<%", "%>"};
    private static String[] fgEscapeKeywords = new String[]{"newline", "nl", "tab", "space", "indent", "undent"};
    private static String[] fgOperators = new String[]{"->", ".", "::"};
    private static String[] fgStringFunctions = new String[]{"substring", "subStringBefore", "substringbefore", "subStringAfter", "substringafter", "toLower", "tolower", "toUpper", "toupper", "firstToLower", "firsttolower", "firstToUpper", "firsttoupper", "size", "indexOf", "indexof", "endsWith", "endswith", "startsWith", "startswith", "trim", "normlizeSpace", "normalizespace", "replace", "equals", "equalsIgnoreCase", "equalsignorecase", "charAt", "charat", "isUpperCase", "isuppercase", "isLowerCase", "islowercase", "strcmp", "strtok", "matches"};
    private static String[] fgHashtableFunctions = new String[]{"get", "put", "remove", "keys", "values", "size", "forEach", "foreach", "first", "last", "isEmpty", "isempty"};
    private static String[] fgListFunctions = new String[]{"add", "addOrg", "remove", "size", "forEach", "isEmpty", "addAll", "addAllFirst", "addBefore", "addAfter", "contains"};
    private static String[] fgEcoreKeyWords = new String[]{"ecore"};
    private static String[] fgSystemFunctions = new String[]{"date", "time", "exec", "setenv", "getenv", "count", "position", "fileExists", "java", "store"};

    public MofScriptScanner(ColorManager provider) {
        Token keyword = new Token((Object)new TextAttribute(provider.getColor(ColorManager.KEYWORD), null, 1));
        Token type = new Token((Object)new TextAttribute(provider.getColor(ColorManager.TYPE)));
        Token string = new Token((Object)new TextAttribute(provider.getColor(ColorManager.STRING)));
        Token comment = new Token((Object)new TextAttribute(provider.getColor(ColorManager.SINGLE_LINE_COMMENT), null, 2));
        Token bracket = new Token((Object)new TextAttribute(provider.getColor(ColorManager.BRACKETS), null, 1));
        new Token((Object)new TextAttribute(provider.getColor(ColorManager.OPERATORS)));
        new Token((Object)new TextAttribute(provider.getColor(ColorManager.MULTI_LINE_COMMENT), null, 2));
        new Token((Object)new TextAttribute(provider.getColor(ColorManager.MULTI_LINE_ESCAPE)));
        Token other = new Token((Object)new TextAttribute(provider.getColor(ColorManager.DEFAULT)));
        Token number = new Token((Object)new TextAttribute(provider.getColor(ColorManager.NUMBER), null, 1));
        Token escape_keyword = new Token((Object)new TextAttribute(provider.getColor(ColorManager.KEYWORD), null, 2));
        new Token((Object)new TextAttribute(provider.getColor(ColorManager.A_TAG), null, 1));
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new EndOfLineRule("//", (IToken)comment));
        rules.add(new NumberRule((IToken)number));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector()));
        WordRule wordRule = new WordRule((IWordDetector)new WordDetector(), (IToken)other);
        int i = 0;
        while (i < fgKeywords.length) {
            wordRule.addWord(fgKeywords[i], (IToken)keyword);
            ++i;
        }
        i = 0;
        while (i < fgTypes.length) {
            wordRule.addWord(fgTypes[i], (IToken)type);
            ++i;
        }
        i = 0;
        while (i < fgConstants.length) {
            wordRule.addWord(fgConstants[i], (IToken)string);
            ++i;
        }
        i = 0;
        while (i < fgEscapeKeywords.length) {
            wordRule.addWord(fgEscapeKeywords[i], (IToken)escape_keyword);
            ++i;
        }
        i = 0;
        while (i < fgStringFunctions.length) {
            wordRule.addWord(fgStringFunctions[i], (IToken)keyword);
            ++i;
        }
        i = 0;
        while (i < fgHashtableFunctions.length) {
            wordRule.addWord(fgHashtableFunctions[i], (IToken)keyword);
            ++i;
        }
        i = 0;
        while (i < fgListFunctions.length) {
            wordRule.addWord(fgListFunctions[i], (IToken)keyword);
            ++i;
        }
        i = 0;
        while (i < fgEcoreKeyWords.length) {
            wordRule.addWord(fgEcoreKeyWords[i], (IToken)keyword);
            ++i;
        }
        i = 0;
        while (i < fgSystemFunctions.length) {
            wordRule.addWord(fgSystemFunctions[i], (IToken)keyword);
            ++i;
        }
        rules.add(wordRule);
        wordRule = new WordRule(new IWordDetector(){

            public boolean isWordPart(char character) {
                return character == '.' || character == ':' || character == '-' || character == '>';
            }

            public boolean isWordStart(char character) {
                return character == '.' || character == ':' || character == '-';
            }
        }, (IToken)bracket);
        i = 0;
        while (i < fgOperators.length) {
            wordRule.addWord(fgOperators[i], (IToken)bracket);
            ++i;
        }
        rules.add(wordRule);
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }
}

