/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptAspect;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptParameter;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptSpecification;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptTransformation;
import org.eclipse.mofscript.editor.ColorManager;
import org.eclipse.mofscript.editor.MofScriptBracketListener;
import org.eclipse.mofscript.editor.MofScriptConfiguration;
import org.eclipse.mofscript.editor.MofScriptContentOutlinePage;
import org.eclipse.mofscript.editor.MofScriptDocument;
import org.eclipse.mofscript.editor.MofScriptDocumentProvider;
import org.eclipse.mofscript.editor.MofScriptEditorPlugin;
import org.eclipse.mofscript.runtime.ExecutionManager;
import org.eclipse.mofscript.runtime.Variable;
import org.eclipse.mofscript.runtime.statement.DebugListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class MofScriptTextEditor
extends TextEditor
implements MofScriptBracketListener,
PaintListener,
DebugListener {
    private ColorManager colorManager = new ColorManager();
    private ProjectionSupport fProjectionSupport = null;
    private MofScriptContentOutlinePage fOutlinePage;
    protected volatile String _currentTransformationText = null;
    protected volatile IDocument _currentDocument = null;
    protected volatile IFile _currentFile = null;
    protected String _editorDocumentName = null;
    protected static String _currentDocumentName = null;
    protected StyledText _text;
    protected volatile boolean _paintSelection = false;
    protected volatile int _selectionRangeStart = -1;
    protected volatile int _selectionRangeEnd = -1;

    public MofScriptTextEditor() {
        this.setDocumentProvider((IDocumentProvider)new MofScriptDocumentProvider());
        MofScriptConfiguration config = new MofScriptConfiguration(this.colorManager, this);
        this.setSourceViewerConfiguration(config);
        ExecutionManager.addDebugListener((DebugListener)this);
        String rep = MofScriptEditorPlugin.getDefault().getPreferenceString("repository.metamodels.path");
        MofScriptEditorPlugin.getDefault().getParserUtil().setMetaModelRepositoryURI(rep);
    }

    public IFile getCurrentFile() {
        return this._currentFile;
    }

    protected void initializeEditor() {
        super.initializeEditor();
        IPreferenceStore store = this.createCombinedPreferenceStore(null);
        this.setPreferenceStore(store);
    }

    private IPreferenceStore createCombinedPreferenceStore(IEditorInput input) {
        ArrayList<IPreferenceStore> stores = new ArrayList<IPreferenceStore>(3);
        stores.add(MofScriptEditorPlugin.getDefault().getPreferenceStore());
        stores.add(EditorsUI.getPreferenceStore());
        return new ChainedPreferenceStore(stores.toArray(new IPreferenceStore[stores.size()]));
    }

    public void moveSelectionToRule(String ruleName) {
        if (ruleName == null || ruleName.equals("")) {
            return;
        }
        String contents = this.getSourceViewer().getDocument().get();
        int indexStart = contents.indexOf("::" + ruleName);
        if (indexStart > -1) {
            try {
                this.getSourceViewer().setSelectedRange(indexStart + 2, ruleName.length());
                int lines = this.getSourceViewer().getDocument().getNumberOfLines(0, indexStart);
                this.getSourceViewer().setTopIndex(lines - 2);
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fAnnotationAccess = this.createAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        this._text = viewer.getTextWidget();
        this._text.addModifyListener((ModifyListener)new MofScriptModifyListener());
        this._text.addPaintListener((PaintListener)this);
        return viewer;
    }

    protected SourceViewerDecorationSupport getSourceViewerDecorationSupport(ISourceViewer viewer) {
        if (this.fSourceViewerDecorationSupport == null) {
            this.fSourceViewerDecorationSupport = new SourceViewerDecorationSupport(viewer, this.getOverviewRuler(), this.getAnnotationAccess(), this.getSharedColors());
            this.configureSourceViewerDecorationSupport(this.fSourceViewerDecorationSupport);
            this.fSourceViewerDecorationSupport.install(this.getPreferenceStore());
        }
        return this.fSourceViewerDecorationSupport;
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        super.configureSourceViewerDecorationSupport(support);
        char[] matchChars = new char[]{'{', '}', '(', ')'};
        DefaultCharacterPairMatcher matcher = new DefaultCharacterPairMatcher(matchChars, "__dftl_partition_content_type");
        support.setCharacterPairMatcher((ICharacterPairMatcher)matcher);
        support.setMatchingCharacterPainterPreferenceKeys("matchingBrackets", "matchingBracketsColor");
    }

    private void setActionEnabled(boolean enabled) {
        IAction execAction = null;
        try {
            execAction = this.getAction("org.eclipse.mofscript.editor.action.executePrevious");
        }
        catch (Exception exception) {}
        if (execAction != null) {
            execAction.setEnabled(enabled);
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.setActionEnabled(false);
    }

    public void dispose() {
        this.colorManager.dispose();
        if (this.fOutlinePage != null) {
            this.fOutlinePage.setInput(null);
        }
        super.dispose();
    }

    public void doRevertToSaved() {
        super.doRevertToSaved();
        if (this.fOutlinePage != null) {
            this.fOutlinePage.update();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        if (this.fOutlinePage != null) {
            this.fOutlinePage.update();
        }
        this.compile();
    }

    public void doSaveAs() {
        super.doSaveAs();
        if (this.fOutlinePage != null) {
            this.fOutlinePage.update();
        }
    }

    public void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        if (this.fOutlinePage != null) {
            this.fOutlinePage.setInput(input);
        }
        IEditorInput editorinput = this.getEditorInput();
        IDocumentProvider docprovider = this.getDocumentProvider();
        this._currentDocument = docprovider.getDocument((Object)editorinput);
        this._editorDocumentName = editorinput.getName();
        this._currentTransformationText = this._currentDocument.get();
    }

    public Object getAdapter(Class required) {
        Object adapter;
        if (IContentOutlinePage.class.equals((Object)required)) {
            if (this.fOutlinePage == null) {
                this.fOutlinePage = new MofScriptContentOutlinePage(this.getDocumentProvider(), (ITextEditor)this);
                if (this.getEditorInput() != null) {
                    this.fOutlinePage.setInput(this.getEditorInput());
                }
            }
            return this.fOutlinePage;
        }
        if (this.fProjectionSupport != null && (adapter = this.fProjectionSupport.getAdapter(this.getSourceViewer(), required)) != null) {
            return adapter;
        }
        return super.getAdapter(required);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        this.fProjectionSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.info");
        this.fProjectionSupport.install();
        viewer.doOperation(19);
    }

    public MOFScriptSpecification compile() {
        MOFScriptSpecification transformation = null;
        IEditorInput editorinput = this.getEditorInput();
        IDocumentProvider docprovider = this.getDocumentProvider();
        this._currentDocument = docprovider.getDocument((Object)editorinput);
        this._currentTransformationText = this._currentDocument.get();
        if (this._currentDocument instanceof MofScriptDocument) {
            this._currentFile = ((MofScriptDocument)this._currentDocument).getFile();
            transformation = MofScriptEditorPlugin.getExecutionUtility().compile(this._currentFile, this._currentTransformationText);
        }
        return transformation;
    }

    public String getCurrentFileLocationString() {
        IEditorInput editorinput = this.getEditorInput();
        IDocumentProvider docprovider = this.getDocumentProvider();
        if (this._currentDocument == null) {
            this._currentDocument = docprovider.getDocument((Object)editorinput);
        }
        if (this._currentFile == null) {
            this._currentFile = ((MofScriptDocument)this._currentDocument).getFile();
        }
        if (this._currentFile != null) {
            return this._currentFile.getParent().getLocation().toOSString();
        }
        return null;
    }

    public String getCurrentFileName() {
        if (this._currentFile == null) {
            this.getCurrentFileLocationString();
        }
        if (this._currentFile != null) {
            return this._currentFile.getName();
        }
        return null;
    }

    public void execute(String type) {
        MOFScriptSpecification specification = this.compile();
        MOFScriptTransformation transformation = (MOFScriptTransformation)specification.getTransformation().get(0);
        MOFScriptParameter parameter = (MOFScriptParameter)((MOFScriptTransformation)specification.getTransformation().get(0)).getParameters().get(0);
        String paramType = parameter.getType();
        if (transformation instanceof MOFScriptAspect) {
            MofScriptEditorPlugin.getExecutionUtility().aspectTransformation(this._currentFile, this._currentTransformationText, specification);
        } else if (paramType.equalsIgnoreCase("http://org.eclipse.mofscript.model")) {
            MofScriptEditorPlugin.getExecutionUtility().mofScriptTextToModel(this._currentFile, this._currentTransformationText, specification);
        } else {
            MofScriptEditorPlugin.getExecutionUtility().execute(this._currentFile, type, true);
        }
    }

    protected CompositeRuler createCompositeRuler() {
        CompositeRuler ruler = new CompositeRuler();
        AnnotationRulerColumn column = new AnnotationRulerColumn(12, this.getAnnotationAccess());
        if (this.isLineNumberRulerVisible()) {
            ruler.addDecorator(1, this.createLineNumberRulerColumn());
        }
        ruler.addDecorator(0, (IVerticalRulerColumn)column);
        return ruler;
    }

    @Override
    public void bracketInserted(int positionStart, int positionEnd) {
    }

    public void paintControl(PaintEvent e) {
        GC gc = e.gc;
        if (gc != null) {
            // empty if block
        }
    }

    public void debugEntered(List<Variable> vars, int line) {
        MofScriptEditorPlugin.println("\n ---- DebugInfo (line: " + line + ") ----");
        for (Variable v : vars) {
            MofScriptEditorPlugin.println(" ------ " + v.name + ":" + v.value);
        }
        MofScriptEditorPlugin.println(" ---- End DebugInfo (line: " + line + ")" + "----");
    }

    private class MofScriptModifyListener
    implements ModifyListener {
        public void modifyText(ModifyEvent e) {
        }
    }
}

