/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.editor;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.mofscript.editor.MofScriptEditorMessages;
import org.eclipse.swt.graphics.Point;

public class MofScriptTextHover
implements ITextHover {
    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        if (hoverRegion != null) {
            int wordEndCounter = 0;
            int wordStartCounter = 0;
            String hoverWord = null;
            try {
                char nextChar;
                wordEndCounter = hoverRegion.getOffset();
                while (wordEndCounter < textViewer.getDocument().getLength()) {
                    nextChar = textViewer.getDocument().getChar(wordEndCounter);
                    if (!Character.isLetter(nextChar)) break;
                    ++wordEndCounter;
                }
                wordStartCounter = hoverRegion.getOffset() - 1;
                while (wordStartCounter > 0) {
                    nextChar = textViewer.getDocument().getChar(wordStartCounter);
                    if (!Character.isLetter(nextChar)) break;
                    --wordStartCounter;
                }
                hoverWord = textViewer.getDocument().get(wordStartCounter + 1, wordEndCounter - wordStartCounter - 1);
                return MofScriptEditorMessages.getFunctionDescription(hoverWord);
            }
            catch (BadLocationException badLocationException) {}
        }
        return MofScriptEditorMessages.getString("MofScriptTextHover.emptySelection");
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        Point selection = textViewer.getSelectedRange();
        if (selection.x <= offset && offset < selection.x + selection.y) {
            return new Region(selection.x, selection.y);
        }
        return new Region(offset, 0);
    }
}

