/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.editor.hyperlink;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.mofscript.editor.MofScriptDocument;
import org.eclipse.mofscript.editor.MofScriptTextEditor;
import org.eclipse.mofscript.editor.hyperlink.MofScriptImportedRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class MofScriptFileImportHyperLink
implements IHyperlink {
    IRegion targetRegion = null;
    IRegion sourceRegion = null;
    ITextViewer viewer = null;
    MofScriptTextEditor editor = null;

    public MofScriptFileImportHyperLink(ITextViewer viewer, MofScriptTextEditor editor, IRegion source, IRegion target) {
        this.viewer = viewer;
        this.sourceRegion = source;
        this.targetRegion = target;
        this.editor = editor;
    }

    public IRegion getHyperlinkRegion() {
        return this.sourceRegion;
    }

    public String getHyperlinkText() {
        return null;
    }

    public String getTypeLabel() {
        return null;
    }

    public void open() {
        if (this.targetRegion instanceof MofScriptImportedRegion) {
            this.openNewEditorUri(((MofScriptImportedRegion)this.targetRegion).getUri(), ((MofScriptImportedRegion)this.targetRegion).getRuleName());
        }
    }

    protected void openNewEditorUri(String uri, String ruleName) {
        IFile currentFile = ((MofScriptDocument)this.viewer.getDocument()).getFile();
        if (currentFile == null) {
            return;
        }
        Path path = new Path(uri);
        IFile theFile = currentFile.getParent().getFile((IPath)path);
        FileEditorInput editorInput = new FileEditorInput(theFile);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        try {
            IEditorPart epart = page.openEditor((IEditorInput)editorInput, "org.eclipse.mofscript.editor.MofScriptTextEditor");
            ((MofScriptTextEditor)epart).moveSelectionToRule(ruleName);
        }
        catch (PartInitException ioex) {
            ioex.printStackTrace();
        }
    }
}

