/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.editor.hyperlink;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.mofscript.editor.MofScriptTextEditor;
import org.eclipse.mofscript.editor.hyperlink.MofScriptFileImportHyperLink;
import org.eclipse.mofscript.editor.hyperlink.MofScriptHyperLink;
import org.eclipse.mofscript.editor.hyperlink.MofScriptImportedRegion;
import org.eclipse.mofscript.runtime.ExecutionManager;
import org.eclipse.mofscript.runtime.TransformationProxy;

public class MofScriptLinkDetector
implements IHyperlinkDetector {
    private MofScriptTextEditor _editor = null;

    public MofScriptLinkDetector(MofScriptTextEditor editor) {
        this._editor = editor;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer viewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IHyperlink[] links = null;
        IDocument document = viewer.getDocument();
        IRegion linkRegion = this.computeWordRegion(document, region);
        if (linkRegion == null) {
            return null;
        }
        IRegion target = null;
        if (linkRegion instanceof MofScriptImportedRegion) {
            target = linkRegion;
        } else {
            String possibleLink = this.extractWord(document, linkRegion);
            target = this.resolveDeclaration(document, possibleLink);
        }
        Object theLink = null;
        if (target instanceof MofScriptImportedRegion) {
            theLink = new MofScriptFileImportHyperLink(viewer, this._editor, linkRegion, target);
            links = new IHyperlink[]{theLink};
        } else if (target != null) {
            theLink = new MofScriptHyperLink(viewer, this._editor, linkRegion, target);
            links = new IHyperlink[]{theLink};
        }
        return links;
    }

    protected IRegion computeWordRegion(IDocument doc, IRegion reg) {
        int startIndex;
        int endIndex;
        int offset;
        Region regToReturn;
        block8: {
            regToReturn = null;
            offset = reg.getOffset();
            endIndex = -1;
            startIndex = -1;
            IRegion lineInfo = doc.getLineInformationOfOffset(offset);
            String line = doc.get(lineInfo.getOffset(), lineInfo.getLength()).trim();
            if (!line.startsWith("import")) break block8;
            int start = line.indexOf(34);
            int end = line.lastIndexOf(34);
            if (start > -1 && end > -1) {
                String uri = line.substring(start + 1, end);
                regToReturn = new MofScriptImportedRegion(lineInfo.getOffset() + start + 1, uri.length(), uri, "");
                return regToReturn;
            }
            return null;
        }
        try {
            char offchar = doc.getChar(offset);
            while (Character.isJavaIdentifierPart(offchar)) {
                offchar = doc.getChar(++offset);
            }
            endIndex = offset;
            offset = reg.getOffset();
            offchar = doc.getChar(offset);
            startIndex = offset - 1;
            while (Character.isJavaIdentifierPart(offchar)) {
                offchar = doc.getChar(--offset);
            }
            startIndex = offset + 1;
            if (offchar != '.' && offchar != ' ') {
                endIndex = -1;
                startIndex = -1;
            }
        }
        catch (BadLocationException badLocationException) {}
        if (endIndex > startIndex && endIndex > -1 && startIndex > -1) {
            regToReturn = new Region(startIndex, endIndex - startIndex);
        }
        return regToReturn;
    }

    protected String extractWord(IDocument doc, IRegion reg) {
        String word = "";
        try {
            word = doc.get(reg.getOffset(), reg.getLength());
        }
        catch (BadLocationException badLocationException) {}
        return word;
    }

    protected IRegion resolveDeclaration(IDocument doc, String toFind) {
        String lookFor;
        MofScriptImportedRegion targetReg = null;
        String allDoc = doc.get();
        int index = allDoc.indexOf(lookFor = "::" + toFind);
        if (index > -1) {
            try {
                IRegion lineInfo = doc.getLineInformationOfOffset(index);
                String line = doc.get(lineInfo.getOffset(), lineInfo.getLength());
                boolean isRule = line.matches(".*?" + toFind + "[ ]*?\\(.*");
                if (isRule) {
                    targetReg = new Region(index + 2, toFind.length());
                }
            }
            catch (BadLocationException badLocationException) {}
        } else {
            String uri;
            TransformationProxy trProxy = ExecutionManager.getExecutionManager().getTransformationProxy();
            if (trProxy != null && (uri = trProxy.getTransformationUriForRule(toFind)) != null) {
                targetReg = new MofScriptImportedRegion(0, 0, uri, toFind);
            }
        }
        return targetReg;
    }
}

