/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.editor.properties;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.mofscript.editor.MofScriptEditorPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class MofScriptPropertyPage
extends PropertyPage {
    private static final String PATH_TITLE = "Path:";
    private static final int TEXT_FIELD_WIDTH = 50;
    private static final boolean USE_LOG = false;
    private static final boolean DEFAULT_LOG = false;
    private static final String LOG_TITLE = "Use log";
    public static final String EXECUTED_DATE_PROPERTY = "EXECUTED_DATE";
    public static final String INPUT_SOURCE_PROPERTY = "INPUT_SOURCE";
    public static final String OUTPUT_DIRECTORY_PROPERTY = "OUTPUT_DIR";
    public static final String LOG_PROPERTY = "LOG";
    private Button logButton;
    private Label lastExecutedDate;
    private Label lastExecutedSource;
    private DirectoryFieldEditor outputDirectory;

    private void addFirstSection(Composite parent) {
        Composite composite = this.createDefaultComposite(parent);
        Label pathLabel = new Label(composite, 0);
        pathLabel.setText(PATH_TITLE);
        Text pathValueText = new Text(composite, 72);
        pathValueText.setText(((IResource)this.getElement()).getFullPath().toString());
    }

    private void addSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        separator.setLayoutData((Object)gridData);
    }

    private void addSecondSection(Composite parent) {
        Composite composite = this.createDefaultComposite(parent);
        Label lastExecuted = new Label(composite, 0);
        lastExecuted.setText("Last executed:");
        this.lastExecutedDate = new Label(composite, 0);
        this.lastExecutedDate.setText("00.00.0000");
        new Label(composite, 0);
        Label executionSource = new Label(composite, 0);
        executionSource.setText("Source of last execution:");
        this.lastExecutedSource = new Label(composite, 0);
        this.lastExecutedSource.setText("");
        new Label(composite, 0);
        try {
            String execDate = ((IResource)this.getElement()).getPersistentProperty(new QualifiedName("", EXECUTED_DATE_PROPERTY));
            if (execDate != null) {
                this.lastExecutedDate.setText(execDate);
            }
        }
        catch (CoreException coreException) {}
        try {
            String execSource = ((IResource)this.getElement()).getPersistentProperty(new QualifiedName("", INPUT_SOURCE_PROPERTY));
            if (execSource != null) {
                this.lastExecutedSource.setText(execSource);
            }
        }
        catch (CoreException coreException) {}
        Label logLabel = new Label(composite, 0);
        logLabel.setText(LOG_TITLE);
        this.logButton = new Button(composite, 32);
        try {
            String useLog = ((IResource)this.getElement()).getPersistentProperty(new QualifiedName("", LOG_PROPERTY));
            if (useLog != null) {
                Boolean b = new Boolean(useLog);
                this.logButton.setSelection(b.booleanValue());
            } else {
                this.logButton.setSelection(false);
            }
        }
        catch (CoreException coreException) {
            this.logButton.setSelection(false);
        }
        new Label(composite, 0);
        this.outputDirectory = new DirectoryFieldEditor("OutputDirChooser", "Select Root Output Directory:", composite);
        try {
            String dir = ((IResource)this.getElement()).getPersistentProperty(new QualifiedName("", OUTPUT_DIRECTORY_PROPERTY));
            if (dir != null) {
                this.outputDirectory.setStringValue(dir);
            } else {
                this.outputDirectory.setStringValue(MofScriptEditorPlugin.getDefault().getPreferenceString("root.directory"));
            }
        }
        catch (CoreException coreException) {
            this.outputDirectory.setStringValue(MofScriptEditorPlugin.getDefault().getPreferenceString("root.directory"));
        }
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        this.addFirstSection(composite);
        this.addSeparator(composite);
        this.addSecondSection(composite);
        return composite;
    }

    private Composite createDefaultComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    protected void performDefaults() {
        this.logButton.setSelection(false);
    }

    public boolean performOk() {
        try {
            String logProp = Boolean.toString(this.logButton.getSelection());
            ((IResource)this.getElement()).setPersistentProperty(new QualifiedName("", LOG_PROPERTY), logProp);
            ((IResource)this.getElement()).setPersistentProperty(new QualifiedName("", OUTPUT_DIRECTORY_PROPERTY), this.outputDirectory.getStringValue());
        }
        catch (CoreException coreException) {
            return false;
        }
        return true;
    }
}

