/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mofscript.editor.wizards;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mofscript.editor.wizards.MofScriptNewWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class MofScriptNewWizard
extends Wizard
implements INewWizard {
    private MofScriptNewWizardPage page;
    private ISelection selection;
    private String fileName = null;
    private String modelType = null;

    public MofScriptNewWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new MofScriptNewWizardPage(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final String containerName = this.page.getContainerName();
        this.fileName = this.page.getFileName();
        this.modelType = this.page.getModelType();
        if (this.modelType != null) {
            this.modelType = this.modelType.toLowerCase();
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        MofScriptNewWizard.this.doFinish(containerName, MofScriptNewWizard.this.fileName, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException("Container \"" + containerName + "\" does not exist.");
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        try {
            InputStream stream = this.openContentStream();
            if (file.exists()) {
                file.setContents(stream, true, true, monitor);
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (IOException iOException) {}
        monitor.worked(1);
        monitor.setTaskName("Opening file for editing...");
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        });
        monitor.worked(1);
    }

    private InputStream openContentStream() {
        String metamodelType = "uml:\"http://www.eclipse.org/uml2/2.1.0/UML";
        int index = this.fileName.lastIndexOf(46);
        String filePrefix = this.fileName;
        StringBuffer contents = new StringBuffer();
        if (index > -1) {
            filePrefix = this.fileName.substring(0, index);
        }
        String templateFile = "template.m2t";
        if (this.modelType.startsWith("uml")) {
            templateFile = "umltemplate.m2t";
        } else if (this.modelType.startsWith("ecore")) {
            templateFile = "ecoretemplate.m2t";
        } else if (this.modelType.startsWith("mofscript")) {
            templateFile = "mofscripttemplate.m2t";
        }
        InputStream resourceStream = ((Object)((Object)this)).getClass().getResourceAsStream(templateFile);
        try {
            if (resourceStream != null) {
                InputStreamReader reader = new InputStreamReader(resourceStream);
                BufferedReader breader = new BufferedReader(reader);
                String line = breader.readLine();
                while (line != null) {
                    contents.append(String.valueOf(line) + "\n");
                    line = breader.readLine();
                }
            }
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
        if (contents.length() == 0) {
            contents.append("/**\n * transformation " + filePrefix + "\n" + " *\n" + " *\n" + " */\n\n" + "texttransformation " + filePrefix + " (in " + metamodelType + "\") {\n\n" + "  uml.Class::main () {\n" + "     'Class ' self.name ' {\n" + "     '\n" + "     self.ownedAttribute->forEach(p:uml.Property) {\n" + "        " + "     }\n" + "  '}'" + "  }\n" + "}");
        }
        return new ByteArrayInputStream(contents.toString().getBytes());
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "org.eclipse.mofscript.editor", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

