/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.editor.agilegrid;

import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.Cell;
import org.agilemore.agilegrid.IContentProvider;
import org.agilemore.agilegrid.SWTResourceManager;
import org.agilemore.agilegrid.renderers.TextCellRenderer;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.AttributeValueBoolean;
import org.eclipse.rmf.reqif10.AttributeValueXHTML;
import org.eclipse.rmf.reqif10.EnumValue;
import org.eclipse.rmf.reqif10.XhtmlContent;
import org.eclipse.rmf.reqif10.common.util.ProrXhtmlSimplifiedHelper;
import org.eclipse.rmf.reqif10.common.util.ReqIF10Util;
import org.eclipse.rmf.reqif10.pror.editor.agilegrid.ProrAgileGrid;
import org.eclipse.rmf.reqif10.pror.editor.presentation.Reqif10EditorPlugin;
import org.eclipse.rmf.reqif10.pror.util.ProrUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractProrCellRenderer
extends TextCellRenderer {
    protected final AdapterFactory adapterFactory;
    public static Color COLOR_RED = SWTResourceManager.getColor((int)3);
    private final Image IMG_WARN_FALSE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
    private final Image IMG_WARN_TRUE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
    private Shell xhtmlSimplifiedToolTip;
    private boolean isXhtmlSimplifiedListenerInit = false;
    private IContentProvider contentProvider;

    public AbstractProrCellRenderer(AgileGrid agileGrid, AdapterFactory adapterFactory) {
        super(agileGrid);
        this.adapterFactory = adapterFactory;
        this.contentProvider = agileGrid.getContentProvider();
    }

    public AbstractProrCellRenderer(AgileGrid agileGrid) {
        this(agileGrid, null);
    }

    protected int doDrawCellContentDefault(GC gc, Rectangle rect, Object value) {
        String stringValue;
        Image img = null;
        boolean defaultValue = false;
        if (value instanceof AttributeValue) {
            defaultValue = ((AttributeValue)value).eContainer() == null;
            Object v = ReqIF10Util.getTheValue((AttributeValue)((AttributeValue)value));
            if (v instanceof GregorianCalendar) {
                GregorianCalendar cal = (GregorianCalendar)v;
                Date date = cal.getTime();
                stringValue = DateFormat.getDateTimeInstance().format(date);
            } else if (v instanceof List) {
                stringValue = this.convertListToString((List)v);
            } else if (v instanceof XhtmlContent && v != null) {
                if (!this.isXhtmlSimplifiedListenerInit) {
                    this.initXhtmlSimplifiedToolTipListener();
                }
                XhtmlContent xhtmlContent = (XhtmlContent)v;
                AttributeValueXHTML atrXhtml = (AttributeValueXHTML)value;
                stringValue = ProrXhtmlSimplifiedHelper.xhtmlToSimplifiedString((XhtmlContent)xhtmlContent);
                boolean formattedAttribute = ProrXhtmlSimplifiedHelper.isFormattedAttribute((XhtmlContent)xhtmlContent);
                if (!atrXhtml.isSetSimplified() && formattedAttribute) {
                    img = this.IMG_WARN_FALSE;
                } else if (atrXhtml.isSetSimplified() && atrXhtml.getTheOriginalValue() != null) {
                    img = this.IMG_WARN_TRUE;
                }
            } else {
                stringValue = value instanceof AttributeValueBoolean ? (!((AttributeValueBoolean)value).isSetTheValue() ? "" : ((Boolean)v != false ? "\u2612" : "\u2610")) : (v == null ? "" : v.toString());
            }
        } else {
            stringValue = value != null ? value.toString() : "";
        }
        int alignment = this.getAlignment();
        String wrappedText = this.wrapText(gc, stringValue.replace('\t', ' '), rect.width);
        gc.setForeground(defaultValue ? COLOR_LINE_DARKGRAY : COLOR_TEXT);
        this.drawTextImage(gc, wrappedText, alignment, img, alignment, rect.x + 3, rect.y + 2, rect.width - 6, rect.height - 4);
        return gc.textExtent((String)wrappedText).y;
    }

    private String convertListToString(List<?> list) {
        StringBuffer sb = new StringBuffer();
        for (Object object : list) {
            if (object instanceof EnumValue) {
                ItemProviderAdapter itemProvider = ProrUtil.getItemProvider((AdapterFactory)this.adapterFactory, object);
                sb.append(itemProvider.getText(object));
            } else {
                sb.append(object.toString());
            }
            sb.append("\n");
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - 1, sb.length());
        }
        String stringValue = sb.toString();
        return stringValue;
    }

    protected void initialColor(int row, int col) {
        this.background = this.agileGrid.isCellSelected(row, col) ? SWTResourceManager.getColor((int)223, (int)227, (int)237) : SWTResourceManager.getColor((int)1);
    }

    protected void drawCellContent(GC gc, Rectangle rect, int row, int col) {
        this.foreground = this.getDefaultForeground();
        this.background = this.getDefaultBackground();
        if (this.agileGrid instanceof ProrAgileGrid) {
            ProrAgileGrid grid = (ProrAgileGrid)this.agileGrid;
            if (grid.dndHoverCell != null && row == grid.dndHoverCell.row && grid.dndHoverDropMode == 1) {
                this.background = COLOR_BGROWSELECTION;
            }
        }
        this.initialColor(row, col);
        this.clearCellContentRect(gc, rect);
        this.doDrawCellContent(gc, rect, row, col);
    }

    private void initXhtmlSimplifiedToolTipListener() {
        Listener l = new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 1: 
                    case 5: 
                    case 12: {
                        if (AbstractProrCellRenderer.this.xhtmlSimplifiedToolTip == null) break;
                        AbstractProrCellRenderer.this.xhtmlSimplifiedToolTip.dispose();
                        AbstractProrCellRenderer.this.xhtmlSimplifiedToolTip = null;
                        break;
                    }
                    case 32: {
                        Point mousePointer = new Point(e.x, e.y);
                        Cell cell = AbstractProrCellRenderer.this.agileGrid.getCell(mousePointer.x, mousePointer.y);
                        Rectangle cellRect = AbstractProrCellRenderer.this.agileGrid.getCellRect(cell.row, cell.column);
                        Rectangle rectNew = new Rectangle(cellRect.x, cellRect.y + cellRect.height / 2 - 12, 25, 25);
                        if (!rectNew.contains(mousePointer)) break;
                        if (AbstractProrCellRenderer.this.xhtmlSimplifiedToolTip != null && !AbstractProrCellRenderer.this.xhtmlSimplifiedToolTip.isDisposed()) {
                            AbstractProrCellRenderer.this.xhtmlSimplifiedToolTip.dispose();
                        }
                        Point displayPointer = AbstractProrCellRenderer.this.agileGrid.toDisplay(mousePointer);
                        Object contentAt = AbstractProrCellRenderer.this.contentProvider.getContentAt(cell.row, cell.column);
                        if (!(contentAt instanceof AttributeValueXHTML)) break;
                        AttributeValueXHTML atrXhtml = (AttributeValueXHTML)contentAt;
                        String msg = "_UI_Reqif10XhtmlIsSimplifiedFalse";
                        if (atrXhtml.isSimplified() && atrXhtml.getTheOriginalValue() != null) {
                            msg = "_UI_Reqif10XhtmlIsSimplifiedTrue";
                        }
                        AbstractProrCellRenderer.this.xhtmlSimplifiedToolTip = AbstractProrCellRenderer.this.showTooltip(Display.getDefault().getActiveShell(), displayPointer.x + 10, displayPointer.y + 10, Reqif10EditorPlugin.INSTANCE.getString(msg));
                    }
                }
            }
        };
        this.agileGrid.addListener(12, l);
        this.agileGrid.addListener(1, l);
        this.agileGrid.addListener(5, l);
        this.agileGrid.addListener(32, l);
        this.isXhtmlSimplifiedListenerInit = true;
    }

    private Shell showTooltip(Shell parent, int x, int y, String msg) {
        Shell tooltip = new Shell(parent, 16388);
        tooltip.setLayout((Layout)new GridLayout());
        tooltip.setBackground(tooltip.getDisplay().getSystemColor(29));
        tooltip.setBackgroundMode(2);
        Label lbContent = new Label((Composite)tooltip, 0);
        lbContent.setText(msg);
        Point lbContentSize = lbContent.computeSize(-1, -1);
        int width = lbContentSize.x + 10;
        int height = lbContentSize.y + 10;
        tooltip.setBounds(x, y, width, height);
        tooltip.setVisible(true);
        return tooltip;
    }
}

