/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.editor.properties.sections.tool.directeditlabel;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.tool.DirectEditLabel;
import org.eclipse.sirius.editor.editorPlugin.SiriusEditor;
import org.eclipse.sirius.editor.properties.sections.common.AbstractEditorDialogWithListPropertySection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class DirectEditLabelMappingPropertySection
extends AbstractEditorDialogWithListPropertySection {
    protected String getDefaultLabelText() {
        return "Mapping";
    }

    protected String getLabelText() {
        String labelText = String.valueOf(super.getLabelText()) + "*:";
        return labelText;
    }

    protected String getFeatureAsText() {
        String string = new String();
        if (((DirectEditLabel)this.eObject).getMapping() != null) {
            List values = this.getCurrentValue();
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                EObject eObj = (EObject)iterator.next();
                string = String.valueOf(string) + this.getAdapterFactoryLabelProvider(eObj).getText((Object)eObj);
                if (!iterator.hasNext()) continue;
                string = String.valueOf(string) + ", ";
            }
        }
        return string;
    }

    protected boolean isEqual(List newList) {
        return newList.equals(((DirectEditLabel)this.eObject).getMapping());
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.text.setToolTipText("Mappings on which this edit label tool is applicable.");
        CLabel help = this.getWidgetFactory().createCLabel(this.composite, "");
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.text, 0, 128);
        data.left = new FormAttachment((Control)this.nameLabel);
        help.setLayoutData((Object)data);
        help.setFont(SiriusEditor.getFontRegistry().get("description"));
        help.setImage(this.getHelpIcon());
        help.setToolTipText("Mappings on which this edit label tool is applicable.");
        this.nameLabel.setFont(SiriusEditor.getFontRegistry().get("required"));
    }

    protected List getCurrentValue() {
        return ((DirectEditLabel)this.eObject).getMapping();
    }

    protected boolean getSortChoice() {
        return true;
    }

    protected List getChoiceOfValues() {
        UnmodifiableIterator filter = Iterators.filter((Iterator)this.eObject.eResource().getResourceSet().getAllContents(), DiagramElementMapping.class);
        return Lists.newArrayList((Iterator)filter);
    }

    protected void handleFeatureModified(List result) {
        boolean equals = this.isEqual(result);
        if (!equals) {
            EditingDomain editingDomain = ((IEditingDomainProvider)this.getPart()).getEditingDomain();
            List value = result;
            if (this.eObjectList.size() == 1) {
                CompoundCommand compoundCommand = new CompoundCommand();
                List eGet = this.getCurrentValue();
                if (eGet instanceof EList) {
                    for (Object object : (EList)eGet) {
                        compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, object, (Object)DescriptionPackage.eINSTANCE.getDiagramElementMapping_LabelDirectEdit(), null));
                    }
                }
                if (value instanceof EList) {
                    for (Object object : (EList)value) {
                        compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, object, (Object)DescriptionPackage.eINSTANCE.getDiagramElementMapping_LabelDirectEdit(), (Object)this.eObject));
                    }
                }
                editingDomain.getCommandStack().execute((Command)compoundCommand);
            } else {
                CompoundCommand compoundCommand = new CompoundCommand();
                for (EObject nextObject : this.eObjectList) {
                    compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)nextObject, (Object)this.getFeature(), (Object)value));
                }
                editingDomain.getCommandStack().execute((Command)compoundCommand);
            }
        }
    }
}

