/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.ui;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang.reflect.MethodUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.commons.ui.E4CssParseException;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class E4ThemeColor {
    private static boolean loggedError = false;

    public static RGB getRGBFromCssString(String cssValue) {
        try {
            String[] rgbValues;
            if (cssValue.startsWith("rgb(") && cssValue.endsWith(")") && (rgbValues = cssValue.substring(4, cssValue.length() - 1).split(",")).length == 3) {
                return new RGB(Integer.parseInt(rgbValues[0].trim()), Integer.parseInt(rgbValues[1].trim()), Integer.parseInt(rgbValues[2].trim()));
            }
            throw new E4CssParseException("RGB", cssValue);
        }
        catch (NumberFormatException | E4CssParseException e) {
            E4ThemeColor.logOnce(e);
            return null;
        }
    }

    public static String getCssValueFromTheme(Display display, String value) {
        BundleContext context = FrameworkUtil.getBundle(E4ThemeColor.class).getBundleContext();
        try {
            CSSValue cssValue;
            CSSStyleDeclaration shellStyle;
            Object themeEngine;
            Object iThemeManager;
            Object reference = MethodUtils.invokeMethod((Object)context, (String)"getServiceReference", (Object)"org.eclipse.e4.ui.css.swt.theme.IThemeManager");
            if (reference != null && (iThemeManager = MethodUtils.invokeMethod((Object)context, (String)"getService", (Object)reference)) != null && (themeEngine = MethodUtils.invokeMethod((Object)iThemeManager, (String)"getEngineForDisplay", (Object)display)) != null && (shellStyle = E4ThemeColor.getStyleDeclaration(themeEngine, display)) != null && (cssValue = shellStyle.getPropertyCSSValue(value)) != null) {
                return cssValue.getCssText();
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            E4ThemeColor.logOnce(e);
            return null;
        }
        return null;
    }

    private static CSSStyleDeclaration getStyleDeclaration(Object themeEngine, Display display) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Shell shell = display.getActiveShell();
        CSSStyleDeclaration shellStyle = null;
        if (shell != null) {
            shellStyle = E4ThemeColor.retrieveStyleFromShell(themeEngine, shell);
        } else {
            Shell[] shellArray = display.getShells();
            int n = shellArray.length;
            int n2 = 0;
            while (n2 < n) {
                Shell input = shellArray[n2];
                shellStyle = E4ThemeColor.retrieveStyleFromShell(themeEngine, input);
                if (shellStyle != null) break;
                ++n2;
            }
        }
        return shellStyle;
    }

    private static CSSStyleDeclaration retrieveStyleFromShell(Object themeEngine, Shell shell) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object shellStyle = MethodUtils.invokeMethod((Object)themeEngine, (String)"getStyle", (Object)shell);
        if (shellStyle instanceof CSSStyleDeclaration) {
            return (CSSStyleDeclaration)shellStyle;
        }
        return null;
    }

    private static void logOnce(Exception e) {
        if (!loggedError) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.commons.ui", e.getMessage(), (Throwable)e));
            loggedError = true;
        }
    }
}

