/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.api.services;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.api.helper.graphicalfilters.HideFilterHelper;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.business.internal.helper.task.operations.CreateViewTask;
import org.eclipse.sirius.diagram.business.internal.metamodel.spec.DNodeContainerSpec;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.tool.CreateView;
import org.eclipse.sirius.diagram.description.tool.ToolFactory;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.FeatureNotFoundException;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.MetaClassNotFoundException;
import org.eclipse.sirius.tools.api.command.CommandContext;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.uml2.uml.Artifact;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Deployment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EncapsulatedClassifier;
import org.eclipse.uml2.uml.ExecutionEnvironment;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.Manifestation;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UseCase;
import org.obeonetwork.dsl.uml2.design.UMLDesignerPlugin;
import org.obeonetwork.dsl.uml2.design.api.utils.UmlUtils;
import org.obeonetwork.dsl.uml2.design.internal.services.ElementServices;
import org.obeonetwork.dsl.uml2.design.internal.services.LabelServices;
import org.obeonetwork.dsl.uml2.design.internal.services.ReconnectPreconditionSwitch;
import org.obeonetwork.dsl.uml2.design.internal.services.ReconnectSwitch;
import org.obeonetwork.dsl.uml2.design.internal.services.RelatedServices;
import org.obeonetwork.dsl.uml2.design.internal.services.SemanticElementsSwitch;
import org.obeonetwork.dsl.uml2.design.internal.services.StereotypeServices;
import org.obeonetwork.dsl.uml2.design.internal.services.UIServices;
import org.obeonetwork.dsl.uml2.design.internal.wizards.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDiagramServices {
    public String computeDefaultName(EObject element) {
        return LabelServices.INSTANCE.computeDefaultName(element);
    }

    public String computeUmlLabel(Element element) {
        return LabelServices.INSTANCE.computeUmlLabel(element);
    }

    protected void createView(final EObject semanticElement, final DSemanticDecorator containerView, final Session session, String containerViewExpression) {
        List<DiagramElementMapping> semanticElementMappings = this.getMappings(semanticElement, containerView, session);
        final CreateView createViewOp = ToolFactory.eINSTANCE.createCreateView();
        Iterator<DiagramElementMapping> iterator = semanticElementMappings.iterator();
        while (iterator.hasNext()) {
            DiagramElementMapping semanticElementMapping;
            DiagramElementMapping tmpSemanticElementMapping = semanticElementMapping = iterator.next();
            createViewOp.setMapping(tmpSemanticElementMapping);
            createViewOp.setContainerViewExpression(containerViewExpression);
            session.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(session.getTransactionalEditingDomain()){

                protected void doExecute() {
                    try {
                        DRepresentation representation = null;
                        if (containerView instanceof DRepresentation) {
                            representation = (DRepresentation)containerView;
                        } else if (containerView instanceof DDiagramElement) {
                            representation = ((DDiagramElement)containerView).getParentDiagram();
                        }
                        CommandContext context = new CommandContext(semanticElement, representation);
                        CreateViewTask task = new CreateViewTask(context, session.getModelAccessor(), createViewOp, session.getInterpreter());
                        task.execute();
                        Object createdView = session.getInterpreter().getVariable(createViewOp.getVariableName());
                        if (createdView instanceof DDiagramElement) {
                            DDiagramElement element = (DDiagramElement)createdView;
                            HideFilterHelper.INSTANCE.reveal(element);
                        }
                    }
                    catch (MetaClassNotFoundException e) {
                        UMLDesignerPlugin.log(4, NLS.bind((String)Messages.UmlModelWizard_UI_ErrorMsg_BadFileExtension, (Object)semanticElement), e);
                    }
                    catch (FeatureNotFoundException e) {
                        UMLDesignerPlugin.log(4, NLS.bind((String)Messages.UmlModelWizard_UI_ErrorMsg_BadFileExtension, (Object)semanticElement), e);
                    }
                }
            });
        }
    }

    public int defaultHeight(EObject any) {
        return UIServices.INSTANCE.defaultHeight();
    }

    public int defaultWidth(EObject any) {
        return UIServices.INSTANCE.defaultWidth();
    }

    public boolean dependencyCreationCompletePrecondition(Element preTarget) {
        return preTarget instanceof NamedElement;
    }

    public boolean dependencyCreationStartPrecondition(Element preSource) {
        return preSource instanceof NamedElement;
    }

    public void destroy(EObject semanticElement) {
        UmlUtils.INSTANCE.destroy(semanticElement);
    }

    private void drop(Element newContainer, Element semanticElement, DSemanticDecorator containerView, boolean moveSemanticElement) {
        Session session = SessionManager.INSTANCE.getSession((EObject)newContainer);
        Element oldContainer = semanticElement.getOwner();
        if (moveSemanticElement && oldContainer != newContainer) {
            ArrayList stereotypesToApply = Lists.newArrayList();
            for (Stereotype stereotype : semanticElement.getAppliedStereotypes()) {
                stereotypesToApply.add(stereotype);
            }
            TransactionalEditingDomain domain = session.getTransactionalEditingDomain();
            Command cmd = AddCommand.create((EditingDomain)domain, (Object)newContainer, null, (Object)semanticElement);
            if (cmd.canExecute()) {
                cmd.execute();
            }
            if ((cmd = RemoveCommand.create((EditingDomain)domain, (Object)oldContainer, null, (Object)semanticElement)).canExecute()) {
                cmd.execute();
            }
            if (semanticElement instanceof UseCase) {
                cmd = SetCommand.create((EditingDomain)domain, (Object)semanticElement, (Object)UMLPackage.Literals.USE_CASE__SUBJECT, (Object)SetCommand.UNSET_VALUE);
                if (cmd.canExecute()) {
                    cmd.execute();
                }
                ArrayList<Element> subjects = new ArrayList<Element>();
                subjects.add(newContainer);
                cmd = SetCommand.create((EditingDomain)domain, (Object)semanticElement, (Object)UMLPackage.Literals.USE_CASE__SUBJECT, subjects);
                if (cmd.canExecute()) {
                    cmd.execute();
                }
            }
            StereotypeServices.INSTANCE.applyAllStereotypes(semanticElement, stereotypesToApply);
            for (Stereotype stereotype : stereotypesToApply) {
                StereotypeServices.INSTANCE.unapplyProfile(oldContainer, stereotype);
            }
        }
        this.showView((EObject)semanticElement, containerView, session, "[self.getContainerView(newContainerView)/]");
    }

    public void dropFromDiagram(Element newContainer, Element semanticElement, DSemanticDecorator containerView) {
        this.drop(newContainer, semanticElement, containerView, true);
    }

    public void dropFromModel(Element newContainer, Element semanticElement, DSemanticDecorator containerView) {
        this.drop(newContainer, semanticElement, containerView, !(containerView instanceof DSemanticDiagram));
    }

    public List<Package> getAllAvailableRootPackages(Element element) {
        ArrayList packages = Lists.newArrayList();
        packages.add(element.getModel());
        packages.addAll(Lists.newArrayList((Iterable)Iterables.filter((Iterable)element.getModel().getImportedPackages(), Model.class)));
        return packages;
    }

    public Collection<Element> getAllRootsInSession(EObject any) {
        return ElementServices.INSTANCE.getAllRootsInSession(any);
    }

    private List<DDiagramElement> getHiddenExistingDiagramElements(EObject semanticElement, DSemanticDecorator containerView) {
        ArrayList existingDiagramElements = Lists.newArrayList();
        if (containerView instanceof DSemanticDiagram) {
            for (DDiagramElement element : ((DSemanticDiagram)containerView).getDiagramElements()) {
                if (!semanticElement.equals(element.getTarget())) continue;
                DDiagramElementQuery query = new DDiagramElementQuery(element);
                if (query.isHidden()) {
                    existingDiagramElements.add(element);
                }
                existingDiagramElements.addAll(this.getHiddenParentContainerViews(element));
            }
        }
        return existingDiagramElements;
    }

    private List<DDiagramElement> getHiddenParentContainerViews(DDiagramElement diagramElement) {
        ArrayList containerViews = Lists.newArrayList();
        EObject containerView = diagramElement.eContainer();
        while (!(containerView instanceof DDiagram) && containerView instanceof DDiagramElement) {
            DDiagramElementQuery query = new DDiagramElementQuery((DDiagramElement)containerView);
            if (query.isHidden()) {
                containerViews.add((DDiagramElement)containerView);
            }
            containerView = containerView.eContainer();
        }
        return containerViews;
    }

    protected List<DiagramElementMapping> getMappings(DSemanticDecorator containerView, Session session) {
        ArrayList<DiagramElementMapping> mappings;
        block5: {
            block4: {
                mappings = new ArrayList<DiagramElementMapping>();
                if (!(containerView instanceof DSemanticDiagram)) break block4;
                for (DiagramElementMapping mapping : ((DSemanticDiagram)containerView).getDescription().getAllContainerMappings()) {
                    if (mapping.isCreateElements()) continue;
                    mappings.add(mapping);
                }
                for (DiagramElementMapping mapping : ((DSemanticDiagram)containerView).getDescription().getAllNodeMappings()) {
                    if (mapping.isCreateElements()) continue;
                    mappings.add(mapping);
                }
                break block5;
            }
            if (!(containerView instanceof DNodeContainerSpec)) break block5;
            for (DiagramElementMapping mapping : ((DNodeContainerSpec)containerView).getActualMapping().getAllContainerMappings()) {
                if (mapping.isCreateElements()) continue;
                mappings.add(mapping);
            }
            for (DiagramElementMapping mapping : ((DNodeContainerSpec)containerView).getActualMapping().getAllNodeMappings()) {
                if (mapping.isCreateElements()) continue;
                mappings.add(mapping);
            }
        }
        return mappings;
    }

    protected List<DiagramElementMapping> getMappings(EObject semanticElement, DSemanticDecorator containerView, Session session) {
        ArrayList<DiagramElementMapping> mappings;
        block5: {
            String domainClass;
            ModelAccessor modelAccessor;
            block4: {
                String domainClass2;
                modelAccessor = session.getModelAccessor();
                mappings = new ArrayList<DiagramElementMapping>();
                if (!(containerView instanceof DSemanticDiagram)) break block4;
                for (DiagramElementMapping mapping : ((DSemanticDiagram)containerView).getDescription().getAllContainerMappings()) {
                    domainClass2 = ((AbstractNodeMapping)mapping).getDomainClass();
                    if (!modelAccessor.eInstanceOf(semanticElement, domainClass2) || mapping.isCreateElements()) continue;
                    mappings.add(mapping);
                }
                for (DiagramElementMapping mapping : ((DSemanticDiagram)containerView).getDescription().getAllNodeMappings()) {
                    domainClass2 = ((AbstractNodeMapping)mapping).getDomainClass();
                    if (!modelAccessor.eInstanceOf(semanticElement, domainClass2) || mapping.isCreateElements()) continue;
                    mappings.add(mapping);
                }
                break block5;
            }
            if (!(containerView instanceof DNodeContainerSpec)) break block5;
            for (DiagramElementMapping mapping : ((DNodeContainerSpec)containerView).getActualMapping().getAllContainerMappings()) {
                domainClass = ((AbstractNodeMapping)mapping).getDomainClass();
                if (!modelAccessor.eInstanceOf(semanticElement, domainClass) || mapping.isCreateElements()) continue;
                mappings.add(mapping);
            }
            for (DiagramElementMapping mapping : ((DNodeContainerSpec)containerView).getActualMapping().getAllNodeMappings()) {
                domainClass = ((AbstractNodeMapping)mapping).getDomainClass();
                if (!modelAccessor.eInstanceOf(semanticElement, domainClass) || mapping.isCreateElements()) continue;
                mappings.add(mapping);
            }
        }
        return mappings;
    }

    public Collection<EObject> getRelated(EObject cur) {
        return RelatedServices.INSTANCE.getRelated(cur);
    }

    public Collection<EObject> getSemanticElements(EObject e) {
        return new SemanticElementsSwitch().getSemanticElements(e);
    }

    public boolean inactive(Element element) {
        return false;
    }

    public boolean isRelated(EObject toFilter, EObject context) {
        boolean res = false;
        if (toFilter.equals(context)) {
            res = true;
        } else if (context instanceof Classifier) {
            if (toFilter instanceof Generalization) {
                res = ((Classifier)context).getGeneralizations().contains((Object)toFilter) || ((Generalization)toFilter).getGeneral() == context;
            } else if (toFilter instanceof InterfaceRealization && context instanceof Class) {
                res = ((Class)context).getInterfaceRealizations().contains((Object)toFilter) || ((InterfaceRealization)toFilter).getContract() == context;
            } else if (toFilter instanceof Association) {
                res = ((Classifier)context).getAssociations().contains((Object)toFilter);
            } else if (toFilter instanceof Artifact && context instanceof ExecutionEnvironment) {
                for (Deployment deployment : ((ExecutionEnvironment)context).getDeployments()) {
                    if (!deployment.getSuppliers().contains((Object)toFilter)) continue;
                    res = true;
                }
            } else if (toFilter instanceof ExecutionEnvironment && context instanceof Artifact) {
                for (Deployment deployment : ((ExecutionEnvironment)toFilter).getDeployments()) {
                    if (!deployment.getSuppliers().contains((Object)context)) continue;
                    res = true;
                }
            } else if (toFilter instanceof PackageableElement && context instanceof Artifact) {
                res = ((Artifact)context).getManifestations().contains((Object)toFilter);
                for (Manifestation manifestation : ((Artifact)context).getManifestations()) {
                    if (!manifestation.getTargets().contains((Object)toFilter)) continue;
                    res = true;
                }
            } else if (toFilter instanceof Artifact && context instanceof PackageableElement) {
                res = ((Artifact)toFilter).getManifestations().contains((Object)context);
                for (Manifestation manifestation : ((Artifact)toFilter).getManifestations()) {
                    if (!manifestation.getTargets().contains((Object)context)) continue;
                    res = true;
                }
            } else if (toFilter instanceof Feature) {
                res = this.isRelated(toFilter.eContainer(), context);
            } else if (toFilter instanceof Classifier) {
                if (context == toFilter) {
                    return false;
                }
                boolean bl = res = context == toFilter;
                if (context instanceof EncapsulatedClassifier && toFilter instanceof EncapsulatedClassifier && !res) {
                    if (((EncapsulatedClassifier)context).getOwnedElements().contains((Object)toFilter)) {
                        res = true;
                    } else {
                        for (Port portContext : ((EncapsulatedClassifier)context).getOwnedPorts()) {
                            if (!this.portIsRelated(toFilter, portContext)) continue;
                            res = true;
                            break;
                        }
                    }
                }
                if (context instanceof EncapsulatedClassifier && toFilter instanceof Property && !res && ((EncapsulatedClassifier)context).getOwnedAttributes().contains((Object)toFilter)) {
                    res = true;
                }
                if (!res) {
                    for (Generalization generalization : ((Classifier)context).getGeneralizations()) {
                        if (generalization.getGeneral() != toFilter) continue;
                        res = true;
                        break;
                    }
                }
                if (!res) {
                    for (Generalization generalization : ((Classifier)toFilter).getGeneralizations()) {
                        if (generalization.getGeneral() != context) continue;
                        res = true;
                        break;
                    }
                }
                if (toFilter instanceof NamedElement && context instanceof NamedElement && !res) {
                    for (Dependency dependency : ((NamedElement)context).getClientDependencies()) {
                        if (!dependency.getClients().contains((Object)toFilter) && !dependency.getSuppliers().contains((Object)toFilter)) continue;
                        res = true;
                        break;
                    }
                }
                if (context instanceof NamedElement && toFilter instanceof NamedElement && !res) {
                    for (Dependency dependency : ((NamedElement)toFilter).getClientDependencies()) {
                        if (!dependency.getClients().contains((Object)context) && !dependency.getSuppliers().contains((Object)context)) continue;
                        res = true;
                        break;
                    }
                }
                if (toFilter instanceof Interface && context instanceof Class && !res) {
                    for (InterfaceRealization realization : ((Class)context).getInterfaceRealizations()) {
                        if (realization.getContract() != toFilter) continue;
                        res = true;
                        break;
                    }
                }
                if (context instanceof Interface && toFilter instanceof Class && !res) {
                    for (InterfaceRealization realization : ((Class)toFilter).getInterfaceRealizations()) {
                        if (realization.getContract() != context) continue;
                        res = true;
                        break;
                    }
                }
                if (!res) {
                    EList toFilterAsso = ((Classifier)toFilter).getAssociations();
                    EList contextAsso = ((Classifier)context).getAssociations();
                    for (Association association : toFilterAsso) {
                        if (!contextAsso.contains(association)) continue;
                        res = true;
                        break;
                    }
                }
            } else if (toFilter instanceof Package) {
                for (EObject content : toFilter.eContents()) {
                    if (!this.isRelated(content, context)) continue;
                    res = true;
                    break;
                }
            }
        } else if (context instanceof Package) {
            if (toFilter instanceof Package) {
                res = ((Package)context).getNestedPackages().contains((Object)toFilter) || ((Package)context).getImportedPackages().contains((Object)toFilter);
                for (PackageImport packageImport : ((Package)context).getPackageImports()) {
                    if (!packageImport.getImportedPackage().equals(toFilter)) continue;
                    res = true;
                }
            } else {
                res = ((Package)context).getOwnedElements().contains((Object)toFilter);
            }
        } else if (context instanceof Port) {
            res = this.portIsRelated(toFilter, (Port)context);
        }
        return res;
    }

    public boolean isRelated(EObject toFilter, List<EObject> context) {
        boolean related = false;
        for (EObject eObject : context) {
            related = this.isRelated(toFilter, eObject);
            if (related) break;
        }
        return related;
    }

    public boolean isSameType(EObject source, EObject target) {
        return source.eClass().equals(target.eClass());
    }

    public boolean isValidElementForContainerView(Element container, Element semanticElement, DSemanticDecorator containerView) {
        Session session = SessionManager.INSTANCE.getSession((EObject)container);
        List<DiagramElementMapping> semanticElementMappings = this.getMappings((EObject)semanticElement, containerView, session);
        return semanticElementMappings.size() > 0;
    }

    public EObject markForAutosize(EObject any) {
        return UIServices.INSTANCE.markForAutosize(any);
    }

    private boolean portIsRelated(EObject toFilter, Port portContext) {
        block5: {
            block4: {
                if (portContext == toFilter) {
                    return false;
                }
                if (!(toFilter instanceof Port)) break block4;
                EList ends = portContext.getEnds();
                for (ConnectorEnd portEnd : ends) {
                    EObject eContainer = portEnd.eContainer();
                    if (!(eContainer instanceof Connector)) continue;
                    Connector connector = (Connector)eContainer;
                    EList connectorEnds = connector.getEnds();
                    for (ConnectorEnd connectorEnd : connectorEnds) {
                        if (connectorEnd.getRole() == null || !connectorEnd.getRole().equals(toFilter)) continue;
                        return true;
                    }
                }
                break block5;
            }
            if (!(toFilter instanceof EncapsulatedClassifier)) break block5;
            EList ownedPortsToFilter = ((EncapsulatedClassifier)toFilter).getOwnedPorts();
            for (Port portToFilter : ownedPortsToFilter) {
                if (!this.portIsRelated((EObject)portToFilter, portContext)) continue;
                return true;
            }
        }
        return false;
    }

    public Element reconnectEdge(Element context, DEdge edgeView, EdgeTarget sourceView, EdgeTarget targetView, Element source, Element target) {
        ReconnectSwitch reconnectService = new ReconnectSwitch();
        if (edgeView.getSourceNode().equals(targetView)) {
            reconnectService.setReconnectKind(0);
        } else {
            reconnectService.setReconnectKind(1);
        }
        reconnectService.setOldPointedElement(source);
        reconnectService.setNewPointedElement(target);
        return (Element)reconnectService.doSwitch((EObject)context);
    }

    public boolean reconnectSourcePrecondition(Element context, Element source, Element target) {
        ReconnectPreconditionSwitch reconnectPreconditionService = new ReconnectPreconditionSwitch();
        reconnectPreconditionService.setReconnectKind(0);
        reconnectPreconditionService.setNewPointedElement(target);
        reconnectPreconditionService.setOldPointedElement(source);
        return reconnectPreconditionService.isReconnectable(context);
    }

    public boolean reconnectTargetPrecondition(Element context, Element source, Element target) {
        ReconnectPreconditionSwitch reconnectPreconditionService = new ReconnectPreconditionSwitch();
        reconnectPreconditionService.setReconnectKind(1);
        reconnectPreconditionService.setNewPointedElement(target);
        reconnectPreconditionService.setOldPointedElement(source);
        return reconnectPreconditionService.isReconnectable(context);
    }

    protected void showView(EObject semanticElement, DSemanticDecorator containerView, Session session, String containerViewExpression) {
        List<DDiagramElement> hiddenDiagramElements = this.getHiddenExistingDiagramElements(semanticElement, containerView);
        if (!hiddenDiagramElements.isEmpty()) {
            for (DDiagramElement existingDiagramElement : hiddenDiagramElements) {
                HideFilterHelper.INSTANCE.reveal(existingDiagramElement);
            }
        } else {
            this.createView(semanticElement, containerView, session, containerViewExpression);
        }
    }
}

