/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.api.services;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.uml2.uml.AcceptEventAction;
import org.eclipse.uml2.uml.Action;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityGroup;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ActivityParameterNode;
import org.eclipse.uml2.uml.ActivityPartition;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.CallAction;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.CallOperationAction;
import org.eclipse.uml2.uml.ControlFlow;
import org.eclipse.uml2.uml.DataStoreNode;
import org.eclipse.uml2.uml.DecisionNode;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.FinalNode;
import org.eclipse.uml2.uml.ForkNode;
import org.eclipse.uml2.uml.InitialNode;
import org.eclipse.uml2.uml.InputPin;
import org.eclipse.uml2.uml.InterruptibleActivityRegion;
import org.eclipse.uml2.uml.InvocationAction;
import org.eclipse.uml2.uml.JoinNode;
import org.eclipse.uml2.uml.MergeNode;
import org.eclipse.uml2.uml.ObjectFlow;
import org.eclipse.uml2.uml.OpaqueAction;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.OutputPin;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Pin;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.TimeEvent;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.obeonetwork.dsl.uml2.design.api.services.AbstractDiagramServices;
import org.obeonetwork.dsl.uml2.design.internal.wizards.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityDiagramServices
extends AbstractDiagramServices {
    public InputPin createInputPin(Action context) {
        InputPin pin = UMLFactory.eINSTANCE.createInputPin();
        pin.setName("Input_" + context.getInputs().size());
        if (context instanceof InvocationAction) {
            ((InvocationAction)context).getArguments().add((Object)pin);
        } else if (context instanceof OpaqueAction) {
            ((OpaqueAction)context).getInputValues().add((Object)pin);
        } else {
            throw new UnsupportedOperationException("Can't create InputPin for context of type: " + context.eClass().getName());
        }
        return pin;
    }

    public Pin createInputPinFromParameter(CallAction action, Parameter parameter) {
        InputPin pin = UMLFactory.eINSTANCE.createInputPin();
        action.getArguments().add((Object)pin);
        this.setPinAttributes(parameter, (Pin)pin);
        return null;
    }

    public OutputPin createOutputPin(Action context) {
        OutputPin pin = UMLFactory.eINSTANCE.createOutputPin();
        pin.setName("Output_" + context.getOutputs().size());
        if (context instanceof CallAction) {
            ((CallAction)context).getResults().add((Object)pin);
        } else if (context instanceof OpaqueAction) {
            ((OpaqueAction)context).getOutputValues().add((Object)pin);
        } else {
            throw new UnsupportedOperationException("Can't create InputPin for context of type: " + context.eClass().getName());
        }
        return pin;
    }

    public Pin createOutputPinFromParameter(CallAction action, Parameter parameter) {
        OutputPin pin = UMLFactory.eINSTANCE.createOutputPin();
        action.getResults().add((Object)pin);
        this.setPinAttributes(parameter, (Pin)pin);
        return null;
    }

    private ActivityNode dropNode(Element context, ActivityNode node, Element oldContext) {
        if (oldContext instanceof ActivityPartition) {
            node.getInPartitions().remove((Object)oldContext);
        } else if (oldContext instanceof InterruptibleActivityRegion) {
            node.getInInterruptibleRegions().remove((Object)oldContext);
        }
        if (context instanceof ActivityPartition) {
            node.getInPartitions().add((Object)((ActivityPartition)context));
        } else if (context instanceof InterruptibleActivityRegion) {
            node.getInInterruptibleRegions().add((Object)((InterruptibleActivityRegion)context));
        }
        return node;
    }

    private ActivityPartition dropNode(Element context, ActivityPartition partition, Element oldContext) {
        if (context instanceof Activity) {
            ((Activity)context).getPartitions().add((Object)partition);
        } else if (context instanceof ActivityPartition) {
            ((ActivityPartition)context).getSubpartitions().add((Object)partition);
        }
        return partition;
    }

    public Element dropNode(Element context, Element node, Element oldContext) {
        if (node instanceof ActivityNode) {
            return this.dropNode(context, (ActivityNode)node, oldContext);
        }
        if (node instanceof ActivityPartition) {
            return this.dropNode(context, (ActivityPartition)node, oldContext);
        }
        if (node instanceof InterruptibleActivityRegion) {
            return this.dropNode(context, (InterruptibleActivityRegion)node, oldContext);
        }
        return null;
    }

    private InterruptibleActivityRegion dropNode(Element context, InterruptibleActivityRegion interruptRegion, Element oldContext) {
        if (context instanceof Activity) {
            ((Activity)context).getOwnedGroups().add((Object)interruptRegion);
        }
        return interruptRegion;
    }

    public Activity findParentActivity(Element context) {
        if (context instanceof Activity) {
            return (Activity)context;
        }
        if (context.eContainer() != null) {
            return this.findParentActivity((Element)context.eContainer());
        }
        return null;
    }

    public List<ActivityNode> getAcceptEventActions(Element context) {
        List<ActivityNode> allActivityNodes = this.getActivityNodes(context);
        ArrayList<ActivityNode> childNodes = new ArrayList<ActivityNode>(allActivityNodes);
        for (ActivityNode activityNode : allActivityNodes) {
            if (activityNode instanceof AcceptEventAction) continue;
            childNodes.remove(activityNode);
        }
        return childNodes;
    }

    private List<ActivityNode> getActivityNodes(Element context) {
        Object childNodes;
        if (context instanceof Activity) {
            EList allActivityNodes = ((Activity)context).getOwnedNodes();
            childNodes = new ArrayList(allActivityNodes);
            for (ActivityNode activityNode : allActivityNodes) {
                if (activityNode.getInPartitions().size() > 0) {
                    for (ActivityPartition partition : activityNode.getInPartitions()) {
                        childNodes.removeAll((Collection<?>)partition.getNodes());
                    }
                }
                if (activityNode.getInInterruptibleRegions().size() <= 0) continue;
                for (InterruptibleActivityRegion interruptRegion : activityNode.getInInterruptibleRegions()) {
                    childNodes.removeAll((Collection<?>)interruptRegion.getNodes());
                }
            }
        } else {
            childNodes = context instanceof ActivityPartition ? ((ActivityPartition)context).getNodes() : (context instanceof InterruptibleActivityRegion ? ((InterruptibleActivityRegion)context).getNodes() : Collections.emptyList());
        }
        return childNodes;
    }

    public EList<ActivityPartition> getActivityPartitions(Element context) {
        if (context instanceof Activity) {
            return ((Activity)context).getPartitions();
        }
        if (context instanceof ActivityPartition) {
            return ((ActivityPartition)context).getSubpartitions();
        }
        return null;
    }

    private List<EObject> getAllBehaviors(Element element) {
        ArrayList behaviors = Lists.newArrayList();
        List<Package> rootPkgs = this.getAllAvailableRootPackages(element);
        for (Package pkg : rootPkgs) {
            Iterators.addAll((Collection)behaviors, (Iterator)Iterators.filter((Iterator)pkg.eAllContents(), (Predicate)Predicates.instanceOf(Behavior.class)));
        }
        return behaviors;
    }

    public List<EObject> getAllBehaviorsAndPackages(Element element) {
        ArrayList results = Lists.newArrayList();
        List<EObject> behaviors = this.getAllBehaviors(element);
        for (EObject eObject : behaviors) {
            while (eObject.eContainer() != null) {
                results.add(eObject.eContainer());
                eObject = eObject.eContainer();
            }
        }
        results.addAll(behaviors);
        return results;
    }

    private List<EObject> getAllOperations(Element element) {
        ArrayList operations = Lists.newArrayList();
        List<Package> rootPkgs = this.getAllAvailableRootPackages(element);
        Predicate<EObject> predicate = new Predicate<EObject>(){

            public boolean apply(EObject eObj) {
                return eObj instanceof Operation && (((Operation)eObj).getMethods() == null || ((Operation)eObj).getMethods().size() == 0);
            }
        };
        for (Package pkg : rootPkgs) {
            Iterators.addAll((Collection)operations, (Iterator)Iterators.filter((Iterator)pkg.eAllContents(), (Predicate)predicate));
        }
        return operations;
    }

    public List<EObject> getAllOperationsAndPackages(Element eObj) {
        ArrayList results = Lists.newArrayList();
        List<EObject> operations = this.getAllOperations(eObj);
        for (EObject eObject : operations) {
            while (eObject.eContainer() != null) {
                results.add(eObject.eContainer());
                eObject = eObject.eContainer();
            }
        }
        results.addAll(operations);
        return results;
    }

    public List<EObject> getAllSignals(Element element) {
        ArrayList signals = Lists.newArrayList();
        List<Package> rootPkgs = this.getAllAvailableRootPackages(element);
        for (Package pkg : rootPkgs) {
            Iterators.addAll((Collection)signals, (Iterator)Iterators.filter((Iterator)pkg.eAllContents(), (Predicate)Predicates.instanceOf(Signal.class)));
        }
        return signals;
    }

    public String getCallOperationConsistencyErrorMessage(CallOperationAction callOperationAction) {
        String message = "";
        Operation operation = callOperationAction.getOperation();
        for (Parameter param : operation.getOwnedParameters()) {
            OutputPin outputPin;
            Object[] params;
            InputPin pin;
            if (ParameterDirectionKind.IN_LITERAL.equals((Object)param.getDirection())) {
                pin = callOperationAction.getArgument(param.getName(), param.getType());
                if (pin != null) continue;
                params = new Object[]{callOperationAction.getQualifiedName(), param.getName(), operation.getQualifiedName()};
                message = NLS.bind((String)Messages.UmlValidationErrorOnCallOperationAction2, (Object[])params);
                continue;
            }
            if (ParameterDirectionKind.OUT_LITERAL.equals((Object)param.getDirection()) || ParameterDirectionKind.RETURN_LITERAL.equals((Object)param.getDirection())) {
                pin = callOperationAction.getResult(param.getName(), param.getType());
                if (pin != null) continue;
                params = new Object[]{callOperationAction.getQualifiedName(), param.getName(), operation.getQualifiedName()};
                message = NLS.bind((String)Messages.UmlValidationErrorOnCallOperationAction2, (Object[])params);
                continue;
            }
            InputPin inputPin = callOperationAction.getArgument(param.getName(), param.getType());
            if (inputPin == null) {
                params = new Object[]{callOperationAction.getQualifiedName(), param.getName(), operation.getQualifiedName()};
                message = NLS.bind((String)Messages.UmlValidationErrorOnCallOperationAction2, (Object[])params);
            }
            if ((outputPin = callOperationAction.getResult(param.getName(), param.getType())) != null) continue;
            Object[] params2 = new Object[]{callOperationAction.getQualifiedName(), param.getName(), operation.getQualifiedName()};
            message = NLS.bind((String)Messages.UmlValidationErrorOnCallOperationAction2, (Object[])params2);
        }
        return message;
    }

    public String getCallOperationPinConsistencyErrorMessage(Pin pin) {
        CallAction callAction;
        String message = "";
        String pinName = pin.getName();
        Type pinType = pin.getType();
        EObject container = pin.eContainer();
        if (container instanceof CallAction && (callAction = (CallAction)container) instanceof CallOperationAction) {
            CallOperationAction callOperationAction = (CallOperationAction)callAction;
            Operation operation = callOperationAction.getOperation();
            Parameter param = operation.getOwnedParameter(pinName, pinType);
            if (param == null && !"target".equals(pinName)) {
                Object[] params = new Object[]{callAction.getQualifiedName(), pinName, operation.getQualifiedName()};
                message = NLS.bind((String)Messages.UmlValidationErrorOnCallOperationAction, (Object[])params);
            } else if (param != null) {
                if (!param.getName().equals(pin.getName())) {
                    Object[] params = new Object[]{callAction.getQualifiedName(), pinName, "name"};
                    message = NLS.bind((String)Messages.UmlValidationErrorOnCallOperationActionPin, (Object[])params);
                } else if (!param.getType().equals(pin.getType())) {
                    Object[] params = new Object[]{callAction.getQualifiedName(), pinName, "type"};
                    message = NLS.bind((String)Messages.UmlValidationErrorOnCallOperationActionPin, (Object[])params);
                } else if (param.isOrdered() != pin.isOrdered()) {
                    Object[] params = new Object[]{callAction.getQualifiedName(), pinName, "ordered"};
                    message = NLS.bind((String)Messages.UmlValidationErrorOnCallOperationActionPin, (Object[])params);
                } else if (param.getLowerValue() == null && pin.getLowerValue() != null || param.getLowerValue() != null && pin.getLowerValue() == null || (param.getLowerValue() != null || pin.getLowerValue() != null) && !param.getLowerValue().stringValue().equals(pin.getLowerValue().stringValue())) {
                    Object[] params = new Object[]{callAction.getQualifiedName(), pinName, "lower value"};
                    message = NLS.bind((String)Messages.UmlValidationErrorOnCallOperationActionPin, (Object[])params);
                } else if (param.getUpperValue() == null && pin.getUpperValue() != null || param.getUpperValue() != null && pin.getUpperValue() == null || (param.getUpperValue() != null || pin.getUpperValue() != null) && !param.getUpperValue().stringValue().equals(pin.getUpperValue().stringValue())) {
                    Object[] params = new Object[]{callAction.getQualifiedName(), pinName, "upper value"};
                    message = NLS.bind((String)Messages.UmlValidationErrorOnCallOperationActionPin, (Object[])params);
                }
            }
        }
        return message;
    }

    public List<ActivityNode> getExecutableNodes(Element context) {
        List<ActivityNode> allActivityNodes = this.getActivityNodes(context);
        ArrayList<ActivityNode> childNodes = new ArrayList<ActivityNode>(allActivityNodes);
        for (ActivityNode activityNode : allActivityNodes) {
            if (!(activityNode instanceof AcceptEventAction)) continue;
            childNodes.remove(activityNode);
        }
        return childNodes;
    }

    public List<Parameter> getInputParameters(Operation operation) {
        return operation.inputParameters();
    }

    public List<InterruptibleActivityRegion> getInterruptibleActivityRegions(Element context) {
        ArrayList interruptibleRegions = Lists.newArrayList();
        if (context instanceof Activity) {
            for (ActivityGroup group : ((Activity)context).getOwnedGroups()) {
                if (!(group instanceof InterruptibleActivityRegion)) continue;
                interruptibleRegions.add((InterruptibleActivityRegion)group);
            }
        }
        return interruptibleRegions;
    }

    public InterruptibleActivityRegion getInterruptibleRegion(ActivityNode node) {
        return (InterruptibleActivityRegion)node.getInInterruptibleRegions().get(0);
    }

    public List<Parameter> getOutputParameters(Operation operation) {
        return operation.outputParameters();
    }

    public boolean isAcceptCallAction(AcceptEventAction action) {
        Trigger trigger;
        return action != null && action.getTriggers() != null && action.getTriggers().size() == 1 && (trigger = (Trigger)action.getTriggers().get(0)).getEvent() != null && trigger.getEvent() instanceof CallEvent;
    }

    public boolean isAcceptSignalAction(AcceptEventAction action) {
        Trigger trigger;
        return action != null && action.getTriggers() != null && action.getTriggers().size() == 1 && (trigger = (Trigger)action.getTriggers().get(0)).getEvent() != null && trigger.getEvent() instanceof SignalEvent;
    }

    public boolean isConsistent(CallOperationAction callOperationAction) {
        return !this.isNotConsistent(callOperationAction);
    }

    public boolean isConsistent(Pin pin) {
        return !this.isNotConsistent(pin);
    }

    public boolean isNotConsistent(CallOperationAction callOperationAction) {
        return this.getCallOperationConsistencyErrorMessage(callOperationAction).length() > 0;
    }

    public boolean isNotConsistent(Pin pin) {
        return this.getCallOperationPinConsistencyErrorMessage(pin).length() > 0;
    }

    public boolean isValidActivityEdgeEnd(Element source, Element preTarget) {
        return this.isValidFlowEnd(source, preTarget);
    }

    public boolean isValidControlFlowStart(Element preSource) {
        if (preSource instanceof ActivityNode) {
            for (ActivityEdge incoming : ((ActivityNode)preSource).getIncomings()) {
                if (!(incoming instanceof ObjectFlow)) continue;
                return false;
            }
        }
        return this.isValidFlowStart(preSource);
    }

    private boolean isValidFlowEnd(Element source, Element preTarget) {
        EList incomings;
        if (source instanceof InputPin) {
            return false;
        }
        if (source instanceof OutputPin && preTarget instanceof OutputPin) {
            return false;
        }
        if (source instanceof ActivityParameterNode && preTarget instanceof OutputPin) {
            return false;
        }
        if (source instanceof DataStoreNode && preTarget instanceof OutputPin) {
            return false;
        }
        if (preTarget instanceof InitialNode) {
            return false;
        }
        if (preTarget instanceof ForkNode && (incomings = ((ForkNode)preTarget).getIncomings()) != null && incomings.size() == 1) {
            return false;
        }
        return !(preTarget instanceof DecisionNode) || (incomings = ((DecisionNode)preTarget).getIncomings()) == null || incomings.size() != 2;
    }

    private boolean isValidFlowStart(Element preSource) {
        EList outgoing;
        if (preSource instanceof FinalNode) {
            return false;
        }
        return !(preSource instanceof JoinNode) && !(preSource instanceof MergeNode) || (outgoing = ((ActivityNode)preSource).getOutgoings()) == null || outgoing.size() != 1;
    }

    public boolean isValidInterruptingEdgeEnd(OpaqueAction preTarget, OpaqueAction source) {
        EList preTargetRegions = preTarget.getInInterruptibleRegions();
        if (preTargetRegions != null) {
            for (InterruptibleActivityRegion sourceRegion : source.getInInterruptibleRegions()) {
                if (!preTargetRegions.contains(sourceRegion)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isValidObjectFlowStart(Element preSource) {
        if (preSource instanceof InitialNode) {
            return false;
        }
        if (preSource instanceof InputPin) {
            return false;
        }
        if (preSource instanceof ActivityNode) {
            for (ActivityEdge incoming : ((ActivityNode)preSource).getIncomings()) {
                if (!(incoming instanceof ControlFlow)) continue;
                return false;
            }
        }
        return this.isValidFlowStart(preSource);
    }

    public boolean isWaitTimeAction(AcceptEventAction action) {
        Trigger trigger;
        return action != null && action.getTriggers() != null && action.getTriggers().size() == 1 && (trigger = (Trigger)action.getTriggers().get(0)).getEvent() != null && trigger.getEvent() instanceof TimeEvent;
    }

    private void setPinAttributes(Parameter parameter, Pin pin) {
        pin.setName(parameter.getName());
        pin.setIsOrdered(parameter.isOrdered());
        pin.setType(parameter.getType());
        pin.setLowerValue(parameter.getLowerValue());
        pin.setUpperValue(parameter.getUpperValue());
    }
}

