/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.api.services;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.AssociationClass;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.obeonetwork.dsl.uml2.design.api.services.AbstractDiagramServices;
import org.obeonetwork.dsl.uml2.design.internal.dialogs.ModelElementSelectionDialog;
import org.obeonetwork.dsl.uml2.design.internal.services.AssociationServices;
import org.obeonetwork.dsl.uml2.design.internal.services.ElementServices;
import org.obeonetwork.dsl.uml2.design.internal.services.LabelServices;
import org.obeonetwork.dsl.uml2.design.internal.services.NodeInverseRefsServices;
import org.obeonetwork.dsl.uml2.design.internal.services.OperationServices;
import org.obeonetwork.dsl.uml2.design.internal.services.StereotypeServices;
import org.obeonetwork.dsl.uml2.design.internal.services.UIServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDiagramServices
extends AbstractDiagramServices {
    public String computeAssociationBeginLabel(Association association) {
        return LabelServices.INSTANCE.computeAssociationBeginLabel(association);
    }

    public String computeAssociationEndLabel(Association association) {
        return LabelServices.INSTANCE.computeAssociationEndLabel(association);
    }

    public Operation createOperation(Type type) {
        return OperationServices.INSTANCE.createOperation(type);
    }

    public Type findTypeByName(Collection<EObject> roots, String typeName) {
        return ElementServices.INSTANCE.findTypeByName(roots, typeName);
    }

    public Type findTypeByName(EObject object, String typeName) {
        return ElementServices.INSTANCE.findTypeByName(object, typeName);
    }

    private void fixAssociation(Association a, Type b) {
        Property target = AssociationServices.INSTANCE.getTarget(a);
        Property source = AssociationServices.INSTANCE.getSource(a);
        Property newOne = UMLFactory.eINSTANCE.createProperty();
        newOne.setUpper(-1);
        newOne.setUpper(0);
        newOne.setType(b);
        if (target == null) {
            a.getOwnedEnds().add((Object)newOne);
        } else if (source == null) {
            a.getOwnedEnds().add((Object)newOne);
        } else if (target.getType() == null) {
            target.setType(b);
        } else if (source.getType() == null) {
            source.setType(b);
        }
    }

    public void fixAssociation(EObject host, EObject a, EObject b) {
        if (a instanceof Association && b instanceof Type) {
            this.fixAssociation((Association)a, (Type)b);
        } else if (b instanceof Association && a instanceof Type) {
            this.fixAssociation((Association)b, (Type)a);
        }
    }

    public Collection<Object> getAllStereotypeApplications(DDiagram diagram) {
        ArrayList results = Lists.newArrayList();
        for (DDiagramElementContainer container : diagram.getContainers()) {
            EObject target = container.getTarget();
            if (!(target instanceof Element)) continue;
            results.addAll(((Element)target).getStereotypeApplications());
        }
        return results;
    }

    public Collection<EObject> getAssociationInverseRefs(DDiagram diagram) {
        return NodeInverseRefsServices.INSTANCE.getAssociationInverseRefs(diagram);
    }

    public Element getBaseClass(EObject stereotypeApplication) {
        return StereotypeServices.INSTANCE.getBaseClass(stereotypeApplication);
    }

    public Collection<Association> getBrokenAssociations(EObject container) {
        ArrayList<Association> result = new ArrayList<Association>();
        for (EObject child : container.eContents()) {
            if (!(child instanceof Association) || child instanceof AssociationClass || !this.isBroken((Association)child)) continue;
            result.add((Association)child);
        }
        return result;
    }

    public Collection<EObject> getDependencyInverseRefs(DDiagram diagram) {
        return NodeInverseRefsServices.INSTANCE.getDependencyInverseRefs(diagram);
    }

    public Collection<EObject> getGeneralizationInverseRefs(DDiagram diagram) {
        return NodeInverseRefsServices.INSTANCE.getGeneralizationInverseRefs(diagram);
    }

    public Collection<EObject> getInterfaceRealizationInverseRefs(DDiagram diagram) {
        return NodeInverseRefsServices.INSTANCE.getInterfaceRealizationInverseRefs(diagram);
    }

    public List<Property> getNavigableOwnedEnds(Association association) {
        ArrayList ends = Lists.newArrayList();
        Property source = AssociationServices.INSTANCE.getSource(association);
        Property target = AssociationServices.INSTANCE.getTarget(association);
        if (source != null) {
            ends.add(source);
        }
        if (target != null) {
            ends.add(target);
        }
        return ends;
    }

    public Collection<Class> getSemanticCandidatesClasses(Element element) {
        HashSet<Class> classes = new HashSet<Class>();
        TreeIterator iterator = element.getModel().eAllContents();
        while (iterator.hasNext()) {
            EObject object = (EObject)iterator.next();
            if (!this.isTypeOfClass(object) && !(object instanceof Component)) continue;
            classes.add((Class)object);
        }
        return classes;
    }

    public Type getSourceType(Association association) {
        return AssociationServices.INSTANCE.getSourceType(association);
    }

    public String getStereotypeApplicationLabel(EObject stereotypeApplication) {
        return stereotypeApplication.eClass().getName();
    }

    public String getTaggedValueLabel(EStructuralFeature feature, DDiagramElement view) {
        DDiagramElement stereotypeApplicationView = (DDiagramElement)view.eContainer();
        EObject stereotypeApplication = stereotypeApplicationView.getTarget();
        return String.valueOf(feature.getName()) + "=" + stereotypeApplication.eGet(feature);
    }

    public Collection<Object> getTaggedValues(EObject stereotypeApplication) {
        ArrayList results = Lists.newArrayList();
        for (EStructuralFeature feature : stereotypeApplication.eClass().getEAllStructuralFeatures()) {
            if (feature.getName().startsWith("base_")) continue;
            results.add(feature);
        }
        return results;
    }

    public Type getTargetType(Association association) {
        return AssociationServices.INSTANCE.getTargetType(association);
    }

    public Collection<EObject> getTemplateBindingInverseRefs(DDiagram diagram) {
        return NodeInverseRefsServices.INSTANCE.getTemplateBindingInverseRefs(diagram);
    }

    public List<Type> getTypes(Association association) {
        return AssociationServices.INSTANCE.getTypes(association);
    }

    public Collection<EObject> getVisibleAssociationClass(DDiagram diagram, EObject container) {
        HashSet<EObject> associationClasses = new HashSet<EObject>();
        Collection<EObject> displayedNodes = UIServices.INSTANCE.getDisplayedNodes(diagram);
        Collection<EObject> associations = this.getAssociationInverseRefs(diagram);
        for (EObject association : associations) {
            if (!(association instanceof AssociationClass)) continue;
            Property source = AssociationServices.INSTANCE.getSource((Association)((AssociationClass)association));
            Property target = AssociationServices.INSTANCE.getTarget((Association)((AssociationClass)association));
            Type sourceType = source.getType();
            Type targetType = target.getType();
            if (sourceType == null || !displayedNodes.contains(sourceType) || targetType == null || !displayedNodes.contains(targetType) || container != association.eContainer()) continue;
            associationClasses.add(association);
        }
        return associationClasses;
    }

    private boolean isArchetypesLayerActive(DDiagramElement diagramElement) {
        DDiagram diagram = diagramElement.getParentDiagram();
        for (Layer activeLayer : diagram.getActivatedLayers()) {
            if (!"Archetypes".equals(activeLayer.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean isBroken(Association child) {
        Property target = AssociationServices.INSTANCE.getTarget(child);
        Property source = AssociationServices.INSTANCE.getSource(child);
        return target == null || target.getType() == null || source == null || source.getType() == null;
    }

    public boolean isClassCreationPrediction(DDiagramElement diagramElement) {
        if (this.isTypeOfClass(diagramElement.getTarget()) && this.isArchetypesLayerActive(diagramElement)) {
            return true;
        }
        return diagramElement.getTarget() instanceof Package && !this.isArchetypesLayerActive(diagramElement);
    }

    public boolean isClassCreationPrediction(DSemanticDiagram diagram) {
        return true;
    }

    private boolean isComposite(Property property) {
        return property != null && property.isComposite();
    }

    private boolean isNavigable(Property property) {
        return property != null && property.isNavigable();
    }

    public boolean isNotTypeOfClass(EObject element) {
        return !this.isTypeOfClass(element);
    }

    public boolean isPackage(EObject element) {
        return element instanceof Package;
    }

    private boolean isShared(Property property) {
        return property != null && AggregationKind.SHARED_LITERAL.equals((Object)property.getAggregation());
    }

    public boolean isStatic(Feature feature) {
        return feature != null && feature.isStatic();
    }

    public boolean isTypeOfClass(EObject element) {
        return "Class".equals(element.eClass().getName());
    }

    public Element openSelectTypeDialog(Element element) {
        Object[] results;
        ModelElementSelectionDialog dlg = new ModelElementSelectionDialog();
        dlg.setTitle("New typed property selection");
        dlg.setMessage("Please select a type for the new property :");
        dlg.setSelectablePredicate((Predicate)new Predicate<Object>(){

            public boolean apply(Object input) {
                return !(input instanceof Stereotype) && (input instanceof Class || input instanceof Interface || input instanceof DataType);
            }
        });
        int status = dlg.open();
        if (status == 0 && (results = dlg.getResult()) != null && results.length > 0) {
            return (Element)results[0];
        }
        return null;
    }

    public boolean sourceIsComposite(Association association) {
        Property source = AssociationServices.INSTANCE.getSource(association);
        return this.isComposite(source);
    }

    public boolean sourceIsNavigable(Association association) {
        Property source = AssociationServices.INSTANCE.getSource(association);
        return this.isNavigable(source);
    }

    public boolean sourceIsNavigableAndComposite(Association association) {
        Property source = AssociationServices.INSTANCE.getSource(association);
        return this.isNavigable(source) && this.isComposite(source);
    }

    public boolean sourceIsNavigableAndShared(Association association) {
        Property source = AssociationServices.INSTANCE.getTarget(association);
        return this.isNavigable(source) && this.isShared(source);
    }

    public boolean sourceIsShared(Association association) {
        Property source = AssociationServices.INSTANCE.getSource(association);
        return this.isShared(source);
    }

    public boolean targetIsComposite(Association association) {
        Property target = AssociationServices.INSTANCE.getTarget(association);
        return this.isComposite(target);
    }

    public boolean targetIsNavigable(Association association) {
        Property target = AssociationServices.INSTANCE.getTarget(association);
        return this.isNavigable(target);
    }

    public boolean targetIsNavigableAndComposite(Association association) {
        Property target = AssociationServices.INSTANCE.getTarget(association);
        return this.isNavigable(target) && this.isComposite(target);
    }

    public boolean targetIsNavigableAndShared(Association association) {
        Property target = AssociationServices.INSTANCE.getTarget(association);
        return this.isNavigable(target) && this.isShared(target);
    }

    public boolean targetIsShared(Association association) {
        Property target = AssociationServices.INSTANCE.getTarget(association);
        return this.isShared(target);
    }
}

