/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.api.services;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.ComponentRealization;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.Usage;
import org.obeonetwork.dsl.uml2.design.api.services.AbstractDiagramServices;
import org.obeonetwork.dsl.uml2.design.internal.services.ConnectorServices;
import org.obeonetwork.dsl.uml2.design.internal.services.ElementServices;
import org.obeonetwork.dsl.uml2.design.internal.services.LogServices;
import org.obeonetwork.dsl.uml2.design.internal.services.NodeInverseRefsServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentDiagramServices
extends AbstractDiagramServices {
    public ComponentRealization createComponentRealization(Classifier realizingClassifier, Component abstraction) {
        ComponentRealization result = abstraction.createRealization(null);
        result.getRealizingClassifiers().add((Object)realizingClassifier);
        return result;
    }

    public Connector createConnector(StructuredClassifier structuredClassifier, NamedElement elem1, NamedElement elem2) {
        return ConnectorServices.INSTANCE.createConnector(structuredClassifier, elem1, elem2);
    }

    public boolean createDependencyConnectionCompletePrecondition(Element preSource, DSemanticDecorator preSourceView, Element preTarget, DSemanticDecorator preTargetView, Element container, DSemanticDiagram diagram) {
        boolean fromClassOrPortToInterface;
        boolean fromInterfaceToClassOrPort = preSource instanceof Interface && (preTarget instanceof Class || preTarget instanceof Port);
        boolean bl = fromClassOrPortToInterface = (preSource instanceof Class || preSource instanceof Port) && preTarget instanceof Interface;
        return fromInterfaceToClassOrPort || fromClassOrPortToInterface;
    }

    public boolean createDependencyConnectionStartPrecondition(Element preSource, DSemanticDecorator preSourceView, Element container, DSemanticDiagram diagram) {
        boolean fromClassOrPort = preSource instanceof Class || preSource instanceof Port;
        boolean fromInterface = preSource instanceof Interface;
        return fromClassOrPort || fromInterface;
    }

    public InterfaceRealization createHelperInterfaceRealization(EObject context, Interface contract) {
        InterfaceRealization result = null;
        if (context instanceof Property) {
            EObject eContainer;
            Port port;
            Type type;
            Property property = (Property)context;
            boolean isPortWithValidType = false;
            if (context instanceof Port && ((Port)context).isConjugated() && (type = (port = (Port)property).getType()) instanceof BehavioredClassifier) {
                isPortWithValidType = true;
                BehavioredClassifier behavioredClassifier = (BehavioredClassifier)type;
                result = behavioredClassifier.createInterfaceRealization(null, contract);
                result.getClients().add((Object)port);
            }
            if (!isPortWithValidType && (eContainer = context.eContainer()) instanceof BehavioredClassifier) {
                BehavioredClassifier behavioredClassifier = (BehavioredClassifier)eContainer;
                result = behavioredClassifier.createInterfaceRealization(null, contract);
                result.getClients().add((Object)property);
            }
        } else if (context instanceof BehavioredClassifier) {
            BehavioredClassifier behavioredClassifier = (BehavioredClassifier)context;
            result = behavioredClassifier.createInterfaceRealization(null, contract);
        } else {
            LogServices.INSTANCE.error("CompositeStructureServices.createInterfaceRealization(" + context.getClass() + ") not handled", null);
        }
        return result;
    }

    public Usage createHelperUsage(EObject context, Interface contract) {
        Usage result = null;
        if (context instanceof Property) {
            EObject eContainer;
            Property property = (Property)context;
            boolean isPortWithValidType = false;
            if (context instanceof Port && ((Port)context).isConjugated()) {
                Port port = (Port)property;
                Type type = port.getType();
                isPortWithValidType = true;
                Type namedElement = type;
                result = namedElement.createUsage((NamedElement)contract);
                result.getClients().add((Object)port);
            }
            if (!isPortWithValidType && (eContainer = context.eContainer()) instanceof NamedElement) {
                NamedElement namedElement = (NamedElement)eContainer;
                result = namedElement.createUsage((NamedElement)contract);
                result.getClients().add((Object)property);
            }
        } else if (context instanceof NamedElement) {
            NamedElement namedElement = (NamedElement)context;
            result = namedElement.createUsage((NamedElement)contract);
        } else {
            LogServices.INSTANCE.error("CompositeStructureServices.createUsage(" + context.getClass() + ") not handled", null);
        }
        return result;
    }

    public List<NamedElement> getClient(Dependency dependency) {
        ArrayList<NamedElement> result = new ArrayList<NamedElement>();
        ArrayList clients = Lists.newArrayList((Iterable)Iterables.filter((Iterable)dependency.getClients(), (Predicate)new Predicate<EObject>(){

            public boolean apply(EObject input) {
                return !(input instanceof Connector);
            }
        }));
        if (clients.size() == 1) {
            result.addAll(clients);
            return result;
        }
        for (NamedElement client : clients) {
            if (!(client instanceof Property)) continue;
            Property property = (Property)client;
            if (property instanceof Port) {
                Port port = (Port)property;
                if (port.getType() != null) {
                    if (port.eContainer() instanceof StructuredClassifier && port.getType().equals(port.eContainer())) {
                        result.add((NamedElement)port.getType());
                        continue;
                    }
                    if (port.isConjugated()) {
                        result.add((NamedElement)port);
                        result.add((NamedElement)port.getType());
                        continue;
                    }
                    result.add((NamedElement)port);
                    continue;
                }
                result.add((NamedElement)port);
                continue;
            }
            result.add((NamedElement)property);
        }
        return result;
    }

    public Collection<EObject> getComponentRealizationInverseRefs(DDiagram diagram) {
        return NodeInverseRefsServices.INSTANCE.getComponentRealizationInverseRefs(diagram);
    }

    public Collection<EObject> getConnectorInverseRefs(DDiagram diagram) {
        return NodeInverseRefsServices.INSTANCE.getConnectorInverseRefs(diagram);
    }

    public Collection<EObject> getDependencyOnlyInverseRefs(DDiagram diagram) {
        return NodeInverseRefsServices.INSTANCE.getDependencyOnlyInverseRefs(diagram);
    }

    public List<Port> getSource4Port2SubRequiredInterface(Connector connector) {
        ArrayList<Port> result = new ArrayList<Port>();
        EList clientDependencies = connector.getClientDependencies();
        block0: for (ConnectorEnd connectorEnd : connector.getEnds()) {
            if (!(connectorEnd.getRole() instanceof Port)) continue;
            Port portUnderTest = (Port)connectorEnd.getRole();
            boolean sourcePort = true;
            for (Dependency dependency : clientDependencies) {
                if (!sourcePort) continue block0;
                if (dependency instanceof Usage) {
                    for (NamedElement client : dependency.getClients()) {
                        if (!(client instanceof Port) || !client.equals(portUnderTest)) continue;
                        sourcePort = false;
                        break;
                    }
                }
                if (!sourcePort) continue;
                result.add(portUnderTest);
            }
        }
        return result;
    }

    public List<Interface> getSource4ProvidedInterface2RequiredInterface(Connector connector) {
        ArrayList<Interface> result = new ArrayList<Interface>();
        for (Dependency dependency : connector.getClientDependencies()) {
            if (!(dependency instanceof InterfaceRealization)) continue;
            EList suppliers = dependency.getSuppliers();
            for (NamedElement supplier : suppliers) {
                if (!(supplier instanceof Interface)) continue;
                result.add((Interface)supplier);
            }
        }
        return result;
    }

    public List<Interface> getSource4SubProvidedInterface2Port(Connector connector) {
        ArrayList<Interface> result = new ArrayList<Interface>();
        for (Dependency dependency : connector.getClientDependencies()) {
            if (!(dependency instanceof InterfaceRealization)) continue;
            EList suppliers = dependency.getSuppliers();
            for (NamedElement supplier : suppliers) {
                if (!(supplier instanceof Interface)) continue;
                result.add((Interface)supplier);
            }
        }
        return result;
    }

    public List<Interface> getTarget4Port2SubRequiredInterface(Connector connector) {
        ArrayList<Interface> result = new ArrayList<Interface>();
        for (Dependency dependency : connector.getClientDependencies()) {
            if (!(dependency instanceof Usage)) continue;
            EList suppliers = dependency.getSuppliers();
            for (NamedElement supplier : suppliers) {
                if (!(supplier instanceof Interface)) continue;
                result.add((Interface)supplier);
            }
        }
        return result;
    }

    public List<Interface> getTarget4ProvidedInterface2RequiredInterface(Connector connector) {
        ArrayList<Interface> result = new ArrayList<Interface>();
        for (Dependency dependency : connector.getClientDependencies()) {
            if (!(dependency instanceof Usage)) continue;
            EList suppliers = dependency.getSuppliers();
            for (NamedElement supplier : suppliers) {
                if (!(supplier instanceof Interface)) continue;
                result.add((Interface)supplier);
            }
        }
        return result;
    }

    public List<Port> getTarget4SubProvidedInterface2Port(Connector connector) {
        ArrayList<Port> result = new ArrayList<Port>();
        EList clientDependencies = connector.getClientDependencies();
        block0: for (ConnectorEnd connectorEnd : connector.getEnds()) {
            if (!(connectorEnd.getRole() instanceof Port)) continue;
            Port portUnderTest = (Port)connectorEnd.getRole();
            boolean targetPort = true;
            for (Dependency dependency : clientDependencies) {
                if (!targetPort) continue block0;
                if (dependency instanceof InterfaceRealization) {
                    for (NamedElement client : dependency.getClients()) {
                        if (!(client instanceof Port) || !client.equals(portUnderTest)) continue;
                        targetPort = false;
                        break;
                    }
                }
                if (!targetPort) continue;
                result.add(portUnderTest);
            }
        }
        return result;
    }

    public Collection<EObject> getUsageInverseRefs(DDiagram diagram) {
        return NodeInverseRefsServices.INSTANCE.getUsageInverseRefs(diagram);
    }

    public boolean isComponent(EObject element) {
        return ElementServices.INSTANCE.isComponent(element);
    }

    public boolean isConnectable(Element source, Element target) {
        return ConnectorServices.INSTANCE.isConnectable(source, target);
    }

    public boolean validSourceTarget4Connector(Element source, DSemanticDecorator sourceView, Element target, DSemanticDecorator targetView) {
        boolean result = false;
        if (source instanceof Interface && target instanceof Interface) {
            result = targetView.eContainer().equals(sourceView.eContainer());
        }
        return result;
    }

    public boolean validSourceTarget4DelegatedConnector(Element source, DSemanticDecorator sourceView, Element target, DSemanticDecorator targetView) {
        boolean result = false;
        if (source instanceof Interface && target instanceof Port) {
            result = targetView.eContainer().equals(sourceView.eContainer());
        }
        return result;
    }

    public boolean validSourceTarget4Dependency(Element source, DSemanticDecorator sourceView, Element target, DSemanticDecorator targetView) {
        boolean result = false;
        if (source instanceof Class) {
            result = targetView.eContainer().equals(sourceView.eContainer());
        } else if (source instanceof Port) {
            result = targetView.eContainer().equals(sourceView.eContainer().eContainer());
        }
        return result;
    }
}

