/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.api.services;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.Usage;
import org.obeonetwork.dsl.uml2.design.api.services.AbstractDiagramServices;
import org.obeonetwork.dsl.uml2.design.internal.services.ConnectorServices;
import org.obeonetwork.dsl.uml2.design.internal.services.NodeInverseRefsServices;
import org.obeonetwork.dsl.uml2.design.internal.services.RelatedCompositeStructureElementsSwitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeStructureDiagramServices
extends AbstractDiagramServices {
    public Connector createConnector(StructuredClassifier structuredClassifier, NamedElement elem1, NamedElement elem2) {
        return ConnectorServices.INSTANCE.createConnector(structuredClassifier, elem1, elem2);
    }

    public Collection<EObject> getConnectorInverseRefs(DDiagram diagram) {
        return NodeInverseRefsServices.INSTANCE.getConnectorInverseRefs(diagram);
    }

    public List<Element> getConnectorSource(Connector connector, DDiagram diagram) {
        ArrayList<Element> connectableElements = new ArrayList<Element>();
        EList connectorEnds = connector.getEnds();
        if (connectorEnds != null && connectorEnds.size() > 0) {
            ConnectorEnd connectorEnd = (ConnectorEnd)connectorEnds.get(0);
            ConnectableElement role = connectorEnd.getRole();
            ConnectorEnd connectorEnd2 = (ConnectorEnd)connectorEnds.get(1);
            ConnectableElement role2 = connectorEnd2.getRole();
            if (this.isInterfacesLayerActive((DDiagramElement)diagram.getOwnedDiagramElements().get(0))) {
                if (role instanceof Port && ((Port)role).getProvideds().size() > 0) {
                    connectableElements.addAll((Collection<Element>)((Port)role).getProvideds());
                } else if (role2 instanceof Port && ((Port)role2).getProvideds().size() > 0) {
                    connectableElements.addAll((Collection<Element>)((Port)role2).getProvideds());
                }
                if (connectableElements.size() != 0) {
                    return connectableElements;
                }
            }
            connectableElements.add((Element)role);
        }
        return connectableElements;
    }

    public List<Element> getConnectorTarget(Connector connector, DDiagram diagram) {
        ArrayList<Element> connectableElements = new ArrayList<Element>();
        EList connectorEnds = connector.getEnds();
        if (connectorEnds != null && connectorEnds.size() > 0) {
            ConnectorEnd connectorEnd = (ConnectorEnd)connectorEnds.get(0);
            ConnectableElement role = connectorEnd.getRole();
            ConnectorEnd connectorEnd2 = (ConnectorEnd)connectorEnds.get(1);
            ConnectableElement role2 = connectorEnd2.getRole();
            if (this.isInterfacesLayerActive((DDiagramElement)diagram.getOwnedDiagramElements().get(0))) {
                if (role instanceof Port && ((Port)role).getRequireds().size() > 0) {
                    connectableElements.addAll((Collection<Element>)((Port)role).getRequireds());
                } else if (role2 instanceof Port && ((Port)role2).getRequireds().size() > 0) {
                    connectableElements.addAll((Collection<Element>)((Port)role2).getRequireds());
                }
                if (connectableElements.size() != 0) {
                    return connectableElements;
                }
            }
            connectableElements.add((Element)role2);
        }
        return connectableElements;
    }

    public Collection<EObject> getPortInterfaceRealization(DDiagram diagram) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        if (diagram instanceof DSemanticDecorator) {
            Session sess = SessionManager.INSTANCE.getSession(((DSemanticDecorator)diagram).getTarget());
            Iterator it = Iterators.transform((Iterator)Iterators.filter((Iterator)diagram.eAllContents(), AbstractDNode.class), (Function)new Function<AbstractDNode, EObject>(){

                public EObject apply(AbstractDNode input) {
                    return input.getTarget();
                }
            });
            while (it.hasNext()) {
                EObject displayedAsANode = (EObject)it.next();
                if (displayedAsANode == null) continue;
                for (EStructuralFeature.Setting xRef : sess.getSemanticCrossReferencer().getInverseReferences(displayedAsANode)) {
                    EObject eObject = xRef.getEObject();
                    if (eObject instanceof DNode) {
                        eObject = ((DNode)eObject).getTarget();
                    }
                    if (!sess.getModelAccessor().eInstanceOf(eObject, "Port")) continue;
                    Port port = (Port)eObject;
                    result.addAll(port.getProvideds());
                }
            }
        }
        return result;
    }

    public Collection<EObject> getPortUsage(DDiagram diagram) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        if (diagram instanceof DSemanticDecorator) {
            Session sess = SessionManager.INSTANCE.getSession(((DSemanticDecorator)diagram).getTarget());
            Iterator it = Iterators.transform((Iterator)Iterators.filter((Iterator)diagram.eAllContents(), AbstractDNode.class), (Function)new Function<AbstractDNode, EObject>(){

                public EObject apply(AbstractDNode input) {
                    return input.getTarget();
                }
            });
            while (it.hasNext()) {
                EObject displayedAsANode = (EObject)it.next();
                if (displayedAsANode == null) continue;
                for (EStructuralFeature.Setting xRef : sess.getSemanticCrossReferencer().getInverseReferences(displayedAsANode)) {
                    Port port;
                    EObject eObject = xRef.getEObject();
                    if (eObject instanceof DNode) {
                        eObject = ((DNode)eObject).getTarget();
                    }
                    if (!sess.getModelAccessor().eInstanceOf(eObject, "Port") || (port = (Port)eObject).getRequireds().size() <= 0) continue;
                    result.add(port);
                }
            }
        }
        return result;
    }

    public Collection<EObject> getRelatedForCompositeStructure(EObject cur) {
        return new RelatedCompositeStructureElementsSwitch().getRelatedElements(cur);
    }

    public StructuredClassifier getStructuredClassifier(Element element) {
        Type type;
        if (element instanceof StructuredClassifier) {
            return (StructuredClassifier)element;
        }
        if (element instanceof Property && (type = ((Property)element).getType()) != null && type instanceof StructuredClassifier) {
            return (StructuredClassifier)type;
        }
        return null;
    }

    public Collection<EObject> getUsageInverseRefs(DDiagram diagram) {
        return NodeInverseRefsServices.INSTANCE.getUsageInverseRefs(diagram);
    }

    public List<EObject> handleUnmeaningViews(List<EObject> views) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject view : views) {
            if (this.isInterfaceView(view)) {
                DNode interfaceView = (DNode)view;
                ArrayList edges = new ArrayList(interfaceView.getIncomingEdges());
                edges.addAll(interfaceView.getOutgoingEdges());
                for (DEdge edge : edges) {
                    EObject target = edge.getTarget();
                    if (!(target instanceof InterfaceRealization) && !(target instanceof Usage)) continue;
                    result.add((EObject)edge);
                }
                continue;
            }
            result.add(view);
        }
        return result;
    }

    public boolean isConnectable(Element source, Element target) {
        return ConnectorServices.INSTANCE.isConnectable(source, target);
    }

    private boolean isInterfacesLayerActive(DDiagramElement diagramElement) {
        DDiagram diagram = diagramElement.getParentDiagram();
        for (Layer activeLayer : diagram.getActivatedLayers()) {
            if (!"Interfaces".equals(activeLayer.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean isInterfaceView(EObject view) {
        return view instanceof DNode && ((DNode)view).getTarget() != null && ((DNode)view).getTarget() instanceof Interface;
    }

    public boolean isValidConnector(Connector self, DNode sourceView, DNode targetView) {
        if (sourceView != targetView && self.getEnds().size() > 0) {
            self.getEnds().get(0);
            self.getEnds().get(1);
            Element source = (Element)sourceView.getTarget();
            Element target = (Element)targetView.getTarget();
            if (this.isInterfacesLayerActive((DDiagramElement)sourceView)) {
                if (source instanceof Interface && target instanceof Interface) {
                    EList ends = self.getEnds();
                    ConnectorEnd end1 = (ConnectorEnd)ends.get(0);
                    ConnectorEnd end2 = (ConnectorEnd)ends.get(1);
                    ConnectableElement role1 = end1.getRole();
                    ConnectableElement role2 = end2.getRole();
                    if (role1 instanceof Port && role2 instanceof Port) {
                        Port port1 = (Port)role1;
                        EList port1Provideds = port1.getProvideds();
                        EList port1Requireds = port1.getRequireds();
                        Port port2 = (Port)role2;
                        EList port2Provideds = port2.getProvideds();
                        EList port2Requireds = port2.getRequireds();
                        if (port1Provideds != null && port1Requireds != null && port2Provideds != null && port2Requireds != null && (port1Provideds.contains(source) && port2Requireds.contains(target) || port1Provideds.contains(target) && port2Requireds.contains(source) || port2Provideds.contains(source) && port1Requireds.contains(target) || port2Provideds.contains(target) && port1Requireds.contains(source))) {
                            return true;
                        }
                    }
                } else if (source instanceof Port && target instanceof Port) {
                    Port port1 = (Port)source;
                    Port port2 = (Port)target;
                    return port1.getProvideds().size() == 0 && port2.getRequireds().size() == 0 && port2.getProvideds().size() == 0 && port1.getRequireds().size() == 0;
                }
            }
        }
        return true;
    }

    public boolean isValidPortContainer(Element element) {
        return this.getStructuredClassifier(element) != null;
    }

    public boolean isValidPortInterfaceRealization(Port source, Interface target) {
        return source.getProvideds() != null && source.getProvideds().size() > 0 && source.getProvideds().contains((Object)target);
    }

    public boolean isValidPortUsage(Interface source, Port target) {
        return target.getRequireds() != null && target.getRequireds().size() > 0 && target.getRequireds().contains((Object)source);
    }
}

