/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.api.services;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.UMLFactory;
import org.obeonetwork.dsl.uml2.design.internal.services.ElementServices;
import org.obeonetwork.dsl.uml2.design.internal.services.LogServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DashboardServices {
    private static final String PACKAGE_HIERARCHY = "Package Hierarchy";
    private static final String CLASS_DIAGRAM = "Class Diagram";
    private static final String COMPONENT_DIAGRAM = "Component Diagram";
    private static final String COMPOSITE_STRUCTURE_DIAGRAM = "Composite Structure Diagram";
    private static final String DEPLOYMENT_DIAGRAM = "Deployment Diagram";
    private static final String STATEMACHINE_DIAGRAM = "State Machine Diagram";
    private static final String ACTIVITY_DIAGRAM = "Activity Diagram";
    private static final String PROFILE_DIAGRAM = "Profile Diagram";
    private static final String USECASE_DIAGRAM = "Use Case Diagram";
    private static final String SEQUENCE_DIAGRAM = "Sequence Diagram";
    private static final String DOCUMENTATION_TABLE = "Documentation Table";
    private static final String USECASE_CROSS_TABLE = "Use Case Cross Table";
    private static final String PACKAGE_CONTAINMENT = "Package Containment";
    public static final String DASHBOARD_DIAGRAM_DESCRIPTION_ID = "Dashboard";
    public static final String DASHBOARD_VP = "Dashboard";

    public void createActivityDiagram(Activity element) {
        this.createRepresentation((NamedElement)element, ACTIVITY_DIAGRAM);
    }

    public void createClassDiagram(Model element) {
        this.createRepresentation((NamedElement)element, CLASS_DIAGRAM);
    }

    public void createComponentDiagram(Model element) {
        this.createRepresentation((NamedElement)element, COMPONENT_DIAGRAM);
    }

    public void createCompositeStructureDiagram(Model element) {
        this.createRepresentation((NamedElement)element, COMPOSITE_STRUCTURE_DIAGRAM);
    }

    public void createDeploymentDiagram(Model element) {
        this.createRepresentation((NamedElement)element, DEPLOYMENT_DIAGRAM);
    }

    public void createDocumentationTable(Model element) {
        this.createRepresentation((NamedElement)element, DOCUMENTATION_TABLE);
    }

    public Interaction createInteraction(EObject pkg) {
        UMLFactory factory = UMLFactory.eINSTANCE;
        Interaction interaction = factory.createInteraction();
        interaction.setName(ElementServices.INSTANCE.getNewInteractionName(pkg));
        ((Package)pkg).getPackagedElements().add((Object)interaction);
        return interaction;
    }

    public void createPackageContainment(Model element) {
        this.createRepresentation((NamedElement)element, PACKAGE_CONTAINMENT);
    }

    public void createPackageDiagram(Model element) {
        this.createRepresentation((NamedElement)element, PACKAGE_HIERARCHY);
    }

    public void createProfileDiagram(Profile element) {
        this.createRepresentation((NamedElement)element, PROFILE_DIAGRAM);
    }

    private void createRepresentation(EObject eObject, String representationName, RepresentationDescription representationDescription) {
        Session session = SessionManager.INSTANCE.getSession(eObject);
        DRepresentation representation = DialectManager.INSTANCE.createRepresentation(representationName, eObject, representationDescription, session, (IProgressMonitor)new NullProgressMonitor());
        this.openRepresentation(representation);
    }

    protected void createRepresentation(NamedElement namedElement, String representationId) {
        Session session = SessionManager.INSTANCE.getSession((EObject)namedElement);
        RepresentationDescription representationDescription = this.getRepresentationDescription((EObject)namedElement, session, representationId);
        this.createRepresentation((EObject)namedElement, String.valueOf(namedElement.getName()) + " " + representationId, representationDescription);
    }

    public void createSequenceDiagram(Interaction element) {
        this.createRepresentation((NamedElement)element, SEQUENCE_DIAGRAM);
    }

    public void createStateMachineDiagram(StateMachine element) {
        this.createRepresentation((NamedElement)element, STATEMACHINE_DIAGRAM);
    }

    public void createUseCaseCrossTable(Model element) {
        this.createRepresentation((NamedElement)element, USECASE_CROSS_TABLE);
    }

    public void createUseCaseDiagram(Model element) {
        this.createRepresentation((NamedElement)element, USECASE_DIAGRAM);
    }

    public boolean doesDashboardNotExist(EObject any) {
        Session session = SessionManager.INSTANCE.getSession(any);
        Collection representations = DialectManager.INSTANCE.getAllRepresentations(session);
        for (DRepresentation representation : representations) {
            DSemanticDiagram diagram;
            if (!(representation instanceof DSemanticDiagram) || !"Dashboard".equals((diagram = (DSemanticDiagram)representation).getDescription().getName())) continue;
            return false;
        }
        return true;
    }

    private Collection<DRepresentation> getAllRepresentations(EObject any) {
        Session session = SessionManager.INSTANCE.getSession(any);
        Collection representations = DialectManager.INSTANCE.getAllRepresentations(session);
        ArrayList result = Lists.newArrayList((Iterable)representations);
        for (DRepresentation representation : representations) {
            DSemanticDiagram diagram;
            if (!(representation instanceof DSemanticDiagram) || !"Dashboard".equals((diagram = (DSemanticDiagram)representation).getDescription().getName())) continue;
            result.remove(representation);
        }
        return result;
    }

    private RepresentationDescription getRepresentationDescription(EObject eObject, Session session, String representationDescriptionId) {
        Collection representationDescriptions = DialectManager.INSTANCE.getAvailableRepresentationDescriptions(session.getSelectedViewpoints(false), eObject);
        for (RepresentationDescription representationDescription : representationDescriptions) {
            if (!representationDescriptionId.equals(representationDescription.getName())) continue;
            return representationDescription;
        }
        return null;
    }

    public Collection<DRepresentation> getRepresentationsSortedByName(EObject any) {
        Collection<DRepresentation> representations = this.getAllRepresentations(any);
        Function<DRepresentation, String> getNameFunction = new Function<DRepresentation, String>(){

            public String apply(DRepresentation from) {
                return from.getName().toLowerCase();
            }
        };
        Ordering nameOrdering = Ordering.natural().onResultOf((Function)getNameFunction);
        return nameOrdering.immutableSortedCopy(representations);
    }

    public void openContextHelp(EObject any, String contextID) {
        if (PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell() != null) {
            String contextId = "org.obeonetwork.dsl.uml2.design.doc." + contextID;
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), contextId);
            PlatformUI.getWorkbench().getHelpSystem().displayDynamicHelp();
        }
    }

    public void openRepresentation(final DRepresentation representation) {
        final Session session = SessionManager.INSTANCE.getSession(((DSemanticDecorator)representation).getTarget());
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask("Open representation " + representation.getName(), 100);
                    DialectUIManager.INSTANCE.openEditor(session, representation, monitor);
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            LogServices.INSTANCE.error("Open representation " + representation.getName() + " failed", e);
        }
        catch (InterruptedException e) {
            LogServices.INSTANCE.error("Open representation " + representation.getName() + " failed", e);
        }
    }
}

