/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.api.services;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.ResizableWizardDialog;
import org.eclipse.pde.internal.ui.wizards.exports.PluginExportWizard;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.obeonetwork.dsl.uml2.design.api.services.AbstractDiagramServices;
import org.obeonetwork.dsl.uml2.design.api.services.ReusedDescriptionServices;
import org.obeonetwork.dsl.uml2.design.internal.dialogs.ExtraAssociationSelectionDialog;
import org.obeonetwork.dsl.uml2.design.internal.dialogs.ImportMetaclassDialog;
import org.obeonetwork.dsl.uml2.design.internal.dialogs.InitProfilePluginDialog;
import org.obeonetwork.dsl.uml2.design.internal.services.AssociationServices;
import org.obeonetwork.dsl.uml2.design.internal.services.EcoreToGenmodel;
import org.obeonetwork.dsl.uml2.design.internal.services.ElementServices;
import org.obeonetwork.dsl.uml2.design.internal.services.ExtensionServices;
import org.obeonetwork.dsl.uml2.design.internal.services.GenerateModelCode;
import org.obeonetwork.dsl.uml2.design.internal.services.GenericUMLProfileTools;
import org.obeonetwork.dsl.uml2.design.internal.services.LabelServices;
import org.obeonetwork.dsl.uml2.design.internal.services.LogServices;
import org.obeonetwork.dsl.uml2.design.internal.services.NewPluginProject;
import org.obeonetwork.dsl.uml2.design.internal.services.NodeInverseRefsServices;
import org.obeonetwork.dsl.uml2.design.internal.services.ProfileServices;
import org.obeonetwork.dsl.uml2.design.internal.services.UmlToEcore;
import org.obeonetwork.dsl.uml2.design.internal.services.ValidateEmfElement;
import org.obeonetwork.dsl.uml2.design.internal.services.ValidateUMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileDiagramServices
extends AbstractDiagramServices {
    private static final String YES = "Yes";
    private static final String NO = "No";
    private static final String OK = "OK";
    private static final String UNDEFINE_PROFILE = "Undefine the Profile";
    private static final String OBEO_NETWORK_PLUGIN_NAME = new String("org.obeonetwork");
    private static final String OBEO_NETWORK_URI = new String("http://www.obeonetwork.org/");
    private String profileName = new String();
    private static final String DEFAULT_PROFILE_NAME = new String("profile");
    private String profilePluginName = new String();
    private String rootProfileURI = new String();
    private static final String SEPARATOR = new String("/");
    private static final String NS_URI = new String("nsURI");
    private static final String EXTENSION = new String("extension");
    private static final String POINT = new String("point");
    private static final String PLATFORM_PLUGIN = new String("platform:/plugin");

    private void addProfileExtensions(IProject profilePlugin, IFolder modelFolder, Profile profileCopy) {
        String exceptionMsg = "addProfileExtensions(" + profilePlugin.getClass() + "," + modelFolder.getClass() + "," + profileCopy.getClass() + ") not handled";
        IFile pluginXML = profilePlugin.getFile("plugin.xml");
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = builderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            LogServices.INSTANCE.error(exceptionMsg, e);
        }
        Document document = null;
        try {
            if (builder != null) {
                document = builder.parse(pluginXML.getLocation().toFile());
            }
        }
        catch (SAXException e) {
            LogServices.INSTANCE.error(exceptionMsg, e);
        }
        catch (IOException e) {
            LogServices.INSTANCE.error(exceptionMsg, e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (document != null) {
            String xmiIdProfileCopy = profileCopy.eResource().getURIFragment((EObject)profileCopy);
            Element racine = document.getDocumentElement();
            Element extensionForGeneratedPackage = document.createElement(EXTENSION);
            extensionForGeneratedPackage.setAttribute(POINT, "org.eclipse.uml2.uml.generated_package");
            Element profile = document.createElement(DEFAULT_PROFILE_NAME);
            profile.setAttribute("location", String.valueOf(PLATFORM_PLUGIN) + profileCopy.eResource().getURI() + "#" + xmiIdProfileCopy);
            profile.setAttribute("uri", profileCopy.getURI());
            extensionForGeneratedPackage.appendChild(profile);
            racine.appendChild(extensionForGeneratedPackage);
            EList allOwnedElements = profileCopy.allOwnedElements();
            for (org.eclipse.uml2.uml.Element ownedPackageElement : allOwnedElements) {
                if (!(ownedPackageElement instanceof Profile)) continue;
                Profile ownedProfile = (Profile)ownedPackageElement;
                String xmiIdownedPackage = ownedProfile.eResource().getURIFragment((EObject)ownedProfile);
                extensionForGeneratedPackage = document.createElement(EXTENSION);
                extensionForGeneratedPackage.setAttribute(POINT, "org.eclipse.uml2.uml.generated_package");
                profile = document.createElement(DEFAULT_PROFILE_NAME);
                profile.setAttribute("location", String.valueOf(PLATFORM_PLUGIN) + ownedProfile.eResource().getURI() + "#" + xmiIdownedPackage);
                profile.setAttribute("uri", ownedProfile.getURI());
                extensionForGeneratedPackage.appendChild(profile);
                racine.appendChild(extensionForGeneratedPackage);
            }
            Element extensionForUriMapping = document.createElement(EXTENSION);
            extensionForUriMapping.setAttribute(POINT, "org.eclipse.emf.ecore.uri_mapping");
            Element mapping = document.createElement("mapping");
            mapping.setAttribute("source", "pathmap://MY_PROFILES/");
            mapping.setAttribute("target", String.valueOf(PLATFORM_PLUGIN) + modelFolder.getFullPath());
            extensionForUriMapping.appendChild(mapping);
            racine.appendChild(extensionForUriMapping);
            Transformer transformer = null;
            try {
                transformer = TransformerFactory.newInstance().newTransformer();
            }
            catch (TransformerConfigurationException e) {
                LogServices.INSTANCE.error(exceptionMsg, e);
            }
            catch (TransformerFactoryConfigurationError e) {
                LogServices.INSTANCE.error(exceptionMsg, e);
            }
            StreamResult output = new StreamResult(pluginXML.getLocation().toFile());
            DOMSource input = new DOMSource(document);
            try {
                if (transformer != null) {
                    transformer.transform(input, output);
                }
            }
            catch (TransformerException e) {
                LogServices.INSTANCE.error(exceptionMsg, e);
            }
        }
    }

    public boolean canCreateExtension(Stereotype source, ElementImport target) {
        return ExtensionServices.INSTANCE.canCreateExtension((EObject)source, (EObject)target);
    }

    public boolean canCreateExtension(Stereotype source, Stereotype target) {
        return ExtensionServices.INSTANCE.canCreateExtension((EObject)source, (EObject)target);
    }

    private boolean canDropElementImport(ElementImport elementImport, Profile oldProfile, Profile newProfile) {
        if (newProfile.getImportedMember(elementImport.getImportedElement().getName()) != null) {
            return false;
        }
        for (Extension extension : oldProfile.getOwnedExtensions(false)) {
            if (extension.getMetaclass() == null || !extension.getMetaclass().equals(elementImport.getImportedElement())) continue;
            return false;
        }
        return true;
    }

    public String computeElementImportLabel(ElementImport element) {
        return LabelServices.INSTANCE.computeElementImportLabel(element);
    }

    public String computeProfileLabel(Profile element) {
        return LabelServices.INSTANCE.computeProfileLabel(element);
    }

    public String computeSourceLabel(Stereotype stereotype) {
        ArrayList<Property> properties = ProfileServices.INSTANCE.getRelationShipSourceTargetPeroperties(this.getMetaclass((Property)stereotype.getOwnedAttributes().get(0)));
        return LabelServices.INSTANCE.computeAssociationEndLabel(properties.get(0));
    }

    public String computeStereotypeLabel(Stereotype element) {
        return LabelServices.INSTANCE.computeStereotypeLabel(element);
    }

    public String computeTargetLabel(Stereotype stereotype) {
        ArrayList<Property> properties = ProfileServices.INSTANCE.getRelationShipSourceTargetPeroperties(this.getMetaclass((Property)stereotype.getOwnedAttributes().get(0)));
        return LabelServices.INSTANCE.computeAssociationEndLabel(properties.get(1));
    }

    private String computeURI(NamedElement element) {
        String uri = null;
        uri = element.getOwner() == null && element.getNearestPackage().getURI() != null && element.getNearestPackage().getURI().length() != 0 ? element.getNearestPackage().getURI() : (element.getOwner() != null && element.getOwner().getNearestPackage() != null && element.getOwner().getNearestPackage().getURI() != null ? String.valueOf(element.getOwner().getNearestPackage().getURI()) + element.getName() + SEPARATOR : this.rootProfileURI);
        return uri;
    }

    public Association createAssociation(Stereotype stereotypeSource, Stereotype stereotypeTarget) {
        return this.createAssociation(stereotypeSource, stereotypeTarget, String.valueOf(stereotypeSource.getName()) + "To" + stereotypeTarget.getName());
    }

    private Association createAssociation(Stereotype stereotypeSource, Stereotype stereotypeTarget, String associationName) {
        Association association = UMLFactory.eINSTANCE.createAssociation();
        Property sourceStereoProperty = UMLFactory.eINSTANCE.createProperty();
        sourceStereoProperty.setName(String.valueOf(stereotypeSource.getName()) + "s");
        sourceStereoProperty.setType((Type)stereotypeSource);
        sourceStereoProperty.setLower(0);
        sourceStereoProperty.setUpper(-1);
        association.getOwnedEnds().add((Object)sourceStereoProperty);
        Property targetStereoProperty = UMLFactory.eINSTANCE.createProperty();
        targetStereoProperty.setName(String.valueOf(stereotypeTarget.getName()) + "s");
        targetStereoProperty.setType((Type)stereotypeTarget);
        targetStereoProperty.setLower(0);
        targetStereoProperty.setUpper(-1);
        association.getOwnedEnds().add((Object)targetStereoProperty);
        association.getNavigableOwnedEnds().add((Object)targetStereoProperty);
        stereotypeSource.getProfile().getPackagedElements().add((Object)association);
        return association;
    }

    public void createExtension(Stereotype stereotype, org.eclipse.uml2.uml.Element targetElement) {
        ExtensionServices.INSTANCE.createExtension(stereotype, targetElement);
    }

    private Stereotype createExtraAssociation(Stereotype stereotypeSource, Stereotype stereotypeTarget, String stereotypName, Object[] result, Profile profile) {
        ElementImport metaClass = null;
        Stereotype newStereotype = null;
        if (result != null && result[0] instanceof Class) {
            Class selectedMetaclass = (Class)result[0];
            PackageableElement importedMember = profile.getImportedMember(selectedMetaclass.getName());
            metaClass = importedMember == null ? profile.createMetaclassReference((PackageableElement)selectedMetaclass) : profile.getElementImport(importedMember);
        }
        if (metaClass != null) {
            newStereotype = UMLFactory.eINSTANCE.createStereotype();
            newStereotype.setName(stereotypName);
            profile.getOwnedStereotypes().add((Object)newStereotype);
            ExtensionServices.INSTANCE.createMetaclassExtension(newStereotype, metaClass);
            this.createStereotypeAssociation(newStereotype, metaClass, stereotypeSource, stereotypeTarget);
        }
        return newStereotype;
    }

    public void createExtraAssociationDialog(Stereotype stereotypeSource, org.eclipse.uml2.uml.Element targetElement, Profile profile) {
        ExtraAssociationSelectionDialog dialog = new ExtraAssociationSelectionDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), profile, (org.eclipse.uml2.uml.Element)stereotypeSource, targetElement, false);
        dialog.open();
        if (dialog.getResult() != null && targetElement instanceof Stereotype) {
            Stereotype stereotypeTarget = (Stereotype)targetElement;
            this.createExtraAssociation(stereotypeSource, stereotypeTarget, dialog.getAssociationName(), dialog.getResult(), profile);
        }
    }

    private IProject createPluginProjectWithProgress(final String pluginName) {
        final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        final NewPluginProject newPluginProject = new NewPluginProject();
        final IProject[] profilePlugin = new IProject[1];
        IRunnableWithProgress validationRunnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
                try {
                    profilePlugin[0] = newPluginProject.createPluginProject(pluginName, new ArrayList<String>(Arrays.asList("src")), new ArrayList<IProject>(), new HashSet<String>(), new ArrayList<String>(Arrays.asList("org.eclipse.ui", "org.eclipse.core.runtime")), (IProgressMonitor)new NullProgressMonitor(), shell);
                }
                finally {
                    progressMonitor.done();
                }
            }
        };
        try {
            new ProgressMonitorDialog(shell).run(true, true, validationRunnable);
        }
        catch (Exception exception) {
            EMFEditUIPlugin.INSTANCE.log((Object)exception);
        }
        return profilePlugin[0];
    }

    public Stereotype createStereotype(ElementImport elementImport) {
        Stereotype newStereotype = UMLFactory.eINSTANCE.createStereotype();
        ExtensionServices.INSTANCE.getProfileOwner((org.eclipse.uml2.uml.Element)elementImport).getOwnedStereotypes().add((Object)newStereotype);
        ExtensionServices.INSTANCE.createMetaclassExtension(newStereotype, elementImport);
        return newStereotype;
    }

    public Stereotype createStereotype(Package package_) {
        Stereotype newStereotype = UMLFactory.eINSTANCE.createStereotype();
        package_.getOwnedStereotypes().add((Object)newStereotype);
        return newStereotype;
    }

    public Stereotype createStereotype(Profile profile) {
        Stereotype newStereotype = UMLFactory.eINSTANCE.createStereotype();
        profile.getOwnedStereotypes().add((Object)newStereotype);
        return newStereotype;
    }

    public Stereotype createStereotype(Stereotype stereotype) {
        Stereotype newStereotype = UMLFactory.eINSTANCE.createStereotype();
        if (stereotype.getOwner() instanceof Package) {
            ((Package)stereotype.getOwner()).getOwnedStereotypes().add((Object)newStereotype);
        }
        ExtensionServices.INSTANCE.createGeneralization(newStereotype, stereotype);
        return newStereotype;
    }

    private void createStereotypeAssociation(Stereotype stereotype, ElementImport elementImport, Stereotype stereotypeSource, Stereotype stereotypeTarget) {
        PackageableElement importedElement = elementImport.getImportedElement();
        if (importedElement != null && importedElement instanceof Type && ExtensionServices.INSTANCE.isExtendedBy((Type)importedElement, stereotype)) {
            Type metaclass = (Type)importedElement;
            Class metaclassClass = (Class)importedElement;
            ArrayList<Property> properties = ProfileServices.INSTANCE.getRelationShipSourceTargetPeroperties(metaclassClass);
            Property sourceProperty = properties.get(0);
            Property targetProperty = properties.get(1);
            metaclassClass.getAttributes();
            Property associationSourceEnd = UMLFactory.eINSTANCE.createProperty();
            associationSourceEnd.setName("sourceRole_" + sourceProperty.getName());
            associationSourceEnd.setType((Type)stereotypeSource);
            stereotype.getOwnedAttributes().add((Object)associationSourceEnd);
            Property associationTargetEnd = UMLFactory.eINSTANCE.createProperty();
            associationTargetEnd.setName("targetRole_" + targetProperty.getName());
            associationTargetEnd.setType((Type)stereotypeTarget);
            stereotype.getOwnedAttributes().add((Object)associationTargetEnd);
            Extension extension = ExtensionServices.INSTANCE.getExtension(stereotype, metaclass);
            extension.getMemberEnds().add((Object)associationSourceEnd);
            extension.getMemberEnds().add((Object)associationTargetEnd);
        }
    }

    public void defineProfileDialog(Profile rootProfile) {
        this.defineProfileDialog(rootProfile, ProfileServices.INSTANCE.getAllSubProfiles(rootProfile));
    }

    private void defineProfileDialog(Profile rootProfile, List<Profile> allContentProfile) {
        boolean result = false;
        String[] buttonYes = new String[]{OK};
        Shell activeShell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        MessageDialog msgDialogYes = null;
        result = ProfileServices.INSTANCE.defineProfile(rootProfile, allContentProfile);
        if (result) {
            msgDialogYes = new MessageDialog(activeShell, "Define the Profile", null, "The profile is defined", 2, buttonYes, 0);
            msgDialogYes.open();
        }
    }

    private void deleteElementImport(ElementImport elementImport, Profile profile) {
        for (Extension extension : profile.getOwnedExtensions(false)) {
            if (extension.getMetaclass() == null || !extension.getMetaclass().equals(elementImport.getImportedElement())) continue;
            this.deleteExtension(extension, profile);
        }
        EcoreUtil.delete((EObject)elementImport, (boolean)true);
    }

    private void deleteExtension(Extension extension, Profile profile) {
        for (org.eclipse.uml2.uml.Element relatedElement : extension.getRelatedElements()) {
            if (!(relatedElement instanceof Stereotype) || extension.getMetaclass() == null) continue;
            EList properties = ((Stereotype)relatedElement).getAttributes();
            int propertiesSize = properties.size();
            int i = 0;
            while (i < propertiesSize) {
                if (((Property)properties.get(i)).getAssociation() != null && ((Property)properties.get(i)).getAssociation().equals(extension)) {
                    ((Property)properties.get(i)).destroy();
                    --i;
                    --propertiesSize;
                }
                ++i;
            }
        }
        EcoreUtil.delete((EObject)extension, (boolean)true);
    }

    private void deleteStereotype(Stereotype stereotype, Profile profile) {
        for (Extension extension : profile.getOwnedExtensions(false)) {
            Property baseProperty;
            if (extension.getEndType(stereotype.getName()) == null || (baseProperty = extension.getMemberEnd("base_" + extension.getMetaclass().getName(), (Type)extension.getMetaclass())) == null || !baseProperty.getOwner().equals(stereotype)) continue;
            EcoreUtil.delete((EObject)extension, (boolean)true);
        }
        EcoreUtil.delete((EObject)stereotype, (boolean)true);
    }

    public void deleteUMLElement(org.eclipse.uml2.uml.Element element, Profile profile) {
        if (element instanceof ElementImport) {
            this.deleteElementImport((ElementImport)element, profile);
        } else if (element instanceof Stereotype) {
            this.deleteStereotype((Stereotype)element, profile);
        } else if (element instanceof Extension) {
            this.deleteExtension((Extension)element, profile);
        } else {
            EcoreUtil.delete((EObject)element, (boolean)true);
        }
    }

    public void deleteUMLPackage(Package package_) {
        EcoreUtil.delete((EObject)package_, (boolean)true);
    }

    public void dropFromDiagramProfileService(org.eclipse.uml2.uml.Element newContainer, org.eclipse.uml2.uml.Element semanticElement, DSemanticDecorator containerView) {
        Session session = SessionManager.INSTANCE.getSession((EObject)newContainer);
        boolean doTheDrop = true;
        org.eclipse.uml2.uml.Element oldContainer = semanticElement.getOwner();
        TransactionalEditingDomain domain = session.getTransactionalEditingDomain();
        Command cmd = null;
        if (newContainer instanceof Profile && oldContainer instanceof Profile && newContainer != oldContainer) {
            Profile newProfile = (Profile)newContainer;
            Profile oldProfile = (Profile)oldContainer;
            if (semanticElement instanceof ElementImport) {
                ElementImport elementImport = (ElementImport)semanticElement;
                if (this.canDropElementImport(elementImport, oldProfile, newProfile)) {
                    cmd = AddCommand.create((EditingDomain)domain, (Object)newContainer, (Object)UMLPackage.Literals.PROFILE__METACLASS_REFERENCE, (Object)elementImport);
                    if (cmd.canExecute()) {
                        cmd.execute();
                    }
                } else {
                    doTheDrop = false;
                    if (newProfile.getImportedMember(elementImport.getImportedElement().getName()) == null) {
                        newProfile.createMetaclassReference(elementImport.getImportedElement());
                    }
                }
            }
            if (semanticElement instanceof Stereotype) {
                for (Property property : ((Stereotype)semanticElement).getAttributes()) {
                    if (!property.getName().startsWith("base_")) continue;
                    Extension extension = null;
                    if (property.getAssociation() != null && property.getAssociation() instanceof Extension) {
                        extension = (Extension)property.getAssociation();
                    }
                    if (extension == null || ((Profile)oldContainer).getElementImport((PackageableElement)extension.getMetaclass()) == null) continue;
                    ElementImport elementImport = ((Profile)oldContainer).getElementImport((PackageableElement)extension.getMetaclass());
                    this.dropFromDiagramProfileService(newContainer, (org.eclipse.uml2.uml.Element)extension, containerView);
                    if (elementImport == null) continue;
                    this.dropFromDiagramProfileService(newContainer, (org.eclipse.uml2.uml.Element)elementImport, containerView);
                }
                cmd = AddCommand.create((EditingDomain)domain, (Object)newContainer, (Object)UMLPackage.Literals.PROFILE__METACLASS_REFERENCE, (Object)semanticElement);
                if (cmd.canExecute()) {
                    cmd.execute();
                }
            }
        }
        if (doTheDrop) {
            ReusedDescriptionServices reusedDescriptionServices = new ReusedDescriptionServices();
            reusedDescriptionServices.dropFromDiagram(newContainer, semanticElement, containerView);
        }
    }

    public void exportProfile(Profile rootProfile) {
        Shell activeShell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        boolean isProfile = this.isProfileRoot(rootProfile);
        if (isProfile && this.validateUmlElementWithProgress(rootProfile)) {
            if (this.initParameters(rootProfile) == 0 && ProfileServices.INSTANCE.defineAllProfiles(rootProfile)) {
                GenericUMLProfileTools.save((Package)rootProfile);
                IProject profilePlugin = this.createPluginProjectWithProgress(this.profilePluginName);
                IFolder modelFolder = profilePlugin.getFolder("model");
                try {
                    modelFolder.create(false, true, null);
                }
                catch (CoreException e) {
                    LogServices.INSTANCE.error("exportProfile(" + rootProfile.getClass() + ") not handled", e);
                }
                IFile profileCopyIFile = modelFolder.getFile(String.valueOf(this.profileName) + "." + "uml");
                IFile rootProfileIFile = GenericUMLProfileTools.resourceToIFile(rootProfile.eResource());
                try {
                    rootProfileIFile.copy(profileCopyIFile.getFullPath(), true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    LogServices.INSTANCE.error("exportProfile(" + rootProfile.getClass() + ") not handled", e);
                }
                Resource profileCopyResource = new ResourceSetImpl().createResource(URI.createURI((String)profileCopyIFile.getFullPath().toString()));
                Profile profileCopy = (Profile)GenericUMLProfileTools.load(profileCopyResource.getURI());
                this.initEPackageStereotype(profileCopy);
                UmlToEcore umlToEcore = new UmlToEcore();
                Resource profileEcoreResource = umlToEcore.umlToEcore((Package)profileCopy);
                if (this.validateEObjectWithProgress((EObject)profileEcoreResource.getContents().get(0))) {
                    EcoreToGenmodel ecoreToGenmodel = new EcoreToGenmodel();
                    GenModel genModel = ecoreToGenmodel.ecoreToGenmodel(profileEcoreResource);
                    GenerateModelCode generateModelCode = new GenerateModelCode();
                    generateModelCode.generateModelCode(genModel);
                    this.addProfileExtensions(profilePlugin, modelFolder, profileCopy);
                    try {
                        profilePlugin.build(6, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        LogServices.INSTANCE.error("exportProfile(" + rootProfile.getClass() + ") not handled", e);
                    }
                    PluginExportWizard wizard = new PluginExportWizard();
                    StructuredSelection selection = new StructuredSelection((Object)profilePlugin);
                    wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)selection);
                    ResizableWizardDialog wd = new ResizableWizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
                    wd.create();
                    wd.open();
                    try {
                        profilePlugin.close((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                } else {
                    MessageDialog.openError((Shell)activeShell, (String)"Exportation error", (String)"Due to the error, the exportation will be stopped.");
                }
            } else {
                MessageDialog.openInformation((Shell)activeShell, (String)"Exportation canceled", (String)"Exportation canceled by user.");
            }
        } else if (!isProfile) {
            MessageDialog.openError((Shell)activeShell, (String)"Exportation error", (String)"The root element of this model is not a profile. Due to the error, the exportation will be stopped.");
        } else {
            MessageDialog.openError((Shell)activeShell, (String)"Exportation error", (String)"Due to the error, the exportation will be stopped.");
        }
    }

    public Type findTypeByName(Collection<EObject> roots, String typeName) {
        return ElementServices.INSTANCE.findTypeByName(roots, typeName);
    }

    public Collection<EObject> getAssociationInverseRefs(DDiagram diagram) {
        return NodeInverseRefsServices.INSTANCE.getAssociationInverseRefs(diagram);
    }

    public List<Property> getClassifierAttributes(Classifier classifier) {
        if (classifier instanceof Profile) {
            return null;
        }
        ArrayList<Property> properties = new ArrayList<Property>();
        for (Property property : classifier.getAttributes()) {
            if (property.getAssociation() != null && property.getAssociation() instanceof Extension) continue;
            properties.add(property);
        }
        return properties;
    }

    public List<Property> getClassifierAttributes(Profile classifier) {
        return null;
    }

    public ElementImport getElementImport(Extension extension) {
        return ExtensionServices.INSTANCE.getElementImport(extension);
    }

    private Class getMetaclass(Property property) {
        Extension extension = null;
        if (property.getAssociation() instanceof Extension) {
            try {
                extension = (Extension)property.getAssociation();
            }
            catch (Exception e) {
                LogServices.INSTANCE.error("getMetaclass(" + property.getClass() + ") not handled", e);
                throw new RuntimeException(e);
            }
        }
        return extension != null ? extension.getMetaclass() : null;
    }

    public Property getSource(Association association) {
        return AssociationServices.INSTANCE.getSource(association);
    }

    public Stereotype getStereotypeSource(Stereotype stereotype) {
        if (stereotype.getAllAttributes() != null && stereotype.getAllAttributes().size() > 1 && ((Property)stereotype.getAllAttributes().get(1)).getType() instanceof Stereotype) {
            return (Stereotype)((Property)stereotype.getAllAttributes().get(1)).getType();
        }
        return null;
    }

    public Stereotype getStereotypeTarget(Stereotype stereotype) {
        if (stereotype.getAllAttributes() != null && stereotype.getAllAttributes().size() > 2 && ((Property)stereotype.getAllAttributes().get(2)).getType() instanceof Stereotype) {
            return (Stereotype)((Property)stereotype.getAllAttributes().get(2)).getType();
        }
        return null;
    }

    public Property getTarget(Association association) {
        return AssociationServices.INSTANCE.getTarget(association);
    }

    public List<PackageableElement> importMetaclass(Profile profile) {
        ArrayList<PackageableElement> alreadyOnProfile = new ArrayList<PackageableElement>();
        ArrayList<String> alreadyOnProfileNames = new ArrayList<String>();
        ImportMetaclassDialog dialog = new ImportMetaclassDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), profile, true);
        dialog.setHeaderMessageText("Select the UML Metaclasses to import.");
        dialog.open();
        if (dialog.getResult() != null) {
            List<Object> selectedObjects = Arrays.asList(dialog.getResult());
            for (Object object : selectedObjects) {
                if (!(object instanceof Class)) continue;
                Class selectedMetaclass = (Class)object;
                PackageableElement importedMember = profile.getImportedMember(selectedMetaclass.getName());
                if (importedMember == null) {
                    profile.createMetaclassReference((PackageableElement)selectedMetaclass);
                    continue;
                }
                alreadyOnProfile.add(importedMember);
                alreadyOnProfileNames.add(importedMember.getName());
            }
        }
        if (alreadyOnProfile.size() > 0) {
            String[] buttonList = new String[]{"Ok"};
            MessageDialog msgDialog = new MessageDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), "Already imported Metaclasses", null, "The following Metaclasses are already imported:\n" + alreadyOnProfileNames, 2, buttonList, 0);
            msgDialog.open();
        }
        return alreadyOnProfile;
    }

    private void initEPackageStereotype(Profile profile) {
        EList allOwningPackages = profile.allOwnedElements();
        Profile ecoreProfile = (Profile)GenericUMLProfileTools.load(URI.createURI((String)"pathmap://UML_PROFILES/Ecore.profile.uml"));
        profile.applyProfile(ecoreProfile);
        Stereotype ePackage = ecoreProfile.getOwnedStereotype("EPackage");
        profile.applyStereotype(ePackage);
        if (profile.getName() != null) {
            profile.setValue(ePackage, "packageName", (Object)profile.getName());
            profile.setValue(ePackage, "nsPrefix", (Object)profile.getName());
            profile.setValue(ePackage, "prefix", (Object)profile.getName());
        }
        profile.setValue(ePackage, NS_URI, (Object)this.rootProfileURI);
        profile.setURI(this.rootProfileURI);
        for (org.eclipse.uml2.uml.Element ownedPackageElement : allOwningPackages) {
            if (!(ownedPackageElement instanceof Package)) continue;
            Package ownedPackage = (Package)ownedPackageElement;
            ownedPackage.applyStereotype(ePackage);
            if (ownedPackage.getName() != null) {
                ownedPackage.setValue(ePackage, "packageName", (Object)ownedPackage.getName());
                ownedPackage.setValue(ePackage, "nsPrefix", (Object)ownedPackage.getName());
                ownedPackage.setValue(ePackage, "prefix", (Object)ownedPackage.getName());
            }
            if (ownedPackage.getURI() != null && profile.getURI().length() != 0) {
                ownedPackage.setValue(ePackage, NS_URI, (Object)ownedPackage.getURI());
                continue;
            }
            ownedPackage.setValue(ePackage, NS_URI, (Object)this.computeURI((NamedElement)ownedPackage));
            ownedPackage.setURI(this.computeURI((NamedElement)ownedPackage));
        }
        GenericUMLProfileTools.save((Package)profile);
    }

    private int initParameters(Profile profile) {
        this.profileName = profile.getName() != null && profile.getName().length() != 0 ? profile.getName().toLowerCase() : DEFAULT_PROFILE_NAME;
        if (profile.getURI() != null && profile.getURI().length() != 0) {
            this.rootProfileURI = String.valueOf(profile.getURI()) + SEPARATOR;
            this.profilePluginName = String.valueOf(this.rootProfileURI.replace("http://", "").replace(SEPARATOR, ".")) + "plugin";
        } else {
            this.rootProfileURI = String.valueOf(OBEO_NETWORK_URI) + this.profileName + SEPARATOR;
            this.profilePluginName = String.valueOf(OBEO_NETWORK_PLUGIN_NAME) + "." + this.profileName + "." + "plugin";
        }
        InitProfilePluginDialog dialog = new InitProfilePluginDialog(this.profileName, this.rootProfileURI, this.profilePluginName);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            this.profileName = dialog.getProfileName();
            this.rootProfileURI = dialog.getRootProfileURI();
            this.profilePluginName = dialog.getProfilePluginName();
            return 0;
        }
        return 1;
    }

    private boolean isProfileRoot(Profile rootProfile) {
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)rootProfile);
        return rootContainer != null && rootContainer instanceof Profile;
    }

    private void undefineProfile(Profile rootProfile) {
        if (rootProfile.getDefinition() != null) {
            List<Profile> allContentProfile = ProfileServices.INSTANCE.getAllSubProfiles(rootProfile);
            rootProfile.getEAnnotations().remove((Object)rootProfile.getDefinition().eContainer());
            for (Profile profile : allContentProfile) {
                if (profile.getDefinition() == null) continue;
                profile.getEAnnotations().remove((Object)profile.getDefinition().eContainer());
            }
        }
    }

    public void undefineProfileDialog(Profile rootProfile) {
        String[] buttonYesNo = new String[]{YES, NO};
        String[] buttonYes = new String[]{OK};
        Shell activeShell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        MessageDialog msgDialogYesNo = null;
        MessageDialog msgDialogYes = null;
        if (rootProfile.getDefinition() != null) {
            msgDialogYesNo = new MessageDialog(activeShell, UNDEFINE_PROFILE, null, "Would you like to undefine this profile ?", 3, buttonYesNo, 1);
            int diagResult = msgDialogYesNo.open();
            if (diagResult == 0) {
                this.undefineProfile(rootProfile);
                msgDialogYes = new MessageDialog(activeShell, UNDEFINE_PROFILE, null, "The profile is undefined", 2, buttonYes, 0);
                msgDialogYes.open();
            }
        } else {
            msgDialogYes = new MessageDialog(activeShell, UNDEFINE_PROFILE, null, "The profile is not defined !", 4, buttonYes, 0);
            msgDialogYes.open();
        }
    }

    private boolean validateEObjectWithProgress(EObject eObject) {
        ValidateEmfElement validateAction = new ValidateEmfElement();
        StructuredSelection selection = new StructuredSelection((Object)eObject);
        validateAction.updateSelection((IStructuredSelection)selection);
        validateAction.setActiveWorkbenchPart((IWorkbenchPart)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor());
        validateAction.run();
        return validateAction.getDiagnosticResult();
    }

    private boolean validateUmlElementWithProgress(Profile element) {
        ValidateUMLElement umlValidator = new ValidateUMLElement();
        umlValidator.validateUMLmodel((EObject)element);
        return umlValidator.getDiagnosticResult();
    }
}

