/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.dsl.uml2.design.api.services;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.ContainerLayout;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.AssociationClass;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehaviorExecutionSpecification;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.util.UMLSwitch;
import org.obeonetwork.dsl.uml2.design.api.services.AbstractDiagramServices;
import org.obeonetwork.dsl.uml2.design.api.wizards.ModelElementsSelectionDialog;
import org.obeonetwork.dsl.uml2.design.internal.listeners.UmlDesignerSessionManagerListener;
import org.obeonetwork.dsl.uml2.design.internal.services.DirectEditLabelSwitch;
import org.obeonetwork.dsl.uml2.design.internal.services.ElementServices;
import org.obeonetwork.dsl.uml2.design.internal.services.LabelServices;
import org.obeonetwork.dsl.uml2.design.internal.services.MoveDownElementSwitch;
import org.obeonetwork.dsl.uml2.design.internal.services.MoveUpElementSwitch;
import org.obeonetwork.dsl.uml2.design.internal.services.StereotypeServices;
import org.obeonetwork.dsl.uml2.design.internal.services.UIServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReusedDescriptionServices
extends AbstractDiagramServices {
    final Map<EObject, Boolean> isOrHasDescendantCache = UmlDesignerSessionManagerListener.getDescendantCache();

    public void addDirectChildren(Element root, DNode rootView) {
        EList semanticElements = root.getOwnedElements();
        DDiagram diagram = rootView.getParentDiagram();
        this.addExistingElements((EObject)diagram, (List<Element>)semanticElements, "[elementView.oclAsType(DNode).getParentDiagram()/]");
    }

    private void addExistingElements(EObject containerView, List<Element> semanticElements, String containerViewExpression) {
        if (!(containerView instanceof DSemanticDecorator) || semanticElements == null || semanticElements.isEmpty()) {
            return;
        }
        Session session = SessionManager.INSTANCE.getSession((EObject)semanticElements.get(0));
        for (EObject eObject : this.orderParentFirst(semanticElements)) {
            this.markForAutosize(eObject);
            this.showView(eObject, (DSemanticDecorator)containerView, session, containerViewExpression);
        }
    }

    public Element applyAllStereotypes(Element element, List<Stereotype> stereotypesToApply) {
        return StereotypeServices.INSTANCE.applyAllStereotypes(element, stereotypesToApply);
    }

    public boolean areEcorePrimitiveTypesNotImported(NamedElement element) {
        return !this.arePrimitiveTypesImported(element, "pathmap://UML_LIBRARIES/EcorePrimitiveTypes.library.uml");
    }

    public boolean areJavaPrimitiveTypesNotImported(NamedElement element) {
        return !this.arePrimitiveTypesImported(element, "pathmap://UML_LIBRARIES/JavaPrimitiveTypes.library.uml");
    }

    private boolean arePrimitiveTypesImported(NamedElement element, String libraryUri) {
        Namespace namespace = ElementServices.INSTANCE.getNamespace(element);
        ResourceSet resourceSet = namespace.eResource().getResourceSet();
        Resource resource = resourceSet.getResource(URI.createURI((String)libraryUri), true);
        Package root = (Package)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)UMLPackage.Literals.PACKAGE);
        return namespace.getImportedPackages().contains((Object)root);
    }

    public boolean areUmlPrimitiveTypesNotImported(NamedElement element) {
        return !this.arePrimitiveTypesImported(element, "pathmap://UML_LIBRARIES/UMLPrimitiveTypes.library.uml");
    }

    public boolean areXmlPrimitiveTypesNotImported(NamedElement element) {
        return !this.arePrimitiveTypesImported(element, "pathmap://UML_LIBRARIES/XMLPrimitiveTypes.library.uml");
    }

    public String computeUmlDirectEditLabel(Element element) {
        DirectEditLabelSwitch directEditLabel = new DirectEditLabelSwitch();
        return (String)directEditLabel.doSwitch((EObject)element);
    }

    public Interaction createInteraction(EObject pkg) {
        UMLFactory factory = UMLFactory.eINSTANCE;
        Interaction interaction = factory.createInteraction();
        interaction.setName(ElementServices.INSTANCE.getNewInteractionName(pkg));
        ((Package)pkg).getPackagedElements().add((Object)interaction);
        return interaction;
    }

    public Element editUmlLabel(Element context, String editedLabelContent) {
        return LabelServices.INSTANCE.editUmlLabel(context, editedLabelContent);
    }

    private Activity getActivity(NamedElement parent) {
        if (parent.eContents() != null && parent.eContents().size() > 0) {
            for (EObject obj : parent.eContents()) {
                if (!(obj instanceof Activity)) continue;
                return (Activity)obj;
            }
        }
        Activity activity = UMLFactory.eINSTANCE.createActivity();
        String activityLabel = String.valueOf(parent.getName()) + " activity";
        activity.setName(activityLabel);
        return activity;
    }

    public Collection<Association> getAllAssociations(Classifier classifier) {
        ArrayList<Association> result = new ArrayList<Association>();
        for (EObject child : classifier.getRelationships()) {
            if (!(child instanceof Association) || child instanceof AssociationClass) continue;
            result.add((Association)child);
        }
        return result;
    }

    public Collection<Profile> getAllProfilesInPlatform(Element element) {
        Package package_ = element.getNearestPackage();
        final ArrayList roots = Lists.newArrayList();
        final Package packageUML = package_;
        ResourceSet resourceSet = packageUML.eResource().getResourceSet();
        for (URI profileURI : UMLPlugin.getEPackageNsURIToProfileLocationMap().values()) {
            try {
                resourceSet.getResource(profileURI.trimFragment(), true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (Resource resource : resourceSet.getResources()) {
            TreeIterator allContents = resource.getAllContents();
            while (allContents.hasNext()) {
                new UMLSwitch<Object>(){

                    public Object caseProfile(Profile profile) {
                        if (profile.isDefined()) {
                            packageUML.getProfileApplication(profile);
                            roots.add(profile);
                        }
                        return profile;
                    }
                }.doSwitch((EObject)allContents.next());
            }
        }
        return roots;
    }

    private List<Stereotype> getAllStereotypes(Element element, Collection<Profile> profiles) {
        ArrayList stereotypes = Lists.newArrayList();
        for (Profile profile : profiles) {
            Package pkg = element.getNearestPackage();
            boolean isProfileApplied = false;
            if (pkg.isProfileApplied(profile)) {
                isProfileApplied = true;
            }
            if (!isProfileApplied) {
                pkg.applyProfile(profile);
            }
            stereotypes.addAll(element.getApplicableStereotypes());
            if (isProfileApplied) continue;
            pkg.unapplyProfile(profile);
        }
        return stereotypes;
    }

    public List<EObject> getAllStereotypesAndProfiles(Element element) {
        ArrayList stereotypesAndProfiles = Lists.newArrayList();
        Collection<Profile> profiles = this.getAllProfilesInPlatform(element);
        stereotypesAndProfiles.addAll(this.getAllStereotypes(element, profiles));
        stereotypesAndProfiles.addAll(profiles);
        return stereotypesAndProfiles;
    }

    public Package getClassDiagramFromExecution(BehaviorExecutionSpecification execution) {
        BehavioralFeature feature;
        Behavior behavior;
        if (execution != null && (behavior = execution.getBehavior()) != null && (feature = behavior.getSpecification()) != null) {
            return feature.getNearestPackage();
        }
        return null;
    }

    public Package getClassDiagramFromLifeline(Lifeline lifeline) {
        Type type;
        ConnectableElement element;
        if (lifeline != null && (element = lifeline.getRepresents()) != null && (type = element.getType()) != null) {
            return type.getPackage();
        }
        return null;
    }

    public List<Comment> getCommentsOnVisibleGraphicalElements(DDiagram diagram) {
        EObject target;
        ArrayList<Comment> result = new ArrayList<Comment>();
        if (diagram instanceof DSemanticDecorator && (target = ((DSemanticDecorator)diagram).getTarget()) instanceof Element) {
            result.addAll((Collection<Comment>)((Element)target).getOwnedComments());
        }
        for (DDiagramElement elt : diagram.getOwnedDiagramElements()) {
            if (!elt.isVisible() || !(elt.getTarget() instanceof Element) || ((Element)elt.getTarget()).getOwnedComments().isEmpty()) continue;
            result.addAll((Collection<Comment>)((Element)elt.getTarget()).getOwnedComments());
        }
        return result;
    }

    public DSemanticDecorator getContainerView(Element semanticElement, DDiagramElement elementView) {
        DSemanticDecorator diagram = (DSemanticDecorator)elementView.getParentDiagram();
        return this.getContainerView(semanticElement, diagram);
    }

    public DSemanticDecorator getContainerView(Element semanticElement, DDiagramElementContainer elementView) {
        DSemanticDecorator diagram = (DSemanticDecorator)elementView.getParentDiagram();
        return this.getContainerView(semanticElement, diagram);
    }

    private DSemanticDecorator getContainerView(Element semanticElement, DSemanticDecorator diagram) {
        EList containerViews = ((DDiagram)diagram).getContainers();
        for (DDiagramElementContainer containerView : containerViews) {
            if (!containerView.getTarget().equals(semanticElement.getOwner()) || ContainerLayout.LIST.equals((Object)containerView.getActualMapping().getChildrenPresentation())) continue;
            return containerView;
        }
        return diagram;
    }

    public DSemanticDecorator getContainerView(Element semanticElement, DSemanticDiagram elementView) {
        DSemanticDiagram diagram = elementView;
        return this.getContainerView(semanticElement, (DSemanticDecorator)diagram);
    }

    private Predicate getNonSelectablePredicate(DDiagram diagram) {
        return Predicates.in(UIServices.INSTANCE.getDisplayedNodes(diagram));
    }

    private Profile getProfile(NamedElement parent) {
        Profile profile = UMLFactory.eINSTANCE.createProfile();
        String profileLabel = String.valueOf(parent.getName()) + " profile";
        profile.setName(profileLabel);
        return profile;
    }

    private StateMachine getStatemachine(NamedElement parent) {
        if (parent.eContents() != null && parent.eContents().size() > 0) {
            for (EObject obj : parent.eContents()) {
                if (!(obj instanceof StateMachine)) continue;
                return (StateMachine)obj;
            }
        }
        StateMachine statemachine = UMLFactory.eINSTANCE.createStateMachine();
        String statemachineLabel = String.valueOf(parent.getName()) + " statemachine";
        Region region = UMLFactory.eINSTANCE.createRegion();
        region.setName("Region1");
        statemachine.getRegions().add((Object)region);
        statemachine.setName(statemachineLabel);
        return statemachine;
    }

    public void importEcorePrimitiveTypes(NamedElement element) {
        ElementServices.INSTANCE.importEcorePrimitiveTypes(element);
    }

    public void importJavaPrimitiveTypes(NamedElement element) {
        ElementServices.INSTANCE.importJavaPrimitiveTypes(element);
    }

    public void importUmlPrimitiveTypes(NamedElement element) {
        ElementServices.INSTANCE.importUmlPrimitiveTypes(element);
    }

    public void importXmlPrimitiveTypes(NamedElement element) {
        ElementServices.INSTANCE.importXmlPrimitiveTypes(element);
    }

    public Activity initActivityForClass(BehavioredClassifier parent) {
        Activity activity = this.getActivity((NamedElement)parent);
        parent.getOwnedBehaviors().add((Object)activity);
        return activity;
    }

    public Activity initActivityForOperation(Operation op) {
        if (op.getMethods() != null && op.getMethods().size() > 0) {
            for (Behavior behavior : op.getMethods()) {
                if (!(behavior instanceof Activity)) continue;
                return (Activity)behavior;
            }
        }
        Activity activity = UMLFactory.eINSTANCE.createActivity();
        String activityLabel = String.valueOf(op.getName()) + " activity";
        activity.setName(activityLabel);
        op.getClass_().getOwnedBehaviors().add((Object)activity);
        op.getMethods().add((Object)activity);
        return activity;
    }

    public Activity initActivityForPackage(Package pkg) {
        Activity activity = this.getActivity((NamedElement)pkg);
        pkg.getPackagedElements().add((Object)activity);
        return activity;
    }

    public Profile initProfileForPackage(Package pkg) {
        Profile profile = this.getProfile((NamedElement)pkg);
        pkg.getPackagedElements().add((Object)profile);
        return profile;
    }

    public StateMachine initStatemachineForClass(BehavioredClassifier parent) {
        StateMachine statemachine = this.getStatemachine((NamedElement)parent);
        parent.getOwnedBehaviors().add((Object)statemachine);
        return statemachine;
    }

    public StateMachine initStatemachineForPackage(Package pkg) {
        StateMachine statemachine = this.getStatemachine((NamedElement)pkg);
        pkg.getPackagedElements().add((Object)statemachine);
        return statemachine;
    }

    public boolean isComponent(EObject element) {
        return ElementServices.INSTANCE.isComponent(element);
    }

    public boolean isNotDiagram(EObject containerView) {
        if (containerView instanceof DNode) {
            DNode dnode = (DNode)containerView;
            return !"Empty Diagram".equals(dnode.getActualMapping().getName());
        }
        return !(containerView instanceof DDiagram);
    }

    public boolean isValidContainerMapping(EObject containerView) {
        if (containerView instanceof DDiagramElementContainer) {
            return !ContainerLayout.LIST.equals((Object)((DDiagramElementContainer)containerView).getActualMapping().getChildrenPresentation());
        }
        return containerView instanceof DDiagram;
    }

    public void moveDownOperations(Operation currentOperation, List<Operation> operationsToMove) {
        List<Operation> operationsInRightOrder = this.retrieveTheRightOrderForOperation(operationsToMove);
        Object[] operationsArray = operationsInRightOrder.toArray();
        MoveDownElementSwitch moveDownElementSwitch = new MoveDownElementSwitch();
        int i = operationsArray.length - 1;
        while (i >= 0) {
            if (operationsArray[i] instanceof Operation) {
                moveDownElementSwitch.moveDownElement((EObject)((Operation)operationsArray[i]));
            }
            --i;
        }
    }

    public void moveDownPackageableElements(List<PackageableElement> packageableElementsToMove) {
        MoveDownElementSwitch moveDownElementSwitch = new MoveDownElementSwitch();
        List<PackageableElement> packageableElementsInRightOrder = this.retrieveTheRightOrderForPackageableElement(packageableElementsToMove);
        Object[] elementsArray = packageableElementsInRightOrder.toArray();
        int i = elementsArray.length - 1;
        while (i >= 0) {
            if (elementsArray[i] instanceof Element) {
                moveDownElementSwitch.moveDownElement((EObject)((Element)elementsArray[i]));
            }
            --i;
        }
    }

    public void moveDownProperties(Property currentProperty, List<Property> propertiesToMove) {
        List<Property> propertiesInRightOrder = this.retrieveTheRightOrderForProperties(propertiesToMove);
        Object[] propertiesArray = propertiesInRightOrder.toArray();
        MoveDownElementSwitch moveDownElementSwitch = new MoveDownElementSwitch();
        int i = propertiesArray.length - 1;
        while (i >= 0) {
            if (propertiesArray[i] instanceof Property) {
                moveDownElementSwitch.moveDownElement((EObject)((Property)propertiesArray[i]));
            }
            --i;
        }
    }

    public void moveUpOperations(Operation currentOperation, List<Operation> operationsToMove) {
        List<Operation> operationsInRightOrder = this.retrieveTheRightOrderForOperation(operationsToMove);
        MoveUpElementSwitch moveUpElementsSwitch = new MoveUpElementSwitch();
        for (Operation operation : operationsInRightOrder) {
            moveUpElementsSwitch.moveUpElement((EObject)operation);
        }
    }

    public void moveUpPackageableElements(PackageableElement packageableElement, List<PackageableElement> packageableElementsToMove) {
        MoveUpElementSwitch moveUpElementsSwitch = new MoveUpElementSwitch();
        List<PackageableElement> packageableElementsInRightOrder = this.retrieveTheRightOrderForPackageableElement(packageableElementsToMove);
        for (Element element : packageableElementsInRightOrder) {
            moveUpElementsSwitch.moveUpElement((EObject)element);
        }
    }

    public void moveUpProperties(Property currentProperty, List<Property> propertiesToMove) {
        List<Property> propertiesInRightOrder = this.retrieveTheRightOrderForProperties(propertiesToMove);
        MoveUpElementSwitch moveUpElementsSwitch = new MoveUpElementSwitch();
        for (Property property : propertiesInRightOrder) {
            moveUpElementsSwitch.moveUpElement((EObject)property);
        }
    }

    public void openSelectExistingElementsDialog(EObject selectedContainer, DSemanticDecorator selectedContainerView, DDiagram diagram) {
        ModelElementsSelectionDialog dlg = new ModelElementsSelectionDialog("Add existing elements", "Select elements to add in current representation.");
        dlg.setGrayedPredicate((Predicate<EObject>)this.getNonSelectablePredicate(diagram));
        List<Object> elementsToAdd = dlg.open(PlatformUI.getWorkbench().getDisplay().getActiveShell(), selectedContainer, diagram, true);
        if (elementsToAdd.size() > 0) {
            this.addExistingElements((EObject)selectedContainerView, elementsToAdd, "[self.getContainerView(elementView)/]");
        }
    }

    private List<Element> orderParentFirst(List<Element> semanticElements) {
        LinkedList orderedElements = Lists.newLinkedList();
        for (Element element : semanticElements) {
            if (orderedElements.contains(element.getOwner())) {
                orderedElements.add(orderedElements.indexOf(element.getOwner()), element);
                continue;
            }
            orderedElements.addLast(element);
        }
        return Lists.reverse((List)orderedElements);
    }

    public void paste(Element container, Element semanticElement, DSemanticDecorator elementView, DSemanticDecorator containerView) {
        Session session = SessionManager.INSTANCE.getSession((EObject)container);
        TransactionalEditingDomain domain = session.getTransactionalEditingDomain();
        Command cmd = AddCommand.create((EditingDomain)domain, (Object)container, null, (Object)semanticElement);
        if (cmd.canExecute()) {
            cmd.execute();
        }
        this.markForAutosize((EObject)semanticElement);
        EList semanticElements = ((DRepresentationElement)elementView).getSemanticElements();
        ArrayList stereotypesToApply = Lists.newArrayList();
        for (EObject eObject : semanticElements) {
            if (!(eObject instanceof Stereotype)) continue;
            stereotypesToApply.add((Stereotype)eObject);
        }
        this.applyAllStereotypes(semanticElement, stereotypesToApply);
        this.createView((EObject)semanticElement, containerView, session, "var:containerView");
    }

    public DRepresentation refreshDiagram(DRepresentation representation) {
        DialectManager.INSTANCE.refresh(representation, (IProgressMonitor)new NullProgressMonitor());
        return representation;
    }

    private List<Operation> retrieveTheRightOrderForOperation(List<Operation> operationsInWrongOrder) {
        ArrayList<Operation> operationsInRightOrder = new ArrayList<Operation>();
        ArrayList<EObject> eContainers = new ArrayList<EObject>();
        for (Operation operation : operationsInWrongOrder) {
            EObject eContainer = operation.eContainer();
            if (eContainer == null || eContainers.contains(eContainer)) continue;
            eContainers.add(eContainer);
        }
        for (EObject eContainer : eContainers) {
            if (!(eContainer instanceof Class) && !(eContainer instanceof Interface)) continue;
            EList operations = null;
            if (eContainer instanceof Class) {
                Class eclass = (Class)eContainer;
                operations = eclass.getOwnedOperations();
            } else {
                Interface eInterface = (Interface)eContainer;
                operations = eInterface.getOwnedOperations();
            }
            for (Operation operation : operations) {
                if (!operationsInWrongOrder.contains(operation)) continue;
                operationsInRightOrder.add(operation);
            }
        }
        return operationsInRightOrder;
    }

    private List<PackageableElement> retrieveTheRightOrderForPackageableElement(List<PackageableElement> packageableElementsInWrongOrder) {
        ArrayList<PackageableElement> packageableElementsInRightOrder = new ArrayList<PackageableElement>();
        ArrayList<EObject> eContainers = new ArrayList<EObject>();
        for (PackageableElement packageableElement : packageableElementsInWrongOrder) {
            EObject eContainer = packageableElement.eContainer();
            if (eContainer == null || eContainers.contains(eContainer)) continue;
            eContainers.add(eContainer);
        }
        for (EObject eContainer : eContainers) {
            if (!(eContainer instanceof Package) && !(eContainer instanceof Component)) continue;
            EList packageableElements = null;
            if (eContainer instanceof Package) {
                Package ePackage = (Package)eContainer;
                packageableElements = ePackage.getPackagedElements();
            } else {
                Component component = (Component)eContainer;
                packageableElements = component.getPackagedElements();
            }
            for (PackageableElement packageableElement : packageableElements) {
                if (!packageableElementsInWrongOrder.contains(packageableElement)) continue;
                packageableElementsInRightOrder.add(packageableElement);
            }
        }
        return packageableElementsInRightOrder;
    }

    private List<Property> retrieveTheRightOrderForProperties(List<Property> propertiesInWrongOrder) {
        ArrayList<Property> propertiesInRightOrder = new ArrayList<Property>();
        ArrayList<EObject> eContainers = new ArrayList<EObject>();
        for (Property property : propertiesInWrongOrder) {
            EObject eContainer = property.eContainer();
            if (eContainer == null || eContainers.contains(eContainer)) continue;
            eContainers.add(eContainer);
        }
        for (EObject eContainer : eContainers) {
            if (!(eContainer instanceof StructuredClassifier)) continue;
            EList properties = ((StructuredClassifier)eContainer).getOwnedAttributes();
            for (Property property : properties) {
                if (!propertiesInWrongOrder.contains(property)) continue;
                propertiesInRightOrder.add(property);
            }
        }
        return propertiesInRightOrder;
    }

    public Element unApplyAllStereotypes(Element element) {
        return this.applyAllStereotypes(element, null);
    }
}

